/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.chat.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.chat.LiveBadWordRequest;
import net.polyv.live.v1.entity.chat.LiveBadWordResponse;
import net.polyv.live.v1.entity.chat.LiveChatBannedIPRequest;
import net.polyv.live.v1.entity.chat.LiveChatDelSingleMsgRequest;
import net.polyv.live.v1.entity.chat.LiveCleanChannelAllMsgRequest;
import net.polyv.live.v1.entity.chat.LiveDelBannedDataRequest;
import net.polyv.live.v1.entity.chat.LiveGetAccountBadWordRequest;
import net.polyv.live.v1.entity.chat.LiveGetBadwordIPRequest;
import net.polyv.live.v1.entity.chat.LiveGetBannedListRequest;
import net.polyv.live.v1.entity.chat.LiveGetChatAdminDataRequest;
import net.polyv.live.v1.entity.chat.LiveGetChatAdminDataResponse;
import net.polyv.live.v1.entity.chat.LiveGetConsultingRecordRequest;
import net.polyv.live.v1.entity.chat.LiveGetConsultingRecordResponse;
import net.polyv.live.v1.entity.chat.LiveGetHistoryChatMsgRequest;
import net.polyv.live.v1.entity.chat.LiveGetHistoryChatMsgResponse;
import net.polyv.live.v1.entity.chat.LiveGetQuestionStatisticalRequest;
import net.polyv.live.v1.entity.chat.LiveGetQuestionStatisticalResponse;
import net.polyv.live.v1.entity.chat.LiveKickedListRequest;
import net.polyv.live.v1.entity.chat.LiveKickedListResponse;
import net.polyv.live.v1.entity.chat.LiveSendChatMsgRequest;
import net.polyv.live.v1.entity.chat.LiveSendChatMsgResponse;
import net.polyv.live.v1.entity.chat.LiveSetChatAdminDataRequest;
import net.polyv.live.v1.entity.chat.LiveSetTeacherDataRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.chat.ILiveChatRoomService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveChatRoomServiceImpl
extends LiveBaseService
implements ILiveChatRoomService {
    private static final Logger log = LoggerFactory.getLogger(LiveChatRoomServiceImpl.class);

    @Override
    public LiveSendChatMsgResponse sendChatMsg(LiveSendChatMsgRequest liveSendChatMsgRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/chat/send-admin-msg";
        return super.basePost(url, liveSendChatMsgRequest, LiveSendChatMsgResponse.class);
    }

    @Override
    public Boolean setChannelTeacherMsg(LiveSetTeacherDataRequest liveSetTeacherDataRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/account/updateTeacher";
        return super.basePost(url, liveSetTeacherDataRequest, Boolean.class);
    }

    @Override
    public List<String> addBannedIP(LiveChatBannedIPRequest liveChatBannedIPRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/addBannedIP", liveChatBannedIPRequest.getChannelId());
        return super.basePostReturnArray(url, liveChatBannedIPRequest, String.class);
    }

    @Override
    public LiveBadWordResponse addBadWord(LiveBadWordRequest liveBadWordRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/addBadWords", LiveGlobalConfig.getUserId());
        return super.basePost(url, liveBadWordRequest, LiveBadWordResponse.class);
    }

    @Override
    public List<String> getBannedList(LiveGetBannedListRequest liveGetBannedListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/chat/get-banned-list";
        return super.baseGetReturnArray(url, liveGetBannedListRequest, String.class);
    }

    @Override
    public List<LiveKickedListResponse> getKickedList(LiveKickedListRequest liveKickedListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/chat/list-kicked";
        return super.basePostReturnArray(url, liveKickedListRequest, LiveKickedListResponse.class);
    }

    @Override
    public Boolean delBanned(LiveDelBannedDataRequest liveDelBannedDataRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/delBanned", liveDelBannedDataRequest.getChannelId());
        return "success".equalsIgnoreCase(super.basePost(url, liveDelBannedDataRequest, String.class));
    }

    @Override
    public List<String> getChannelBadworkList(LiveGetBadwordIPRequest liveGetBadwordIPRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/badword/list";
        return super.basePostReturnArray(url, liveGetBadwordIPRequest, String.class);
    }

    @Override
    public List<String> getAccountBadworkList(LiveGetAccountBadWordRequest liveGetAccountBadWordRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/badword/list";
        return super.baseGetReturnArray(url, liveGetAccountBadWordRequest, String.class);
    }

    @Override
    public Boolean cleanChannelAllMsg(LiveCleanChannelAllMsgRequest liveCleanChannelAllMsgRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/cleanChat", liveCleanChannelAllMsgRequest.getChannelId());
        return super.baseGet(url, liveCleanChannelAllMsgRequest, Boolean.class);
    }

    @Override
    public LiveGetChatAdminDataResponse getChatAdminData(LiveGetChatAdminDataRequest liveGetChatAdminDataRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/get-chat-admin", liveGetChatAdminDataRequest.getChannelId());
        return super.basePost(url, liveGetChatAdminDataRequest, LiveGetChatAdminDataResponse.class);
    }

    @Override
    public List<LiveGetHistoryChatMsgResponse> getHistoryChatMsg(LiveGetHistoryChatMsgRequest liveGetHistoryChatMsgRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/getHistory", liveGetHistoryChatMsgRequest.getChannelId());
        return super.basePostReturnArray(url, liveGetHistoryChatMsgRequest, LiveGetHistoryChatMsgResponse.class);
    }

    @Override
    public Boolean delChatSingleMsg(LiveChatDelSingleMsgRequest liveChatDelSingleMsgRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/delChat", liveChatDelSingleMsgRequest.getChannelId());
        return "success".equalsIgnoreCase(super.baseGet(url, liveChatDelSingleMsgRequest, String.class));
    }

    @Override
    public Boolean setChatAdminData(LiveSetChatAdminDataRequest liveSetChatAdminDataRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/set-chat-admin", liveSetChatAdminDataRequest.getChannelId());
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("avatar", liveSetChatAdminDataRequest.getAvatar());
        return "\u4fee\u6539\u6210\u529f".equalsIgnoreCase(super.baseUploadFile(url, liveSetChatAdminDataRequest, fileMap, String.class));
    }

    @Override
    public List<LiveGetConsultingRecordResponse> getConsultingRecord(LiveGetConsultingRecordRequest liveGetConsultingRecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/chat/%s/getQuestion", liveGetConsultingRecordRequest.getChannelId());
        return super.baseGetReturnArray(url, liveGetConsultingRecordRequest, LiveGetConsultingRecordResponse.class);
    }

    @Override
    public List<LiveGetQuestionStatisticalResponse> getQuestionStatistical(LiveGetQuestionStatisticalRequest liveGetQuestionStatisticalRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/get-question-result", liveGetQuestionStatisticalRequest.getChannelId());
        return super.basePostReturnArray(url, liveGetQuestionStatisticalRequest, LiveGetQuestionStatisticalResponse.class);
    }
}

