/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.util;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveSignUtil {
    private static final Logger log = LoggerFactory.getLogger(LiveSignUtil.class);

    private LiveSignUtil() {
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String setLiveSign(Map<String, String> params, String appId, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign = LiveSignUtil.getSign(params, appId, appSecret);
        params.put("sign", sign);
        return sign;
    }

    public static String getSign(Map<String, String> params, String appId, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        params.put("appId", appId);
        log.debug("\u53c2\u4e0e\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        String concatStr = LiveSignUtil.concatParams(params);
        String plain = appSecret + concatStr + appSecret;
        log.debug("\u7b7e\u540d\u539f\u59cb\u5b57\u7b26\u4e32\uff1a{}", (Object)plain);
        String encrypted = LiveSignUtil.md5Hex(plain).toUpperCase();
        log.debug("\u7b7e\u540d\u7ed3\u679c\uff1a {}", (Object)encrypted);
        return encrypted;
    }

    public static String concatParams(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = params.get(key);
            if (StringUtils.isBlank(value)) continue;
            sb.append(key).append(value);
        }
        return sb.toString();
    }

    public static String md5Hex(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] inputByteArray = text.getBytes("UTF-8");
        messageDigest.update(inputByteArray);
        byte[] resultByteArray = messageDigest.digest();
        return LiveSignUtil.byteArrayToHex(resultByteArray).toLowerCase();
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static String mapJoinNotEncode(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value)) continue;
            if (0 != i) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(map.get(key));
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String mapJoinEncode(Map<String, String> map, boolean keyLower, boolean valueUrlEncode) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value)) continue;
            String temp = key.endsWith("_") && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
            stringBuilder.append(keyLower ? temp.toLowerCase() : temp).append("=").append(valueUrlEncode ? URLEncoder.encode(value, "UTF-8").replace("+", "%20") : value).append("&");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

