/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.constant.LiveURL;
import net.polyv.live.entity.channel.viewdata.LiveChannelMaxHistoryConcurrentRequest;
import net.polyv.live.entity.channel.viewdata.LiveChannelViewerConcurrenceRequest;
import net.polyv.live.entity.channel.viewdata.LiveChannelViewerConcurrenceResponse;
import net.polyv.live.entity.channel.viewdata.LiveListChannelMicRequest;
import net.polyv.live.entity.channel.viewdata.LiveListChannelMicResponse;
import net.polyv.live.entity.channel.viewdata.LiveListChannelSummaryRequest;
import net.polyv.live.entity.channel.viewdata.LiveListChannelSummaryResponse;
import net.polyv.live.entity.channel.viewdata.LiveListChannelViewerCountRequest;
import net.polyv.live.entity.channel.viewdata.LiveListChannelViewerCountResponse;
import net.polyv.live.entity.channel.viewdata.LiveListChannelViewlogRequest;
import net.polyv.live.entity.channel.viewdata.LiveListChannelViewlogResponse;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.channel.ILiveChannelViewdataService;

public class LiveChannelViewdataServiceImpl
extends LiveBaseService
implements ILiveChannelViewdataService {
    @Override
    public Integer getMaxChannelHistoryConcurrent(LiveChannelMaxHistoryConcurrentRequest liveChannelMaxHistoryConcurrentRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/statistics/get-max-history-concurrent";
        Integer liveChannelMaxHistoryConcurrentResponse = this.baseGet(url, liveChannelMaxHistoryConcurrentRequest, Integer.class);
        return liveChannelMaxHistoryConcurrentResponse;
    }

    @Override
    public LiveListChannelMicResponse listChannelMic(LiveListChannelMicRequest liveListChannelMicRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/statistics/mic/list";
        LiveListChannelMicResponse liveListChannelMicResponse = this.baseGet(url, liveListChannelMicRequest, LiveListChannelMicResponse.class);
        return liveListChannelMicResponse;
    }

    @Override
    public LiveListChannelViewlogResponse listChannelViewlog(LiveListChannelViewlogRequest liveChannelViewlogRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/statistics/%s/viewlog", liveChannelViewlogRequest.getChannelId());
        LiveListChannelViewlogResponse liveListChannelViewlogResponse = this.baseGet(url, liveChannelViewlogRequest, LiveListChannelViewlogResponse.class);
        return liveListChannelViewlogResponse;
    }

    @Override
    public LiveListChannelSummaryResponse listChannelSummary(LiveListChannelSummaryRequest liveListChannelSummaryRequest) throws IOException, NoSuchAlgorithmException {
        liveListChannelSummaryRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/statistics/%s/channel_summary", liveListChannelSummaryRequest.getUserId());
        LiveListChannelSummaryResponse.ChannelSummary[] channelSummaries = this.basePost(url, liveListChannelSummaryRequest, LiveListChannelSummaryResponse.ChannelSummary[].class);
        channelSummaries = channelSummaries == null ? new LiveListChannelSummaryResponse.ChannelSummary[]{} : channelSummaries;
        LiveListChannelSummaryResponse liveListChannelSummaryResponse = new LiveListChannelSummaryResponse();
        liveListChannelSummaryResponse.setChannelSummarys(Arrays.asList(channelSummaries));
        return liveListChannelSummaryResponse;
    }

    @Override
    public LiveListChannelViewerCountResponse listChannelViewerCount(LiveListChannelViewerCountRequest liveListChannelViewerCountRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v2/statistics/get-realtime-viewers";
        LiveListChannelViewerCountResponse.ChannelViewerCount[] channelViewerCounts = this.baseGet(url, liveListChannelViewerCountRequest, LiveListChannelViewerCountResponse.ChannelViewerCount[].class);
        channelViewerCounts = channelViewerCounts == null ? new LiveListChannelViewerCountResponse.ChannelViewerCount[]{} : channelViewerCounts;
        LiveListChannelViewerCountResponse liveListChannelViewerCountResponse = new LiveListChannelViewerCountResponse();
        liveListChannelViewerCountResponse.setChannelViewerCounts(Arrays.asList(channelViewerCounts));
        return liveListChannelViewerCountResponse;
    }

    @Override
    public LiveChannelViewerConcurrenceResponse getChannelViewerConcurrence(LiveChannelViewerConcurrenceRequest liveChannelViewerConcurrenceRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/statistics/concurrence";
        LiveChannelViewerConcurrenceResponse.ChannelViewerConcurrence[] channelViewerConcurrences = this.baseGet(url, liveChannelViewerConcurrenceRequest, LiveChannelViewerConcurrenceResponse.ChannelViewerConcurrence[].class);
        channelViewerConcurrences = channelViewerConcurrences == null ? new LiveChannelViewerConcurrenceResponse.ChannelViewerConcurrence[]{} : channelViewerConcurrences;
        LiveChannelViewerConcurrenceResponse liveChannelViewerConcurrenceResponse = new LiveChannelViewerConcurrenceResponse();
        liveChannelViewerConcurrenceResponse.setChannelViewerConcurrences(Arrays.asList(channelViewerConcurrences));
        return liveChannelViewerConcurrenceResponse;
    }
}

