/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.account.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.constant.LiveURL;
import net.polyv.live.entity.account.LiveAccountInfoRequest;
import net.polyv.live.entity.account.LiveAccountInfoResponse;
import net.polyv.live.entity.account.LiveAccountMicDurationRequest;
import net.polyv.live.entity.account.LiveAccountMicDurationResponse;
import net.polyv.live.entity.account.LiveAccountPlaybackCallbackRequest;
import net.polyv.live.entity.account.LiveAccountRecordCallbackRequest;
import net.polyv.live.entity.account.LiveAccountStreamCallbackRequest;
import net.polyv.live.entity.account.LiveAccountSwitchRequest;
import net.polyv.live.entity.account.LiveAccountSwitchResponse;
import net.polyv.live.entity.account.LiveAccountUserDurationsRequest;
import net.polyv.live.entity.account.LiveAccountUserDurationsResponse;
import net.polyv.live.entity.account.LiveChannelIncomeDetailRequest;
import net.polyv.live.entity.account.LiveChannelIncomeDetailResponse;
import net.polyv.live.entity.account.LiveCreateAccountTokenRequest;
import net.polyv.live.entity.account.LiveCreateCategoryRequest;
import net.polyv.live.entity.account.LiveCreateCategoryResponse;
import net.polyv.live.entity.account.LiveDeleteCategoryRequest;
import net.polyv.live.entity.account.LiveListAccountChannelBasicRequest;
import net.polyv.live.entity.account.LiveListAccountChannelBasicResponse;
import net.polyv.live.entity.account.LiveListAccountDetailRequest;
import net.polyv.live.entity.account.LiveListAccountDetailResponse;
import net.polyv.live.entity.account.LiveListAccountRequest;
import net.polyv.live.entity.account.LiveListAccountResponse;
import net.polyv.live.entity.account.LiveListCategoryRequest;
import net.polyv.live.entity.account.LiveListCategoryResponse;
import net.polyv.live.entity.account.LiveUpdateAccountSwitchRequest;
import net.polyv.live.entity.account.LiveUpdateCategoryRequest;
import net.polyv.live.entity.account.LiveUpdateCategorySortRequest;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.account.ILiveAccountService;

public class LiveAccountServiceImpl
extends LiveBaseService
implements ILiveAccountService {
    @Override
    public LiveListAccountDetailResponse listAccountDetail(LiveListAccountDetailRequest liveListAccountDetailRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/management/list-detail";
        return this.basePost(url, liveListAccountDetailRequest, LiveListAccountDetailResponse.class);
    }

    @Override
    public LiveListAccountResponse listAccount(LiveListAccountRequest liveListAccountRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/channels";
        return this.baseGet(url, liveListAccountRequest, LiveListAccountResponse.class);
    }

    @Override
    public LiveAccountMicDurationResponse getMicDuration(LiveAccountMicDurationRequest liveAccountMicDurationRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/statistics/mic/get-duration";
        return this.baseGet(url, liveAccountMicDurationRequest, LiveAccountMicDurationResponse.class);
    }

    @Override
    public Boolean updateAccountSwitch(LiveUpdateAccountSwitchRequest liveUpdateAccountSwitchRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/switch/update";
        String liveUpdateAccountSwitchResponse = this.basePost(url, liveUpdateAccountSwitchRequest, String.class);
        return "true".equals(liveUpdateAccountSwitchResponse);
    }

    @Override
    public Boolean createAccountToken(LiveCreateAccountTokenRequest liveCreateAccountTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/set-sso-token";
        String liveCreateAccountTokenResponse = this.basePost(url, liveCreateAccountTokenRequest, String.class);
        return "success".equals(liveCreateAccountTokenResponse);
    }

    @Override
    public Boolean updateStreamCallbackUrl(LiveAccountStreamCallbackRequest liveAccountStreamCallbackRequest) throws IOException, NoSuchAlgorithmException {
        liveAccountStreamCallbackRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/user/%s/set-stream-callback", liveAccountStreamCallbackRequest.getUserId());
        String liveAccountStreamCallbackResponse = this.basePost(url, liveAccountStreamCallbackRequest, String.class);
        return "success".equals(liveAccountStreamCallbackResponse);
    }

    @Override
    public Boolean updatePlaybackCallbackUrl(LiveAccountPlaybackCallbackRequest liveAccountPlaybackCallbackRequest) throws IOException, NoSuchAlgorithmException {
        liveAccountPlaybackCallbackRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/user/%s/set-playback-callback", liveAccountPlaybackCallbackRequest.getUserId());
        String liveAccountPlaybackCallbackResponse = this.basePost(url, liveAccountPlaybackCallbackRequest, String.class);
        return "".equals(liveAccountPlaybackCallbackResponse);
    }

    @Override
    public Boolean updateRecordCallbackUrl(LiveAccountRecordCallbackRequest liveAccountRecordCallbackRequest) throws IOException, NoSuchAlgorithmException {
        liveAccountRecordCallbackRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/user/%s/set-record-callback", liveAccountRecordCallbackRequest.getUserId());
        String liveAccountRecordCallbackResponse = this.basePost(url, liveAccountRecordCallbackRequest, String.class);
        return "".equals(liveAccountRecordCallbackResponse);
    }

    @Override
    public LiveAccountSwitchResponse getAccountSwitch(LiveAccountSwitchRequest liveAccountSwitchRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/switch/get";
        LiveAccountSwitchResponse.ChannelSwitch[] channelSwitches = this.baseGet(url, liveAccountSwitchRequest, LiveAccountSwitchResponse.ChannelSwitch[].class);
        channelSwitches = channelSwitches == null ? new LiveAccountSwitchResponse.ChannelSwitch[]{} : channelSwitches;
        return new LiveAccountSwitchResponse().setChannelSwitches(Arrays.asList(channelSwitches));
    }

    @Override
    public LiveListAccountChannelBasicResponse listChannelBasic(LiveListAccountChannelBasicRequest liveListAccountChannelBasicRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/management/list";
        return this.baseGet(url, liveListAccountChannelBasicRequest, LiveListAccountChannelBasicResponse.class);
    }

    @Override
    public LiveAccountUserDurationsResponse getUserDurations(LiveAccountUserDurationsRequest liveAccountUserDurationsRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v2/user/get-user-durations";
        return this.basePost(url, liveAccountUserDurationsRequest, LiveAccountUserDurationsResponse.class);
    }

    @Override
    public LiveCreateCategoryResponse createCategory(LiveCreateCategoryRequest liveCreateCategoryRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/category/create";
        return this.basePost(url, liveCreateCategoryRequest, LiveCreateCategoryResponse.class);
    }

    @Override
    public LiveListCategoryResponse listCategory(LiveListCategoryRequest liveCategoryRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/category/list";
        List<LiveListCategoryResponse.LiveCategory> liveCategories = this.basePostReturnArray(url, liveCategoryRequest, LiveListCategoryResponse.LiveCategory.class);
        LiveListCategoryResponse liveListCategoryResponse = new LiveListCategoryResponse();
        liveListCategoryResponse.setLiveCategories(liveCategories);
        return liveListCategoryResponse;
    }

    @Override
    public Boolean updateCategory(LiveUpdateCategoryRequest liveUpdateCategoryRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/category/update-name";
        String liveUpdateCategoryResponse = this.basePost(url, liveUpdateCategoryRequest, String.class);
        return "".equals(liveUpdateCategoryResponse);
    }

    @Override
    public Boolean deleteCategory(LiveDeleteCategoryRequest liveDeleteCategoryRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/category/delete";
        String liveDeleteCategoryResponse = this.basePost(url, liveDeleteCategoryRequest, String.class);
        return "".equals(liveDeleteCategoryResponse);
    }

    @Override
    public Boolean updateCategorySort(LiveUpdateCategorySortRequest liveUpdateCategorySortRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/category/update-rank";
        String liveUpdateCategorySortResponse = this.basePost(url, liveUpdateCategorySortRequest, String.class);
        return "".equals(liveUpdateCategorySortResponse);
    }

    @Override
    public LiveAccountInfoResponse getAccountInfo(LiveAccountInfoRequest liveAccountInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/user/get-info";
        return this.baseGet(url, liveAccountInfoRequest, LiveAccountInfoResponse.class);
    }

    @Override
    public LiveChannelIncomeDetailResponse getChannelIncomeDetail(LiveChannelIncomeDetailRequest liveChannelIncomeDetailRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelIncomeDetailRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/user/%s/get-income-detail", liveChannelIncomeDetailRequest.getUserId());
        return this.basePost(url, liveChannelIncomeDetailRequest, LiveChannelIncomeDetailResponse.class);
    }
}

