/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;

public class Dump {
    private static final String FILENAME_PREFIX = "ajcore";
    private static final String FILENAME_SUFFIX = "txt";
    public static final String UNKNOWN_FILENAME = "Unknown";
    public static final String DUMP_EXCLUDED = "Excluded";
    public static final String NULL_OR_EMPTY = "Empty";
    private static Class exceptionClass;
    private static IMessage.Kind conditionKind;
    private String reason;
    private String fileName;
    private PrintStream print;
    private static String[] savedCommandLine;
    private static List savedFullClasspath;
    private static IMessageHolder savedMessageHolder;
    private static Map nodes;
    private static String lastDumpFileName;
    static /* synthetic */ Class class$java$lang$Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dump(String reason) {
        String fileName = UNKNOWN_FILENAME;
        Dump dump = null;
        try {
            dump = new Dump(reason);
            fileName = dump.getFileName();
            dump.dumpDefault();
        }
        finally {
            if (dump != null) {
                dump.close();
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpWithException(Throwable th) {
        String fileName = UNKNOWN_FILENAME;
        Dump dump = null;
        try {
            dump = new Dump(th.getClass().getName());
            fileName = dump.getFileName();
            dump.dumpException(th);
        }
        finally {
            if (dump != null) {
                dump.close();
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpOnExit() {
        if (!Dump.shouldDumpOnExit()) {
            return DUMP_EXCLUDED;
        }
        String fileName = UNKNOWN_FILENAME;
        Dump dump = null;
        try {
            dump = new Dump(conditionKind.toString());
            fileName = dump.getFileName();
            dump.dumpDefault();
        }
        finally {
            if (dump != null) {
                dump.close();
            }
        }
        return fileName;
    }

    private static boolean shouldDumpOnExit() {
        return savedMessageHolder == null || savedMessageHolder.hasAnyMessage(conditionKind, true);
    }

    public static void setDumpOnException(boolean b) {
        exceptionClass = b ? (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Dump.class$("java.lang.Throwable")) : class$java$lang$Throwable) : null;
    }

    public static boolean getDumpOnException() {
        return exceptionClass != null;
    }

    public static boolean setDumpOnExit(IMessage.Kind condition) {
        conditionKind = condition;
        return true;
    }

    public static boolean setDumpOnExit(String condition) {
        Iterator i = IMessage.KINDS.iterator();
        while (i.hasNext()) {
            IMessage.Kind kind = (IMessage.Kind)i.next();
            if (!kind.toString().equals(condition)) continue;
            return Dump.setDumpOnExit(kind);
        }
        return false;
    }

    public static IMessage.Kind getDumpOnExit() {
        return conditionKind;
    }

    public static String getLastDumpFileName() {
        return lastDumpFileName;
    }

    public static void saveCommandLine(String[] args) {
        savedCommandLine = new String[args.length];
        System.arraycopy(args, 0, savedCommandLine, 0, args.length);
    }

    public static void saveFullClasspath(List list) {
        savedFullClasspath = list;
    }

    public static void saveMessageHolder(IMessageHolder holder) {
        savedMessageHolder = holder;
    }

    public static void registerNode(Class module, INode newNode) {
        nodes.put(module, newNode);
    }

    private Dump(String reason) {
        this.reason = reason;
        this.openDump();
        this.dumpAspectJProperties();
        this.dumpDumpConfiguration();
    }

    public String getFileName() {
        return this.fileName;
    }

    private void dumpDefault() {
        this.dumpSytemProperties();
        this.dumpCommandLine();
        this.dumpFullClasspath();
        this.dumpCompilerMessages();
        IVisitor dumpVisitor = new IVisitor(){

            public void visitString(String s) {
                Dump.this.println(s);
            }

            public void visitList(List list) {
                Dump.this.println(list);
            }
        };
        Iterator i = nodes.keySet().iterator();
        while (i.hasNext()) {
            Class module = (Class)i.next();
            this.println("---- " + module.getName() + " ----");
            INode dumpNode = (INode)nodes.get(module);
            try {
                dumpNode.accept(dumpVisitor);
            }
            catch (Exception ex) {
                this.println(ex.toString());
            }
        }
    }

    private void dumpException(Throwable th) {
        this.println("---- Exception Information ---");
        this.println(th);
        this.dumpDefault();
    }

    private void dumpAspectJProperties() {
        this.println("---- AspectJ Properties ---");
        this.println("AspectJ Compiler 1.5.0 built on Tuesday Dec 20, 2005 at 12:05:54 GMT");
    }

    private void dumpDumpConfiguration() {
        this.println("---- Dump Properties ---");
        this.println("Dump file: " + this.fileName);
        this.println("Dump reason: " + this.reason);
        this.println("Dump on exception: " + (exceptionClass != null));
        this.println("Dump at exit condition: " + conditionKind);
    }

    private void dumpFullClasspath() {
        this.println("---- Full Classpath ---");
        if (savedFullClasspath != null && savedFullClasspath.size() > 0) {
            Iterator iter = savedFullClasspath.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                File file = new File(fileName);
                this.println(file);
            }
        } else {
            this.println(NULL_OR_EMPTY);
        }
    }

    private void dumpSytemProperties() {
        this.println("---- System Properties ---");
        Properties props = System.getProperties();
        this.println(props);
    }

    private void dumpCommandLine() {
        this.println("---- Command Line ---");
        this.println(savedCommandLine);
    }

    private void dumpCompilerMessages() {
        this.println("---- Compiler Messages ---");
        if (savedMessageHolder != null) {
            Iterator i = savedMessageHolder.getUnmodifiableListView().iterator();
            while (i.hasNext()) {
                IMessage message = (IMessage)i.next();
                this.println(message.toString());
            }
        } else {
            this.println(NULL_OR_EMPTY);
        }
    }

    private void openDump() {
        if (this.print != null) {
            return;
        }
        Date now = new Date();
        this.fileName = "ajcore." + new SimpleDateFormat("yyyyMMdd").format(now) + "." + new SimpleDateFormat("HHmmss.SSS").format(now) + "." + FILENAME_SUFFIX;
        try {
            this.print = new PrintStream(new FileOutputStream(this.fileName), true);
        }
        catch (FileNotFoundException ex) {
            this.print = System.err;
            System.out.println("Dumping to stderr");
            this.fileName = UNKNOWN_FILENAME;
        }
        lastDumpFileName = this.fileName;
    }

    public void close() {
        this.print.close();
    }

    private void println(String s) {
        this.print.println(s);
    }

    private void println(Object[] array) {
        if (array == null) {
            this.println(NULL_OR_EMPTY);
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            this.print.println(array[i]);
        }
    }

    private void println(Properties props) {
        Iterator iter = ((Hashtable)props).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = props.getProperty(key);
            this.print.println(key + "=" + value);
        }
    }

    private void println(Throwable th) {
        th.printStackTrace(this.print);
    }

    private void println(File file) {
        this.print.print(file.getAbsolutePath());
        if (!file.exists()) {
            this.println("(missing)");
        } else if (file.isDirectory()) {
            int count = file.listFiles().length;
            this.println("(" + count + " entries)");
        } else {
            this.println("(" + file.length() + " bytes)");
        }
    }

    private void println(List list) {
        if (list == null || list.isEmpty()) {
            this.println(NULL_OR_EMPTY);
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof Exception) {
                    this.println((Exception)o);
                    continue;
                }
                this.println(o.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        conditionKind = IMessage.ABORT;
        nodes = new HashMap();
        lastDumpFileName = UNKNOWN_FILENAME;
        String exceptionName = System.getProperty("org.aspectj.weaver.Dump.exception", "true");
        if (!exceptionName.equals("false")) {
            Dump.setDumpOnException(true);
        }
        String conditionName = System.getProperty("org.aspectj.weaver.Dump.condition", "true");
        Dump.setDumpOnExit(conditionName);
    }

    public static interface IVisitor {
        public void visitString(String var1);

        public void visitList(List var1);
    }

    public static interface INode {
        public void accept(IVisitor var1);
    }
}

