/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.constant.LiveURL;
import net.polyv.live.entity.channel.state.LiveChannelStreamEndRequest;
import net.polyv.live.entity.channel.state.LiveChannelStreamInfoRequest;
import net.polyv.live.entity.channel.state.LiveChannelStreamInfoResponse;
import net.polyv.live.entity.channel.state.LiveChannelStreamLiveRequest;
import net.polyv.live.entity.channel.state.LiveChannelStreamStatusResponse;
import net.polyv.live.entity.channel.state.LiveCutoffChannelStreamRequest;
import net.polyv.live.entity.channel.state.LiveListChannelStreamStatusRequest;
import net.polyv.live.entity.channel.state.LiveListChannelStreamStatusResponse;
import net.polyv.live.entity.channel.state.LiveResumeChannelStreamRequest;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.channel.ILiveChannelStateService;

public class LiveChannelStateServiceImpl
extends LiveBaseService
implements ILiveChannelStateService {
    @Override
    public Boolean resumeChannelStream(LiveResumeChannelStreamRequest liveResumeChannelStreamRequest) throws IOException, NoSuchAlgorithmException {
        liveResumeChannelStreamRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/stream/%s/resume", liveResumeChannelStreamRequest.getChannelId());
        String liveResumeChannelStreamResponse = this.basePost(url, liveResumeChannelStreamRequest, String.class);
        return "success".equals(liveResumeChannelStreamResponse);
    }

    @Override
    public Boolean cutoffChannelStream(LiveCutoffChannelStreamRequest liveCutoffChannelStreamRequest) throws IOException, NoSuchAlgorithmException {
        liveCutoffChannelStreamRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/stream/%s/cutoff", liveCutoffChannelStreamRequest.getChannelId());
        String liveCutoffChannelStreamResponse = this.basePost(url, liveCutoffChannelStreamRequest, String.class);
        return "success".equals(liveCutoffChannelStreamResponse);
    }

    @Override
    public LiveListChannelStreamStatusResponse listChannelLiveStream(LiveListChannelStreamStatusRequest liveListChannelStreamStatusRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v2/channels/live-status";
        LiveChannelStreamStatusResponse[] liveChannelStreamStatusResponses = this.basePost(url, liveListChannelStreamStatusRequest, LiveChannelStreamStatusResponse[].class);
        if (liveChannelStreamStatusResponses == null) {
            liveChannelStreamStatusResponses = new LiveChannelStreamStatusResponse[]{};
        }
        LiveListChannelStreamStatusResponse liveListChannelStreamStatusResponse = new LiveListChannelStreamStatusResponse();
        liveListChannelStreamStatusResponse.setChannelInfo(Arrays.asList(liveChannelStreamStatusResponses));
        return liveListChannelStreamStatusResponse;
    }

    @Override
    public LiveChannelStreamInfoResponse getChannelStreamInfo(LiveChannelStreamInfoRequest liveChannelStreamInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/monitor/get-stream-info";
        LiveChannelStreamInfoResponse liveChannelStreamInfoResponse = this.baseGet(url, liveChannelStreamInfoRequest, LiveChannelStreamInfoResponse.class);
        return liveChannelStreamInfoResponse;
    }

    @Override
    public Boolean setChannelStreamLive(LiveChannelStreamLiveRequest liveChannelStreamLiveRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelStreamLiveRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/live", liveChannelStreamLiveRequest.getChannelId());
        String liveChannelStreamLiveResponse = this.basePost(url, liveChannelStreamLiveRequest, String.class);
        return "success".equals(liveChannelStreamLiveResponse);
    }

    @Override
    public Boolean setChannelStreamEnd(LiveChannelStreamEndRequest liveChannelStreamEndRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelStreamEndRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/end", liveChannelStreamEndRequest.getChannelId());
        String liveChannelStreamEndResponse = this.basePost(url, liveChannelStreamEndRequest, String.class);
        return "success".equals(liveChannelStreamEndResponse);
    }
}

