/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.constant.LiveURL;
import net.polyv.live.entity.channel.playback.LiveChannelDefaultVideoRequest;
import net.polyv.live.entity.channel.playback.LiveChannelPlaybackEnabledInfoRequest;
import net.polyv.live.entity.channel.playback.LiveChannelPlaybackEnabledRequest;
import net.polyv.live.entity.channel.playback.LiveChannelPlaybackSettingRequest;
import net.polyv.live.entity.channel.playback.LiveChannelVideoListRequest;
import net.polyv.live.entity.channel.playback.LiveChannelVideoListResponse;
import net.polyv.live.entity.channel.playback.LiveChannelVideoOnlyRequest;
import net.polyv.live.entity.channel.playback.LiveChannelVideoOnlyResponse;
import net.polyv.live.entity.channel.playback.LiveChannelVideoSortRequest;
import net.polyv.live.entity.channel.playback.LiveConvertChannelVideoListAsyncRequest;
import net.polyv.live.entity.channel.playback.LiveConvertChannelVideoRequest;
import net.polyv.live.entity.channel.playback.LiveCreateChannelVideoPlaybackRequest;
import net.polyv.live.entity.channel.playback.LiveCreateChannelVideoPlaybackResponse;
import net.polyv.live.entity.channel.playback.LiveDeleteChannelPlaybackVideoRequest;
import net.polyv.live.entity.channel.playback.LiveDeleteChannelVideoRequest;
import net.polyv.live.entity.channel.playback.LiveListChannelSessionInfoRequest;
import net.polyv.live.entity.channel.playback.LiveListChannelSessionInfoResponse;
import net.polyv.live.entity.channel.playback.LiveListChannelVideoLibraryRequest;
import net.polyv.live.entity.channel.playback.LiveListChannelVideoLibraryResponse;
import net.polyv.live.entity.channel.playback.LiveMergeChannelVideoAsyncRequest;
import net.polyv.live.entity.channel.playback.LiveMergeChannelVideoRequest;
import net.polyv.live.entity.channel.playback.LiveMergeMp4RecordRequest;
import net.polyv.live.entity.channel.playback.LiveMergeMp4RecordResponse;
import net.polyv.live.entity.channel.playback.LiveUpdatePlaybackTitleRequest;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.channel.ILiveChannelPlaybackService;
import net.polyv.live.util.MapUtil;

public class LiveChannelPlaybackServiceImpl
extends LiveBaseService
implements ILiveChannelPlaybackService {
    @Override
    public LiveCreateChannelVideoPlaybackResponse addChannelVideoPlayback(LiveCreateChannelVideoPlaybackRequest liveCreateChannelVideoPlaybackRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/playback/add";
        LiveCreateChannelVideoPlaybackResponse liveCreateChannelVideoPlaybackResponse = this.basePost(url, liveCreateChannelVideoPlaybackRequest, LiveCreateChannelVideoPlaybackResponse.class);
        return liveCreateChannelVideoPlaybackResponse;
    }

    @Override
    public String mergeChannelVideo(LiveMergeChannelVideoRequest liveMergeChannelVideoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/merge", liveMergeChannelVideoRequest.getChannelId());
        String liveMergeChannelVideoResponse = this.basePost(url, liveMergeChannelVideoRequest, String.class);
        return liveMergeChannelVideoResponse;
    }

    @Override
    public Boolean mergeChannelVideoAsync(LiveMergeChannelVideoAsyncRequest liveMergeChannelVideoAsyncRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/record/merge";
        String liveMergeChannelVideoAsyncResponse = this.basePost(url, liveMergeChannelVideoAsyncRequest, String.class);
        return "submit success".equals(liveMergeChannelVideoAsyncResponse);
    }

    @Override
    public Boolean convertChannelVideoListAsync(LiveConvertChannelVideoListAsyncRequest liveConvertChannelVideoListAsyncRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/record/convert";
        String liveConvertChannelVideoResponse = this.basePost(url, liveConvertChannelVideoListAsyncRequest, String.class);
        return "submit success".equals(liveConvertChannelVideoResponse);
    }

    @Override
    public LiveChannelVideoListResponse listChannelVideo(LiveChannelVideoListRequest liveChannelVideoListRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelVideoListRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/recordFiles", liveChannelVideoListRequest.getChannelId());
        LiveChannelVideoListResponse.ChannelVedioInfo[] channelVedioInfos = this.baseGet(url, liveChannelVideoListRequest, LiveChannelVideoListResponse.ChannelVedioInfo[].class);
        channelVedioInfos = channelVedioInfos == null ? new LiveChannelVideoListResponse.ChannelVedioInfo[]{} : channelVedioInfos;
        LiveChannelVideoListResponse liveChannelVideoListResponse = new LiveChannelVideoListResponse();
        liveChannelVideoListResponse.setChannelVedioInfos(Arrays.asList(channelVedioInfos));
        return liveChannelVideoListResponse;
    }

    @Override
    public String convertChannelVideo(LiveConvertChannelVideoRequest liveConvertChannelVideoRequest) throws IOException, NoSuchAlgorithmException {
        liveConvertChannelVideoRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/convert", liveConvertChannelVideoRequest.getChannelId());
        String liveConvertChannelVideoResponse = this.basePost(url, liveConvertChannelVideoRequest, String.class);
        return liveConvertChannelVideoResponse;
    }

    @Override
    public Boolean updateChannelPlaybackSetting(LiveChannelPlaybackSettingRequest liveChannelPlaybackSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/playback/set-setting";
        String liveChannelPlaybackSettingResponse = this.basePost(url, liveChannelPlaybackSettingRequest, String.class);
        return "true".equals(liveChannelPlaybackSettingResponse);
    }

    @Override
    public String updateChannelPlayBackEnabledSetting(LiveChannelPlaybackEnabledRequest liveChannelPlaybackEnabledRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelPlaybackEnabledRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/setPlayBackEnabled", liveChannelPlaybackEnabledRequest.getUserId());
        Integer liveChannelPlaybackEnabledResponse = this.basePost(url, liveChannelPlaybackEnabledRequest, Integer.class);
        return String.valueOf(liveChannelPlaybackEnabledResponse);
    }

    @Override
    public LiveListChannelVideoLibraryResponse listChannelVideoLibrary(LiveListChannelVideoLibraryRequest liveListChannelVideoLibraryRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/playback/list", liveListChannelVideoLibraryRequest.getChannelId());
        LiveListChannelVideoLibraryResponse liveListChannelVideoLibraryResponse = this.baseGet(url, liveListChannelVideoLibraryRequest, LiveListChannelVideoLibraryResponse.class);
        return liveListChannelVideoLibraryResponse;
    }

    @Override
    public Boolean setChannelVideoSort(LiveChannelVideoSortRequest liveChannelVideoSortRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/playback/sort";
        Map<String, String> signMap = MapUtil.getSignMap(liveChannelVideoSortRequest);
        signMap.put("channelId", String.valueOf(liveChannelVideoSortRequest.getChannelId()));
        String liveChannelVideoSortResponse = this.basePostJson(url, signMap, liveChannelVideoSortRequest, String.class);
        return "".equals(liveChannelVideoSortResponse);
    }

    @Override
    public LiveListChannelSessionInfoResponse listChannelSessionInfo(LiveListChannelSessionInfoRequest liveListChannelSessionInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/session/list";
        LiveListChannelSessionInfoResponse liveListChannelSessionInfoResponse = this.baseGet(url, liveListChannelSessionInfoRequest, LiveListChannelSessionInfoResponse.class);
        return liveListChannelSessionInfoResponse;
    }

    @Override
    public LiveChannelVideoOnlyResponse getChannelVideoOnly(LiveChannelVideoOnlyRequest liveChannelVideoOnlyRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/record/get";
        LiveChannelVideoOnlyResponse liveChannelVideoOnlyResponse = this.baseGet(url, liveChannelVideoOnlyRequest, LiveChannelVideoOnlyResponse.class);
        return liveChannelVideoOnlyResponse;
    }

    @Override
    public String getChannelPlayBackEnabledInfo(LiveChannelPlaybackEnabledInfoRequest liveChannelPlaybackEnabledInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/playback/get-enabled";
        String liveChannelPlaybackEnabledInfoResponse = this.baseGet(url, liveChannelPlaybackEnabledInfoRequest, String.class);
        return liveChannelPlaybackEnabledInfoResponse;
    }

    @Override
    public Boolean deleteChannelVideo(LiveDeleteChannelVideoRequest liveDeleteChannelVideoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/delete-record", liveDeleteChannelVideoRequest.getChannelId());
        String liveDeleteChannelVideoResponse = this.basePost(url, liveDeleteChannelVideoRequest, String.class);
        return "".equals(liveDeleteChannelVideoResponse);
    }

    @Override
    public Boolean deleteChannelPlaybackVideo(LiveDeleteChannelPlaybackVideoRequest liveDeleteChannelPlaybackVideoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/playback/delete", liveDeleteChannelPlaybackVideoRequest.getChannelId());
        String liveDeleteChannelPlaybackVideoResponse = this.basePost(url, liveDeleteChannelPlaybackVideoRequest, String.class);
        return "success".equals(liveDeleteChannelPlaybackVideoResponse);
    }

    @Override
    public Boolean setChannelDefaultVideo(LiveChannelDefaultVideoRequest liveChannelDefaultVideoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/playback/set-Default", liveChannelDefaultVideoRequest.getChannelId());
        String liveChannelDefaultVideoResponse = this.basePost(url, liveChannelDefaultVideoRequest, String.class);
        return "success".equals(liveChannelDefaultVideoResponse);
    }

    @Override
    public Boolean updatePlaybackTitle(LiveUpdatePlaybackTitleRequest liveUpdatePlaybackTitleRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/playback/update-title";
        String liveUpdatePlaybackTitleResponse = this.basePost(url, liveUpdatePlaybackTitleRequest, String.class);
        return "".equals(liveUpdatePlaybackTitleResponse);
    }

    @Override
    public LiveMergeMp4RecordResponse mergeMp4Record(LiveMergeMp4RecordRequest liveMergeMp4RecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/record/merge-mp4";
        return this.basePost(url, liveMergeMp4RecordRequest, LiveMergeMp4RecordResponse.class);
    }
}

