/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.internal.AbstractGroupVisitor;
import org.jacoco.report.internal.xml.XMLCoverageWriter;
import org.jacoco.report.internal.xml.XMLDocument;
import org.jacoco.report.internal.xml.XMLElement;
import org.jacoco.report.internal.xml.XMLGroupVisitor;

public class XMLFormatter {
    private static final String PUBID = "-//JACOCO//DTD Report 1.0//EN";
    private static final String SYSTEM = "report.dtd";
    private String outputEncoding = "UTF-8";

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public IReportVisitor createVisitor(OutputStream output) throws IOException {
        final XMLDocument root = new XMLDocument("report", PUBID, SYSTEM, this.outputEncoding, true, output);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RootVisitor
        extends XMLGroupVisitor
        implements IReportVisitor {
            private List<SessionInfo> sessionInfos;

            RootVisitor(XMLElement element) throws IOException {
                super(element, null);
            }

            @Override
            public void visitInfo(List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
                this.sessionInfos = sessionInfos;
            }

            @Override
            protected void handleBundle(IBundleCoverage bundle2, ISourceFileLocator locator) throws IOException {
                this.writeHeader(bundle2.getName());
                XMLCoverageWriter.writeBundle(bundle2, this.element);
            }

            @Override
            protected AbstractGroupVisitor handleGroup(String name) throws IOException {
                this.writeHeader(name);
                return new XMLGroupVisitor(this.element, name);
            }

            private void writeHeader(String name) throws IOException {
                this.element.attr("name", name);
                for (SessionInfo i : this.sessionInfos) {
                    XMLElement sessioninfo = root.element("sessioninfo");
                    sessioninfo.attr("id", i.getId());
                    sessioninfo.attr("start", i.getStartTimeStamp());
                    sessioninfo.attr("dump", i.getDumpTimeStamp());
                }
            }

            @Override
            protected void handleEnd() throws IOException {
                this.element.close();
            }
        }
        return new RootVisitor(root);
    }
}

