/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jacoco.maven.AbstractJacocoMojo;
import org.jacoco.maven.FileFilter;

@Mojo(name="instrument", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class InstrumentMojo
extends AbstractJacocoMojo {
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        List<String> fileNames;
        File originalClassesDir = new File(this.getProject().getBuild().getDirectory(), "generated-classes/jacoco");
        originalClassesDir.mkdirs();
        File classesDir = new File(this.getProject().getBuild().getOutputDirectory());
        if (!classesDir.exists()) {
            this.getLog().info("Skipping JaCoCo execution due to missing classes directory:" + classesDir);
            return;
        }
        try {
            fileNames = new FileFilter(this.getIncludes(), this.getExcludes()).getFileNames(classesDir);
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Unable to get list of files to instrument.", e1);
        }
        Instrumenter instrumenter = new Instrumenter(new OfflineInstrumentationAccessGenerator());
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".class")) continue;
            File source = new File(classesDir, fileName);
            File backup = new File(originalClassesDir, fileName);
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                FileUtils.copyFile(source, backup);
                input = new FileInputStream(backup);
                output = new FileOutputStream(source);
                instrumenter.instrument(input, output, source.getPath());
            }
            catch (IOException e2) {
                try {
                    throw new MojoExecutionException("Unable to instrument file.", e2);
                }
                catch (Throwable throwable) {
                    IOUtil.close(input);
                    IOUtil.close(output);
                    throw throwable;
                }
            }
            IOUtil.close(input);
            IOUtil.close(output);
        }
    }
}

