/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.internal.ContentTypeDetector;
import org.jacoco.core.internal.InputStreams;
import org.jacoco.core.internal.Pack200Streams;
import org.jacoco.core.internal.analysis.ClassAnalyzer;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class Analyzer {
    private final ExecutionDataStore executionData;
    private final ICoverageVisitor coverageVisitor;
    private final StringPool stringPool;

    public Analyzer(ExecutionDataStore executionData, ICoverageVisitor coverageVisitor) {
        this.executionData = executionData;
        this.coverageVisitor = coverageVisitor;
        this.stringPool = new StringPool();
    }

    private ClassVisitor createAnalyzingVisitor(long classid, String className) {
        boolean noMatch;
        boolean[] probes;
        ExecutionData data = this.executionData.get(classid);
        if (data == null) {
            probes = null;
            noMatch = this.executionData.contains(className);
        } else {
            probes = data.getProbes();
            noMatch = false;
        }
        final ClassCoverageImpl coverage = new ClassCoverageImpl(className, classid, noMatch);
        ClassAnalyzer analyzer = new ClassAnalyzer(coverage, probes, this.stringPool){

            public void visitEnd() {
                super.visitEnd();
                Analyzer.this.coverageVisitor.visitCoverage(coverage);
            }
        };
        return new ClassProbesAdapter(analyzer, false);
    }

    public void analyzeClass(ClassReader reader) {
        ClassVisitor visitor = this.createAnalyzingVisitor(CRC64.classId(reader.b), reader.getClassName());
        reader.accept(visitor, 0);
    }

    public void analyzeClass(byte[] buffer, String location) throws IOException {
        try {
            this.analyzeClass(new ClassReader(buffer));
        }
        catch (RuntimeException cause) {
            throw this.analyzerError(location, cause);
        }
    }

    public void analyzeClass(InputStream input, String location) throws IOException {
        byte[] buffer;
        try {
            buffer = InputStreams.readFully(input);
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
        this.analyzeClass(buffer, location);
    }

    private IOException analyzerError(String location, Exception cause) {
        IOException ex = new IOException(String.format("Error while analyzing %s.", location));
        ex.initCause(cause);
        return ex;
    }

    public int analyzeAll(InputStream input, String location) throws IOException {
        ContentTypeDetector detector;
        try {
            detector = new ContentTypeDetector(input);
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
        switch (detector.getType()) {
            case -889275714: {
                this.analyzeClass(detector.getInputStream(), location);
                return 1;
            }
            case 1347093252: {
                return this.analyzeZip(detector.getInputStream(), location);
            }
            case 529203200: {
                return this.analyzeGzip(detector.getInputStream(), location);
            }
            case -889270259: {
                return this.analyzePack200(detector.getInputStream(), location);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int analyzeAll(File file) throws IOException {
        int count = 0;
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                count += this.analyzeAll(f);
            }
        } else {
            FileInputStream in = new FileInputStream(file);
            try {
                count += this.analyzeAll(in, file.getPath());
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return count;
    }

    public int analyzeAll(String path, File basedir) throws IOException {
        int count = 0;
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            count += this.analyzeAll(new File(basedir, st.nextToken()));
        }
        return count;
    }

    private int analyzeZip(InputStream input, String location) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(input);
        int count = 0;
        while ((entry = this.nextEntry(zip, location)) != null) {
            count += this.analyzeAll(zip, location + "@" + entry.getName());
        }
        return count;
    }

    private ZipEntry nextEntry(ZipInputStream input, String location) throws IOException {
        try {
            return input.getNextEntry();
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
    }

    private int analyzeGzip(InputStream input, String location) throws IOException {
        GZIPInputStream gzipInputStream;
        try {
            gzipInputStream = new GZIPInputStream(input);
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
        return this.analyzeAll(gzipInputStream, location);
    }

    private int analyzePack200(InputStream input, String location) throws IOException {
        InputStream unpackedInput;
        try {
            unpackedInput = Pack200Streams.unpack(input);
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
        return this.analyzeAll(unpackedInput, location);
    }
}

