/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer.sink;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.xhtml.XhtmlSink;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class SiteRendererSink
extends XhtmlSink
implements Sink,
org.codehaus.doxia.sink.Sink {
    private String date = "";
    private String title = "";
    private List authors = new ArrayList();
    private final StringWriter headWriter;
    private StringBuffer sectionTitleBuffer;
    private boolean sectionHasID;
    private final Writer writer;
    private RenderingContext renderingContext;

    public SiteRendererSink(RenderingContext renderingContext) {
        this(new StringWriter(), renderingContext);
    }

    private SiteRendererSink(StringWriter writer, RenderingContext renderingContext) {
        super(writer);
        this.writer = writer;
        this.headWriter = new StringWriter();
        this.renderingContext = renderingContext;
    }

    public void title_() {
        if (this.getTextBuffer().length() > 0) {
            this.title = this.getTextBuffer().toString();
        }
        this.resetTextBuffer();
    }

    public void title() {
    }

    public String getTitle() {
        return this.title;
    }

    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            String text = HtmlTools.escapeHTML(this.getTextBuffer().toString());
            text = StringUtils.replace(text, "&amp;#", "&#");
            this.authors.add(text.trim());
        }
        this.resetTextBuffer();
    }

    public List getAuthors() {
        return this.authors;
    }

    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.date = this.getTextBuffer().toString().trim();
        }
        this.resetTextBuffer();
    }

    public String getDate() {
        return this.date;
    }

    public void body_() {
    }

    public void body() {
    }

    public String getBody() {
        return this.writer.toString();
    }

    public String getHead() {
        return this.headWriter.toString();
    }

    public void head_() {
        this.setHeadFlag(false);
    }

    public void head() {
        this.setHeadFlag(true);
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        this.sectionTitleBuffer = new StringBuffer();
        this.sectionHasID = attributes != null && attributes.isDefined(HTML.Attribute.ID.toString());
        super.onSectionTitle(depth, attributes);
    }

    protected void onSectionTitle_(int depth) {
        String sectionTitle = this.sectionTitleBuffer.toString();
        this.sectionTitleBuffer = null;
        if (!this.sectionHasID && !StringUtils.isEmpty(sectionTitle)) {
            this.anchor(HtmlTools.encodeId(sectionTitle));
            this.anchor_();
        } else {
            this.sectionHasID = false;
        }
        super.onSectionTitle_(depth);
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    public void text(String text) {
        if (this.sectionTitleBuffer != null) {
            this.sectionTitleBuffer.append(text);
        }
        super.text(text);
    }

    protected void write(String text) {
        if (this.isHeadFlag()) {
            this.headWriter.write(SiteRendererSink.unifyEOLs(text));
            return;
        }
        if (this.renderingContext != null) {
            String relativePathToBasedir = this.renderingContext.getRelativePath();
            text = relativePathToBasedir == null ? StringUtils.replace(text, "$relativePath", ".") : StringUtils.replace(text, "$relativePath", relativePathToBasedir);
        }
        super.write(text);
    }
}

