/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.player.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import net.polyv.live.constant.LiveConstant;
import net.polyv.live.constant.LiveURL;
import net.polyv.live.entity.player.LiveSetPlayerHeaderAdvertRequest;
import net.polyv.live.entity.player.LiveSetPlayerImgRequest;
import net.polyv.live.entity.player.LiveSetPlayerLogoRequest;
import net.polyv.live.entity.player.LiveSetPlayerPauseAdvertRequest;
import net.polyv.live.entity.player.LiveSetWarmupEnableRequest;
import net.polyv.live.entity.player.LiveSetWarmupVedioRequest;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.player.ILivePlayerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivePlayerServiceImpl
extends LiveBaseService
implements ILivePlayerService {
    private static final Logger log = LoggerFactory.getLogger(LivePlayerServiceImpl.class);

    @Override
    public Boolean setPlayerImg(LiveSetPlayerImgRequest liveSetPlayerImgRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/update", liveSetPlayerImgRequest.getChannelId());
        return super.basePost(url, liveSetPlayerImgRequest, Boolean.class);
    }

    @Override
    public Boolean setPlayerWarmupEnable(LiveSetWarmupEnableRequest liveSetWarmupEnableRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/set-warmup-enabled";
        return "success".equalsIgnoreCase(super.basePost(url, liveSetWarmupEnableRequest, String.class));
    }

    @Override
    public Boolean setPlayerLogo(LiveSetPlayerLogoRequest liveSetWarmupEnableRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/update", liveSetWarmupEnableRequest.getChannelId());
        return super.basePost(url, liveSetWarmupEnableRequest, Boolean.class);
    }

    @Override
    public Boolean setPlayerPauseAdvert(LiveSetPlayerPauseAdvertRequest liveSetPlayerPauseAdvertRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAdvert/%s/updateStop", liveSetPlayerPauseAdvertRequest.getChannelId());
        Boolean result = super.basePost(url, liveSetPlayerPauseAdvertRequest, Boolean.class);
        if (result.booleanValue() && LiveConstant.Flag.YES.getFlag().equals(liveSetPlayerPauseAdvertRequest.getEnabled())) {
            liveSetPlayerPauseAdvertRequest.setEnabled(null).setTimestamp(null).setSign(null);
            Boolean paramResult = super.basePost(url, liveSetPlayerPauseAdvertRequest, Boolean.class);
            return paramResult;
        }
        return result;
    }

    @Override
    public Boolean setPlayerHeaderAdvert(LiveSetPlayerHeaderAdvertRequest liveSetPlayerHeaderAdvertRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAdvert/%s/updateHead", liveSetPlayerHeaderAdvertRequest.getChannelId());
        Boolean result = super.basePost(url, liveSetPlayerHeaderAdvertRequest, Boolean.class);
        Boolean paramResult = Boolean.FALSE;
        if (result.booleanValue() && LiveConstant.Flag.YES.getFlag().equals(liveSetPlayerHeaderAdvertRequest.getEnabled())) {
            liveSetPlayerHeaderAdvertRequest.setEnabled(null).setTimestamp(null).setSign(null);
            paramResult = super.basePost(url, liveSetPlayerHeaderAdvertRequest, Boolean.class);
            return paramResult;
        }
        return result;
    }

    @Override
    public Boolean setPlayerWarmUpVedio(LiveSetWarmupVedioRequest liveSetWarmupVedioRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/update", liveSetWarmupVedioRequest.getChannelId());
        return super.basePost(url, liveSetWarmupVedioRequest, Boolean.class);
    }
}

