/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.Description;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.SeverityLevel;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.PropertiesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResultsUtils {
    public static final String ALLURE_HOST_NAME_SYSPROP = "allure.hostName";
    public static final String ALLURE_HOST_NAME_ENV = "ALLURE_HOST_NAME";
    public static final String ALLURE_THREAD_NAME_SYSPROP = "allure.threadName";
    public static final String ALLURE_THREAD_NAME_ENV = "ALLURE_THREAD_NAME";
    public static final String ALLURE_SEPARATE_LINES_SYSPROP = "allure.description.javadoc.separateLines";
    public static final String ISSUE_LINK_TYPE = "issue";
    public static final String TMS_LINK_TYPE = "tms";
    public static final String CUSTOM_LINK_TYPE = "custom";
    public static final String ALLURE_ID_LABEL_NAME = "AS_ID";
    public static final String SUITE_LABEL_NAME = "suite";
    public static final String PARENT_SUITE_LABEL_NAME = "parentSuite";
    public static final String SUB_SUITE_LABEL_NAME = "subSuite";
    public static final String EPIC_LABEL_NAME = "epic";
    public static final String FEATURE_LABEL_NAME = "feature";
    public static final String STORY_LABEL_NAME = "story";
    public static final String SEVERITY_LABEL_NAME = "severity";
    public static final String TAG_LABEL_NAME = "tag";
    public static final String OWNER_LABEL_NAME = "owner";
    public static final String LEAD_LABEL_NAME = "lead";
    public static final String HOST_LABEL_NAME = "host";
    public static final String THREAD_LABEL_NAME = "thread";
    public static final String TEST_METHOD_LABEL_NAME = "testMethod";
    public static final String TEST_CLASS_LABEL_NAME = "testClass";
    public static final String PACKAGE_LABEL_NAME = "package";
    public static final String FRAMEWORK_LABEL_NAME = "framework";
    public static final String LANGUAGE_LABEL_NAME = "language";
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultsUtils.class);
    private static final String ALLURE_DESCRIPTIONS_PACKAGE = "allureDescriptions/";
    private static final String MD_5 = "MD5";
    private static String cachedHost;

    private ResultsUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static Parameter createParameter(String name, Object value) {
        return new Parameter().setName(name).setValue(ObjectUtils.toString(value));
    }

    public static Label createSuiteLabel(String suite) {
        return ResultsUtils.createLabel(SUITE_LABEL_NAME, suite);
    }

    public static Label createParentSuiteLabel(String suite) {
        return ResultsUtils.createLabel(PARENT_SUITE_LABEL_NAME, suite);
    }

    public static Label createSubSuiteLabel(String suite) {
        return ResultsUtils.createLabel(SUB_SUITE_LABEL_NAME, suite);
    }

    public static Label createTestMethodLabel(String testMethod) {
        return ResultsUtils.createLabel(TEST_METHOD_LABEL_NAME, testMethod);
    }

    public static Label createTestClassLabel(String testClass) {
        return ResultsUtils.createLabel(TEST_CLASS_LABEL_NAME, testClass);
    }

    public static Label createPackageLabel(String packageName) {
        return ResultsUtils.createLabel(PACKAGE_LABEL_NAME, packageName);
    }

    public static Label createEpicLabel(String epic) {
        return ResultsUtils.createLabel(EPIC_LABEL_NAME, epic);
    }

    public static Label createFeatureLabel(String feature) {
        return ResultsUtils.createLabel(FEATURE_LABEL_NAME, feature);
    }

    public static Label createStoryLabel(String story) {
        return ResultsUtils.createLabel(STORY_LABEL_NAME, story);
    }

    public static Label createTagLabel(String tag) {
        return ResultsUtils.createLabel(TAG_LABEL_NAME, tag);
    }

    public static Label createOwnerLabel(String owner) {
        return ResultsUtils.createLabel(OWNER_LABEL_NAME, owner);
    }

    public static Label createSeverityLabel(SeverityLevel severity) {
        return ResultsUtils.createSeverityLabel(severity.value());
    }

    public static Label createSeverityLabel(String severity) {
        return ResultsUtils.createLabel(SEVERITY_LABEL_NAME, severity);
    }

    public static Label createHostLabel() {
        return ResultsUtils.createLabel(HOST_LABEL_NAME, ResultsUtils.getHostName());
    }

    public static Label createThreadLabel() {
        return ResultsUtils.createLabel(THREAD_LABEL_NAME, ResultsUtils.getThreadName());
    }

    public static Label createFrameworkLabel(String framework) {
        return ResultsUtils.createLabel(FRAMEWORK_LABEL_NAME, framework);
    }

    public static Label createLanguageLabel(String language) {
        return ResultsUtils.createLabel(LANGUAGE_LABEL_NAME, language);
    }

    public static Label createLabel(String name, String value) {
        return new Label().setName(name).setValue(value);
    }

    public static Label createLabel(Owner owner) {
        return ResultsUtils.createOwnerLabel(owner.value());
    }

    public static Label createLabel(Severity severity) {
        return ResultsUtils.createSeverityLabel(severity.value());
    }

    public static Label createLabel(Story story) {
        return ResultsUtils.createStoryLabel(story.value());
    }

    public static Label createLabel(Feature feature) {
        return ResultsUtils.createFeatureLabel(feature.value());
    }

    public static Label createLabel(Epic epic) {
        return ResultsUtils.createEpicLabel(epic.value());
    }

    public static io.qameta.allure.model.Link createIssueLink(String value) {
        return ResultsUtils.createLink(value, null, null, ISSUE_LINK_TYPE);
    }

    public static io.qameta.allure.model.Link createTmsLink(String value) {
        return ResultsUtils.createLink(value, null, null, TMS_LINK_TYPE);
    }

    public static io.qameta.allure.model.Link createLink(Link link) {
        return ResultsUtils.createLink(link.value(), link.name(), link.url(), link.type());
    }

    public static io.qameta.allure.model.Link createLink(Issue link) {
        return ResultsUtils.createIssueLink(link.value());
    }

    public static io.qameta.allure.model.Link createLink(TmsLink link) {
        return ResultsUtils.createTmsLink(link.value());
    }

    public static io.qameta.allure.model.Link createLink(String value, String name, String url, String type) {
        String resolvedName = ResultsUtils.firstNonEmpty(value).orElse(name);
        String resolvedUrl = ResultsUtils.firstNonEmpty(url).orElseGet(() -> ResultsUtils.getLinkUrl(resolvedName, type));
        return new io.qameta.allure.model.Link().setName(resolvedName).setUrl(resolvedUrl).setType(type);
    }

    public static Set<Label> getProvidedLabels() {
        Properties properties = PropertiesUtils.loadAllureProperties();
        Set<String> propertyNames = properties.stringPropertyNames();
        return propertyNames.stream().filter(name -> name.startsWith("allure.label.")).map(name -> {
            String labelName = name.substring(13);
            String labelValue = properties.getProperty((String)name);
            return new Label().setName(labelName).setValue(labelValue);
        }).filter(label -> Objects.nonNull(label.getValue())).collect(Collectors.toSet());
    }

    public static String getHostName() {
        String fromProperty = System.getProperty(ALLURE_HOST_NAME_SYSPROP);
        String fromEnv = System.getenv(ALLURE_HOST_NAME_ENV);
        return Stream.of(fromProperty, fromEnv).filter(Objects::nonNull).findFirst().orElseGet(ResultsUtils::getRealHostName);
    }

    public static String getThreadName() {
        String fromProperty = System.getProperty(ALLURE_THREAD_NAME_SYSPROP);
        String fromEnv = System.getenv(ALLURE_THREAD_NAME_ENV);
        return Stream.of(fromProperty, fromEnv).filter(Objects::nonNull).findFirst().orElseGet(ResultsUtils::getRealThreadName);
    }

    public static Optional<Status> getStatus(Throwable throwable) {
        return Optional.ofNullable(throwable).map(t -> t instanceof AssertionError ? Status.FAILED : Status.BROKEN);
    }

    public static Optional<StatusDetails> getStatusDetails(Throwable e) {
        return Optional.ofNullable(e).map(throwable -> new StatusDetails().setMessage(Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getName())).setTrace(ResultsUtils.getStackTraceAsString(throwable)));
    }

    public static Optional<String> getJavadocDescription(ClassLoader classLoader, Method method) {
        String name = method.getName();
        List<String> parameterTypes = Stream.of(method.getParameterTypes()).map(Class::getTypeName).collect(Collectors.toList());
        String signatureHash = ResultsUtils.generateMethodSignatureHash(method.getDeclaringClass().getName(), name, parameterTypes);
        return ResultsUtils.readResource(classLoader, ALLURE_DESCRIPTIONS_PACKAGE + signatureHash).map(desc -> ResultsUtils.separateLines() ? desc.replace("\n", "<br />") : desc);
    }

    public static Optional<String> firstNonEmpty(String ... items) {
        return Stream.of(items).filter(Objects::nonNull).filter(item -> !item.isEmpty()).findFirst();
    }

    public static String getLinkTypePatternPropertyName(String type) {
        return String.format("allure.link.%s.pattern", type);
    }

    public static String generateMethodSignatureHash(String className, String methodName, List<String> parameterTypes) {
        MessageDigest md = ResultsUtils.getMd5Digest();
        md.update(className.getBytes(StandardCharsets.UTF_8));
        md.update(methodName.getBytes(StandardCharsets.UTF_8));
        parameterTypes.stream().map(string -> string.getBytes(StandardCharsets.UTF_8)).forEach(md::update);
        byte[] bytes = md.digest();
        return ResultsUtils.bytesToHex(bytes);
    }

    public static String md5(String source) {
        Objects.requireNonNull(source, "null source");
        return ResultsUtils.bytesToHex(ResultsUtils.getMd5Digest().digest(source.getBytes(StandardCharsets.UTF_8)));
    }

    public static String bytesToHex(byte[] bytes) {
        return new BigInteger(1, bytes).toString(16);
    }

    public static MessageDigest getMd5Digest() {
        try {
            return MessageDigest.getInstance(MD_5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Can not find hashing algorithm", e);
        }
    }

    private static String getLinkUrl(String name, String type) {
        Properties properties = PropertiesUtils.loadAllureProperties();
        String pattern = properties.getProperty(ResultsUtils.getLinkTypePatternPropertyName(type));
        if (Objects.isNull(pattern)) {
            return null;
        }
        return pattern.replaceAll("\\{}", Objects.isNull(name) ? "" : name);
    }

    private static String getRealHostName() {
        if (Objects.isNull(cachedHost)) {
            try {
                cachedHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.debug("Could not get host name {}", e);
                cachedHost = "default";
            }
        }
        return cachedHost;
    }

    private static String getRealThreadName() {
        return String.format("%s.%s(%s)", ManagementFactory.getRuntimeMXBean().getName(), Thread.currentThread().getName(), Thread.currentThread().getId());
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Deprecated
    public static void processDescription(ClassLoader classLoader, Method method, ExecutableItem item) {
        if (method.isAnnotationPresent(Description.class)) {
            if (method.getAnnotation(Description.class).useJavaDoc()) {
                ResultsUtils.getJavadocDescription(classLoader, method).ifPresent(item::setDescriptionHtml);
            } else {
                String description = method.getAnnotation(Description.class).value();
                item.setDescription(description);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readResource(ClassLoader classLoader, String resourceName) {
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            if (Objects.isNull(is)) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            byte[] bytes = IOUtils.toByteArray(is);
            Optional<String> optional = Optional.of(new String(bytes, StandardCharsets.UTF_8));
            return optional;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to process description resource file", e);
            return Optional.empty();
        }
    }

    private static boolean separateLines() {
        return Boolean.parseBoolean(PropertiesUtils.loadAllureProperties().getProperty(ALLURE_SEPARATE_LINES_SYSPROP));
    }
}

