/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.polyv.common.base.HttpUtil;
import net.polyv.common.exception.PloyvSdkException;
import net.polyv.common.util.ValidationUtil;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.constant.LiveConstant;
import net.polyv.live.entity.LiveCommonRequest;
import net.polyv.live.entity.LiveCommonResponse;
import net.polyv.live.util.LiveSignUtil;
import net.polyv.live.util.MapUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveBaseService {
    private static final Logger log = LoggerFactory.getLogger(LiveBaseService.class);
    public static final String ERROR_PREFIX = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";
    public static final String ERROR_INFO = " ,\u9519\u8bef\u539f\u56e0\uff1a ";
    public static final String ERROR_SUFFIX = " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
    public static final String ERROR_PREFIX1 = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";

    protected <T, E extends LiveCommonRequest> T baseGet(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> baseGetReturnArray(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse baseGet(String url, E e) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank((CharSequence)e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        Map<String, String> paramMap = MapUtil.objectToMap(e);
        paramMap = MapUtil.filterNullValue(paramMap);
        String sign = LiveSignUtil.setLiveSign(paramMap, LiveGlobalConfig.getAppId(), LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        String queryStr = MapUtil.mapJoinNotEncode(paramMap);
        url = url + "?" + queryStr;
        String response = HttpUtil.sendGetData((String)url, (String)Consts.UTF_8.toString());
        if (StringUtils.isNotBlank((CharSequence)response)) {
            liveCommonResponse = (LiveCommonResponse)JSON.parseObject((String)response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(liveCommonResponse.getCode()), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    private <E extends LiveCommonRequest> void validateBean(E e) {
        ValidationUtil.ValidResult validResult = ValidationUtil.validateBean(e, (Class[])new Class[0]);
        if (validResult.hasErrors()) {
            String errors = validResult.getErrors();
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + ((Object)e).getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            log.error(errors);
            throw new PloyvSdkException(LiveConstant.ERROR_CODE, errors);
        }
    }

    protected <T, E extends LiveCommonRequest> List<T> basePostReturnArray(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePost(url, e).parseArray(tClass);
    }

    protected <T, E extends LiveCommonRequest> T basePost(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePost(url, e).parseData(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse basePost(String url, E e) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank((CharSequence)e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        Map<String, String> paramMap = MapUtil.objectToMap(e);
        paramMap = MapUtil.filterNullValue(paramMap);
        String sign = LiveSignUtil.setLiveSign(paramMap, LiveGlobalConfig.getAppId(), LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        String response = HttpUtil.sendPostDataByMap((String)url, paramMap, (String)Consts.UTF_8.toString());
        if (StringUtils.isNotBlank((CharSequence)response)) {
            liveCommonResponse = (LiveCommonResponse)JSON.parseObject((String)response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(liveCommonResponse.getCode()), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    protected <T, E extends LiveCommonRequest> T basePostJson(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        Map<String, String> signMap = MapUtil.getSignMap(e);
        return this.basePostJson(url, signMap, e, tClass);
    }

    protected <T, E extends LiveCommonRequest> T basePostJson(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, signMap, e).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> basePostJsonReturnArray(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, signMap, e).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse basePostJson(String url, Map<String, String> signMap, E e) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank((CharSequence)e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        String sign = LiveSignUtil.setLiveSign(signMap, LiveGlobalConfig.getAppId(), LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        url = url + "?" + MapUtil.mapJoinNotEncode(signMap);
        String response = HttpUtil.sendPostDataByJson((String)url, (String)JSON.toJSONString(e), (String)Consts.UTF_8.toString());
        if (StringUtils.isNotBlank((CharSequence)response)) {
            liveCommonResponse = (LiveCommonResponse)JSON.parseObject((String)response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(liveCommonResponse.getCode()), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    protected <T, E extends LiveCommonRequest> T baseUploadFile(String url, E e, Map<String, File> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseUploadFile(url, e, fileMap).parseData(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse baseUploadFile(String url, E e, Map<String, File> fileMap) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank((CharSequence)e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        Map<String, String> paramMap = MapUtil.objectToMap(e);
        paramMap = MapUtil.filterNullValue(paramMap);
        String sign = LiveSignUtil.setLiveSign(paramMap, LiveGlobalConfig.getAppId(), LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        String response = HttpUtil.sendUploadFile((String)url, paramMap, fileMap, (String)Consts.UTF_8.toString());
        if (StringUtils.isNotBlank((CharSequence)response)) {
            liveCommonResponse = (LiveCommonResponse)JSON.parseObject((String)response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(liveCommonResponse.getCode()), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return liveCommonResponse;
    }
}

