/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.web.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.constant.LiveURL;
import net.polyv.live.entity.web.info.LiveChannelCountDownRequest;
import net.polyv.live.entity.web.info.LiveChannelCountDownResponse;
import net.polyv.live.entity.web.info.LiveChannelLikesRequest;
import net.polyv.live.entity.web.info.LiveChannelLikesResponse;
import net.polyv.live.entity.web.info.LiveChannelSplashRequest;
import net.polyv.live.entity.web.info.LiveChannelSplashResponse;
import net.polyv.live.entity.web.info.LiveUpdateChannelCountDownRequest;
import net.polyv.live.entity.web.info.LiveUpdateChannelLikesRequest;
import net.polyv.live.entity.web.info.LiveUpdateChannelLogoRequest;
import net.polyv.live.entity.web.info.LiveUpdateChannelNameRequest;
import net.polyv.live.entity.web.info.LiveUpdateChannelPublisherRequest;
import net.polyv.live.entity.web.info.LiveUpdateChannelSplashRequest;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.web.ILiveWebInfoService;

public class LiveWebInfoServiceImpl
extends LiveBaseService
implements ILiveWebInfoService {
    @Override
    public Boolean updateChannelName(LiveUpdateChannelNameRequest liveUpdateChannelNameRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/update", liveUpdateChannelNameRequest.getChannelId());
        String liveUpdateChannelNameResponse = this.basePost(url, liveUpdateChannelNameRequest, String.class);
        return "true".equals(liveUpdateChannelNameResponse);
    }

    @Override
    public Boolean updateChannelPublisher(LiveUpdateChannelPublisherRequest liveUpdateChannelPublisherRequest) throws IOException, NoSuchAlgorithmException {
        liveUpdateChannelPublisherRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/setPublisher", liveUpdateChannelPublisherRequest.getUserId());
        String liveUpdateChannelPublisherResponse = this.basePost(url, liveUpdateChannelPublisherRequest, String.class);
        return "true".equals(liveUpdateChannelPublisherResponse);
    }

    @Override
    public LiveChannelSplashResponse channelSplash(LiveChannelSplashRequest liveChannelSplashRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/getSplash", liveChannelSplashRequest.getChannelId());
        return this.basePost(url, liveChannelSplashRequest, LiveChannelSplashResponse.class);
    }

    @Override
    public Boolean updateChannelLikes(LiveUpdateChannelLikesRequest liveUpdateChannelLikesRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/update-likes", liveUpdateChannelLikesRequest.getChannelId());
        String liveUpdateChannelLikesResponse = this.basePost(url, liveUpdateChannelLikesRequest, String.class);
        return "success".equals(liveUpdateChannelLikesResponse);
    }

    @Override
    public LiveChannelLikesResponse channelLikes(LiveChannelLikesRequest liveChannelLikesRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v2/channels/live-likes";
        List<LiveChannelLikesResponse.ChannelLikes> channelLikes = this.basePostReturnArray(url, liveChannelLikesRequest, LiveChannelLikesResponse.ChannelLikes.class);
        LiveChannelLikesResponse liveChannelLikesResponse = new LiveChannelLikesResponse();
        liveChannelLikesResponse.setChannelLikes(channelLikes);
        return liveChannelLikesResponse;
    }

    @Override
    public Boolean updateChannelCountDown(LiveUpdateChannelCountDownRequest liveUpdateChannelCountDownRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/set-countdown", liveUpdateChannelCountDownRequest.getChannelId());
        String liveUpdateChannelCountDownResponse = this.basePost(url, liveUpdateChannelCountDownRequest, String.class);
        return "".equals(liveUpdateChannelCountDownResponse);
    }

    @Override
    public LiveChannelCountDownResponse channelCountDown(LiveChannelCountDownRequest liveChannelCountDownRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/get-countdown", liveChannelCountDownRequest.getChannelId());
        LiveChannelCountDownResponse liveChannelCountDownResponse = this.basePost(url, liveChannelCountDownRequest, LiveChannelCountDownResponse.class);
        return liveChannelCountDownResponse;
    }

    @Override
    public String updateChannelLogo(LiveUpdateChannelLogoRequest liveUpdateChannelLogoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/setCoverImg", liveUpdateChannelLogoRequest.getChannelId());
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("imgfile", liveUpdateChannelLogoRequest.getImgfile());
        String liveUpdateChannelLogoResponse = this.baseUploadFile(url, liveUpdateChannelLogoRequest, fileMap, String.class);
        return liveUpdateChannelLogoResponse;
    }

    @Override
    public String updateChannelSplash(LiveUpdateChannelSplashRequest liveUpdateChannelSplashRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelSetting/%s/setSplash", liveUpdateChannelSplashRequest.getChannelId());
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("imgfile", liveUpdateChannelSplashRequest.getImgfile());
        String liveUpdateChannelSplashResponse = this.baseUploadFile(url, liveUpdateChannelSplashRequest, fileMap, String.class);
        return liveUpdateChannelSplashResponse;
    }
}

