/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.interact.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.entity.interact.LiveQuestionnaireDetailRequest;
import net.polyv.live.entity.interact.LiveQuestionnaireDetailResponse;
import net.polyv.live.entity.interact.LiveQuestionnaireDetailSetRequest;
import net.polyv.live.entity.interact.LiveQuestionnaireDetailSetResponse;
import net.polyv.live.entity.interact.LiveQuestionnaireListRequest;
import net.polyv.live.entity.interact.LiveQuestionnaireListResponse;
import net.polyv.live.entity.interact.LiveQuestionnaireResultPageRequest;
import net.polyv.live.entity.interact.LiveQuestionnaireResultPageResponse;
import net.polyv.live.entity.interact.LiveQuestionnaireResultRequest;
import net.polyv.live.entity.interact.LiveQuestionnaireResultResponse;
import net.polyv.live.service.LiveBaseService;
import net.polyv.live.service.interact.ILiveQuestionnaireService;
import net.polyv.live.util.LiveSignUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveQuestionnaireServiceImpl
extends LiveBaseService
implements ILiveQuestionnaireService {
    private static final Logger log = LoggerFactory.getLogger(LiveQuestionnaireServiceImpl.class);

    @Override
    public LiveQuestionnaireDetailResponse getQuestionnaireDetailInfo(LiveQuestionnaireDetailRequest liveQuestionnaireDetailRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/detail";
        LiveQuestionnaireDetailResponse LiveQuestionnaireDetailResponse2 = this.basePost(url, liveQuestionnaireDetailRequest, LiveQuestionnaireDetailResponse.class);
        return LiveQuestionnaireDetailResponse2;
    }

    @Override
    public LiveQuestionnaireListResponse getQuestionnaireListInfo(LiveQuestionnaireListRequest liveQuestionnaireListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/list";
        return this.basePost(url, liveQuestionnaireListRequest, LiveQuestionnaireListResponse.class);
    }

    private Map<String, String> getSignMap(LiveQuestionnaireDetailSetRequest liveQuestionnaireDetailSetRequest) {
        if (StringUtils.isBlank(liveQuestionnaireDetailSetRequest.getRequestId())) {
            liveQuestionnaireDetailSetRequest.setRequestId(LiveSignUtil.generateUUID());
        }
        liveQuestionnaireDetailSetRequest.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank(liveQuestionnaireDetailSetRequest.getTimestamp())) {
            liveQuestionnaireDetailSetRequest.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("appId", liveQuestionnaireDetailSetRequest.getAppId());
        tempMap.put("timestamp", liveQuestionnaireDetailSetRequest.getTimestamp());
        tempMap.put("requestId", liveQuestionnaireDetailSetRequest.getRequestId());
        tempMap.put("channelId", liveQuestionnaireDetailSetRequest.getChannelId());
        return tempMap;
    }

    @Override
    public LiveQuestionnaireDetailSetResponse setQuestionnaireDetailInfo(LiveQuestionnaireDetailSetRequest liveQuestionnaireDetailSetRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/add-edit-questionnaire";
        Map<String, String> signMap = this.getSignMap(liveQuestionnaireDetailSetRequest);
        return this.basePostJson(url, signMap, liveQuestionnaireDetailSetRequest, LiveQuestionnaireDetailSetResponse.class);
    }

    @Override
    public List<LiveQuestionnaireResultResponse> getQuestionnaireResultInfo(LiveQuestionnaireResultRequest liveQuestionnaireResultRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/answer-records";
        return this.baseGetReturnArray(url, liveQuestionnaireResultRequest, LiveQuestionnaireResultResponse.class);
    }

    @Override
    public LiveQuestionnaireResultPageResponse getQuestionnaireResultPageInfo(LiveQuestionnaireResultPageRequest liveQuestionnaireResultPageRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/list-answer-records";
        return this.baseGet(url, liveQuestionnaireResultPageRequest, LiveQuestionnaireResultPageResponse.class);
    }
}

