/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.polyv.live.config.LiveGlobalConfig;
import net.polyv.live.entity.LiveCommonRequest;
import net.polyv.live.util.LiveSignUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MapUtil.class);

    private MapUtil() {
    }

    public static Map<String, String> order(Map<String, String> map) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : infoIds) {
            tempMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return tempMap;
    }

    public static Map<String, String> objectToMap(Object obj) {
        HashMap<String, String> reMap = new HashMap<String, String>();
        if (null == obj) {
            return null;
        }
        try {
            for (Class<?> objClass = obj.getClass(); null != objClass; objClass = objClass.getSuperclass()) {
                Field[] fields = objClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field f = objClass.getDeclaredField(fields[i].getName());
                    f.setAccessible(true);
                    Object o = f.get(obj);
                    if (o instanceof File) continue;
                    JSONField jsonField = f.getAnnotation(JSONField.class);
                    String key = jsonField != null ? jsonField.name() : fields[i].getName();
                    String value = null;
                    if (o != null) {
                        value = o instanceof List ? JSON.toJSONString((Object)o) : o.toString();
                    }
                    reMap.put(key, null == o ? null : value);
                }
            }
        }
        catch (NoSuchFieldException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return reMap;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        if (!clazz.equals(Object.class)) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        List<Field> fields2 = MapUtil.getAllFields(clazz.getSuperclass());
        if (null != fields2) {
            fields.addAll(fields2);
        }
        return fields;
    }

    public static String mapJoin(Map<String, String> map, boolean keyLower, boolean valueUrlEncode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            try {
                String temp = key.endsWith("_") && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
                stringBuilder.append(keyLower ? temp.toLowerCase() : temp).append("=").append(valueUrlEncode ? URLEncoder.encode(value, "UTF-8").replace("+", "%20") : value).append("&");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String mapJoinNotEncode(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (0 != i) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(map.get(key));
            ++i;
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getSignMap(Map<String, String> map) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        String appId = "appId";
        tempMap.put(appId, map.get(appId));
        String timestamp = "timestamp";
        tempMap.put(timestamp, map.get(timestamp));
        String sign = "sign";
        tempMap.put(sign, map.get(sign));
        String requestId = "requestId";
        tempMap.put(requestId, map.get(requestId));
        return tempMap;
    }

    public static <T extends LiveCommonRequest> Map<String, String> getSignMap(T t) {
        if (StringUtils.isBlank((CharSequence)t.getRequestId())) {
            t.setRequestId(LiveSignUtil.generateUUID());
        }
        t.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank((CharSequence)t.getTimestamp())) {
            t.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("appId", t.getAppId());
        tempMap.put("timestamp", t.getTimestamp());
        tempMap.put("requestId", t.getRequestId());
        return tempMap;
    }

    public static Map<String, String> filterNullValue(Map<String, String> sourceMap) {
        HashMap<String, String> destMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            destMap.put(key, value);
        }
        return destMap;
    }
}

