/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.HttpUtil;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.MapUtil;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveConstant;
import net.polyv.live.v1.entity.LiveCommonRequest;
import net.polyv.live.v1.entity.LiveCommonResponse;
import net.polyv.live.v1.util.LiveSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveBaseService {
    private static final Logger log = LoggerFactory.getLogger(LiveBaseService.class);
    public static final String ERROR_PREFIX = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";
    public static final String ERROR_INFO = " ,\u9519\u8bef\u539f\u56e0\uff1a ";
    public static final String ERROR_SUFFIX = " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
    public static final String ERROR_PREFIX1 = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";

    protected <T, E extends LiveCommonRequest> T getReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> getReturnList(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse baseGet(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        String response = HttpUtil.get((String)url, paramMap);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <E extends LiveCommonRequest> byte[] getReturnBinary(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        byte[] response = HttpUtil.getBinary((String)url, paramMap, null);
        if (response == null) {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return response;
    }

    protected <T, E extends LiveCommonRequest> T postFormBodyReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostFormBody(url, e).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> postFormBodyReturnList(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostFormBody(url, e).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse basePostFormBody(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        String response = HttpUtil.postFormBody((String)url, paramMap);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends LiveCommonRequest> List<T> postJsonBodyReturnList(String url, Map<String, String> signMap, E e, String json, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJsonBody(url, signMap, e, json).parseArray(tClass);
    }

    protected <T, E extends LiveCommonRequest> T postJsonBodyReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        Map<String, String> signMap = LiveSignUtil.getSignMap(e);
        return this.basePostJsonBody(url, signMap, e, "").parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> T postJsonBodyReturnOne(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJsonBody(url, signMap, e, "").parseData(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse basePostJsonBody(String url, Map<String, String> signMap, E e, String json) throws IOException, NoSuchAlgorithmException {
        signMap = this.commonRequestLogic(signMap, e);
        this.validateBean(e);
        url = MapUtil.appendUrl((String)url, signMap);
        if (StringUtils.isBlank((String)json)) {
            json = JSON.toJSONString(e);
        }
        String response = HttpUtil.postJsonBody((String)url, (String)json, null);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends LiveCommonRequest> T uploadOneFile(String url, E e, Map<String, File> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.uploadOneFile(url, e, fileMap).parseData(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse uploadOneFile(String url, E e, Map<String, File> fileMap) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        String response = HttpUtil.postFile((String)url, paramMap, fileMap, null);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends LiveCommonRequest> List<T> uploadMultipartFile(String url, E e, Map<String, List<File>> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.uploadMultipartFile(url, e, fileMap).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse uploadMultipartFile(String url, E e, Map<String, List<File>> fileMap) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        String response = HttpUtil.postMultipleFile((String)url, paramMap, fileMap, null);
        return this.responseConversion(response, e.getRequestId());
    }

    private <E extends LiveCommonRequest> Map<String, String> commonRequestLogic(Map<String, String> signMap, E e) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank((String)e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        if (signMap == null) {
            signMap = MapUtil.objectToMap(e);
        }
        signMap = MapUtil.filterNullValue(signMap);
        String sign = LiveSignUtil.setLiveSign(signMap, LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        return signMap;
    }

    private <E extends LiveCommonRequest> void validateBean(E e) {
        List violationMsgList = SDKValidateUtil.validateBean(e, (Class[])new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr((List)violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + ((Object)e).getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            log.error(errors);
            throw new PloyvSdkException(LiveConstant.ERROR_CODE, errors);
        }
    }

    private LiveCommonResponse responseConversion(String response, String requestId) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse;
        if (StringUtils.isNotBlank((String)response)) {
            liveCommonResponse = (LiveCommonResponse)JSON.parseObject((String)response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + requestId + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(liveCommonResponse.getCode()), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + requestId + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return liveCommonResponse;
    }
}

