/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.interact.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireDetailRequest;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireDetailResponse;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireDetailSetRequest;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireDetailSetResponse;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireListRequest;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireListResponse;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireResultPageRequest;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireResultPageResponse;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireResultRequest;
import net.polyv.live.v1.entity.interact.LiveQuestionnaireResultResponse;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.interact.ILiveQuestionnaireService;
import net.polyv.live.v1.util.LiveSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveQuestionnaireServiceImpl
extends LiveBaseService
implements ILiveQuestionnaireService {
    private static final Logger log = LoggerFactory.getLogger(LiveQuestionnaireServiceImpl.class);

    @Override
    public LiveQuestionnaireDetailResponse getQuestionnaireDetailInfo(LiveQuestionnaireDetailRequest liveQuestionnaireDetailRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/detail";
        LiveQuestionnaireDetailResponse LiveQuestionnaireDetailResponse2 = this.postFormBodyReturnOne(url, liveQuestionnaireDetailRequest, LiveQuestionnaireDetailResponse.class);
        return LiveQuestionnaireDetailResponse2;
    }

    @Override
    public LiveQuestionnaireListResponse getQuestionnaireListInfo(LiveQuestionnaireListRequest liveQuestionnaireListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/list";
        return this.postFormBodyReturnOne(url, liveQuestionnaireListRequest, LiveQuestionnaireListResponse.class);
    }

    private Map<String, String> getSignMap(LiveQuestionnaireDetailSetRequest liveQuestionnaireDetailSetRequest) {
        if (StringUtils.isBlank(liveQuestionnaireDetailSetRequest.getRequestId())) {
            liveQuestionnaireDetailSetRequest.setRequestId(LiveSignUtil.generateUUID());
        }
        liveQuestionnaireDetailSetRequest.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank(liveQuestionnaireDetailSetRequest.getTimestamp())) {
            liveQuestionnaireDetailSetRequest.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("appId", liveQuestionnaireDetailSetRequest.getAppId());
        tempMap.put("timestamp", liveQuestionnaireDetailSetRequest.getTimestamp());
        tempMap.put("requestId", liveQuestionnaireDetailSetRequest.getRequestId());
        tempMap.put("channelId", liveQuestionnaireDetailSetRequest.getChannelId());
        return tempMap;
    }

    @Override
    public LiveQuestionnaireDetailSetResponse setQuestionnaireDetailInfo(LiveQuestionnaireDetailSetRequest liveQuestionnaireDetailSetRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/add-edit-questionnaire";
        Map<String, String> signMap = this.getSignMap(liveQuestionnaireDetailSetRequest);
        return this.postJsonBodyReturnOne(url, signMap, liveQuestionnaireDetailSetRequest, LiveQuestionnaireDetailSetResponse.class);
    }

    @Override
    public List<LiveQuestionnaireResultResponse> getQuestionnaireResultInfo(LiveQuestionnaireResultRequest liveQuestionnaireResultRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/answer-records";
        return this.getReturnList(url, liveQuestionnaireResultRequest, LiveQuestionnaireResultResponse.class);
    }

    @Override
    public LiveQuestionnaireResultPageResponse getQuestionnaireResultPageInfo(LiveQuestionnaireResultPageRequest liveQuestionnaireResultPageRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/questionnaire/list-answer-records";
        return this.getReturnOne(url, liveQuestionnaireResultPageRequest, LiveQuestionnaireResultPageResponse.class);
    }
}

