/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.base;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.DataParse;
import net.polyv.common.v1.base.HttpClientUtil;
import net.polyv.common.v1.util.MapUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    public static final String SOURCE = "source";
    public static final String VERSION = "version";
    public static final String USER_AGENT = "User-Agent";
    public static final String APP_ID_NAME = "java-sdk-app-id";
    public static final String USER_ID_NAME = "java-sdk-user-id";
    private static final String CURRENT_VERSION = "1.0.19";
    private static final String UTF8 = "UTF-8";
    private static String SDK = "SDK";
    private static String APP_ID = "";
    private static String USER_ID = "";

    private HttpUtil() {
    }

    public static String get(String url) throws IOException {
        return HttpUtil.get(url, null);
    }

    public static String get(String url, Map<String, String> paramMap) throws IOException {
        return HttpUtil.get(url, paramMap, UTF8);
    }

    public static String get(String url, Map<String, String> paramMap, String encoding) throws IOException {
        encoding = encoding == null ? UTF8 : encoding;
        url = MapUtil.appendUrl(url, paramMap);
        return HttpUtil.get(url, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString(httpEntity, encoding);
            }
        });
    }

    public static byte[] getBinary(String url, Map<String, String> paramMap, String encoding) throws IOException {
        encoding = encoding == null ? UTF8 : encoding;
        url = MapUtil.appendUrl(url, paramMap);
        return HttpUtil.get(url, encoding, new DataParse<byte[]>(){

            @Override
            public byte[] parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toByteArray(httpEntity);
            }
        });
    }

    private static <T> T get(String url, String encoding, DataParse<T> dataParse) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {}", (Object)url);
        T result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-type", "application/json; charset=UTF-8");
        CloseableHttpResponse response = HttpUtil.sendRequestAndGetResult(url, httpClient, httpGet);
        if (null != response && !((result = (T)dataParse.parseData(response.getEntity(), encoding)) instanceof byte[])) {
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
        }
        return result;
    }

    public static String postFormBody(String url, Map<String, String> paramMap) throws IOException {
        return HttpUtil.postFormBody(url, paramMap, null);
    }

    public static String postFormBody(String url, Map<String, String> paramMap, String encoding) throws IOException {
        return HttpUtil.post(url, paramMap, encoding);
    }

    private static String post(String url, Map<String, String> paramMap, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(paramMap));
        encoding = encoding == null ? UTF8 : encoding;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                nameValuePairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs, encoding));
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        return HttpUtil.post(url, httpPost, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString(httpEntity, encoding);
            }
        });
    }

    public static String postJsonBody(String url, String json, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)json);
        encoding = encoding == null ? UTF8 : encoding;
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        stringEntity.setContentEncoding(encoding);
        httpPost.setEntity(stringEntity);
        String result = HttpUtil.post(url, httpPost, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString(httpEntity, encoding);
            }
        });
        return result;
    }

    private static <T> T post(String url, HttpPost httpPost, String encoding, DataParse<T> dataParse) throws IOException {
        T result = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        response = HttpUtil.sendRequestAndGetResult(url, httpClient, httpPost);
        if (null != response) {
            result = dataParse.parseData(response.getEntity(), encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
        }
        return result;
    }

    private static void setHttpHeader(HttpUriRequest httpUriRequest) {
        httpUriRequest.addHeader(SOURCE, SDK);
        httpUriRequest.setHeader(USER_AGENT, SDK);
        httpUriRequest.addHeader(VERSION, CURRENT_VERSION);
        httpUriRequest.addHeader(APP_ID_NAME, HttpUtil.getAppId());
        httpUriRequest.addHeader(USER_ID_NAME, HttpUtil.getUserId());
    }

    private static CloseableHttpResponse sendRequestAndGetResult(String url, CloseableHttpClient httpClient, HttpUriRequest httpUriRequest) throws IOException {
        HttpUtil.setHttpHeader(httpUriRequest);
        long startTime = System.currentTimeMillis();
        CloseableHttpResponse response = httpClient.execute(httpUriRequest);
        long endTime = System.currentTimeMillis();
        HttpUtil.collectAPISpendTime(url, startTime, endTime);
        return response;
    }

    private static void collectAPISpendTime(String url, long startTime, long endTime) {
        log.debug("HTTP\u8bf7\u6c42\u8017\u65f6\u5206\u6790\uff0c\u8bf7\u6c42URL: {} \uff0c userId: {} \uff0c appId: {} \uff0c sdk\u7248\u672c: {} \uff0c   \u8017\u65f6: {} ms", url, HttpUtil.getUserId(), HttpUtil.getAppId(), CURRENT_VERSION, endTime - startTime);
    }

    public static String postFile(String url, Map<String, String> paramMap, Map<String, File> fileMap, String encoding) throws IOException {
        if (fileMap != null) {
            HashMap<String, List<File>> fileListMap = new HashMap<String, List<File>>();
            for (Map.Entry<String, File> entry : fileMap.entrySet()) {
                File file = entry.getValue();
                ArrayList<File> fileList = new ArrayList<File>();
                fileList.add(file);
                fileListMap.put(entry.getKey(), fileList);
            }
            return HttpUtil.postMultipleFile(url, paramMap, fileListMap, encoding);
        }
        return HttpUtil.postMultipleFile(url, paramMap, null, encoding);
    }

    public static String postMultipleFile(String url, Map<String, String> paramMap, Map<String, List<File>> fileListMap, String encoding) throws IOException {
        return HttpUtil.postFileBody(url, paramMap, fileListMap, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString(httpEntity, encoding);
            }
        });
    }

    private static <T> T postFileBody(String url, Map<String, String> paramMap, Map<String, List<File>> fileListMap, String encoding, DataParse<T> dataParse) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(paramMap));
        encoding = encoding == null ? UTF8 : encoding;
        T result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create("text/plain", Charset.forName(encoding));
        if (null != paramMap) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                entityBuilder.addTextBody(entry.getKey(), (String)entry.getValue(), contentType);
            }
        }
        if (null != fileListMap) {
            for (Map.Entry<String, Object> entry : fileListMap.entrySet()) {
                String key = entry.getKey();
                List fileList = (List)entry.getValue();
                for (File file : fileList) {
                    FileBody fileBody = new FileBody(file);
                    entityBuilder.addPart(key, fileBody);
                }
            }
        }
        HttpEntity entity = entityBuilder.build();
        httpPost.setEntity(entity);
        CloseableHttpResponse closeableHttpResponse = HttpUtil.sendRequestAndGetResult(url, httpClient, httpPost);
        if (null != closeableHttpResponse) {
            result = dataParse.parseData(closeableHttpResponse.getEntity(), encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != closeableHttpResponse) {
                closeableHttpResponse.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
        }
        return result;
    }

    public static String getSDK() {
        return SDK;
    }

    public static void setSDK(String SDK) {
        HttpUtil.SDK = SDK;
    }

    public static String getAppId() {
        return APP_ID;
    }

    public static void setAppId(String appId) {
        APP_ID = appId;
    }

    public static String getUserId() {
        return USER_ID;
    }

    public static void setUserId(String userId) {
        USER_ID = userId;
    }
}

