/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.HttpUtil;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.common.v1.validator.ViolationMsg;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveConstant;
import net.polyv.live.v1.entity.LiveCommonRequest;
import net.polyv.live.v1.entity.LiveCommonResponse;
import net.polyv.live.v1.util.LiveSignUtil;
import net.polyv.live.v1.util.MapUtil;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveBaseService {
    private static final Logger log = LoggerFactory.getLogger(LiveBaseService.class);
    public static final String ERROR_PREFIX = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";
    public static final String ERROR_INFO = " ,\u9519\u8bef\u539f\u56e0\uff1a ";
    public static final String ERROR_SUFFIX = " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
    public static final String ERROR_PREFIX1 = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";

    protected <T, E extends LiveCommonRequest> T baseGet(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> baseGetReturnArray(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse baseGet(String url, E e) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        Map<String, String> paramMap = this.commonRequestLogic(e);
        String queryStr = MapUtil.mapJoinNotEncode(paramMap);
        String response = HttpUtil.sendGetData(url = url + "?" + queryStr, Consts.UTF_8.toString());
        if (StringUtils.isNotBlank(response)) {
            liveCommonResponse = JSON.parseObject(response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(liveCommonResponse.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    protected <E extends LiveCommonRequest> byte[] baseGetReturnArray(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(e);
        String queryStr = MapUtil.mapJoinNotEncode(paramMap);
        byte[] response = HttpUtil.sendGetDataReturnArray(url = url + "?" + queryStr, Consts.UTF_8.toString());
        if (response == null) {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return response;
    }

    private <E extends LiveCommonRequest> Map<String, String> commonRequestLogic(E e) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank(e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        Map<String, String> paramMap = MapUtil.objectToMap(e);
        paramMap = MapUtil.filterNullValue(paramMap);
        String sign = LiveSignUtil.setLiveSign(paramMap, LiveGlobalConfig.getAppId(), LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        return paramMap;
    }

    private <E extends LiveCommonRequest> void validateBean(E e) {
        List<ViolationMsg> violationMsgList = SDKValidateUtil.validateBean(e, new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr(violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + e.getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            log.error(errors);
            throw new PloyvSdkException(LiveConstant.ERROR_CODE, errors);
        }
    }

    protected <T, E extends LiveCommonRequest> List<T> basePostReturnArray(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePost(url, e).parseArray(tClass);
    }

    protected <T, E extends LiveCommonRequest> T basePost(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePost(url, e).parseData(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse basePost(String url, E e) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        Map<String, String> paramMap = this.commonRequestLogic(e);
        String response = HttpUtil.sendPostDataByMap(url, paramMap, Consts.UTF_8.toString());
        if (StringUtils.isNotBlank(response)) {
            liveCommonResponse = JSON.parseObject(response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(liveCommonResponse.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    protected <T, E extends LiveCommonRequest> T basePostJson(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        Map<String, String> signMap = MapUtil.getSignMap(e);
        return this.basePostJson(url, signMap, e, tClass);
    }

    protected <T, E extends LiveCommonRequest> T basePostJson(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, signMap, e, "").parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> T basePostJson(String url, Map<String, String> signMap, E e, String json, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, signMap, e, json).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> basePostJsonReturnArray(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, signMap, e, "").parseArray(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> basePostJsonReturnArray(String url, Map<String, String> signMap, E e, String json, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, signMap, e, json).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse basePostJson(String url, Map<String, String> signMap, E e, String json) throws IOException, NoSuchAlgorithmException {
        String response;
        LiveCommonResponse liveCommonResponse = null;
        e.setAppId(LiveGlobalConfig.getAppId());
        if (StringUtils.isBlank(e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        String sign = LiveSignUtil.setLiveSign(signMap, LiveGlobalConfig.getAppId(), LiveGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        url = url + "?" + MapUtil.mapJoinNotEncode(signMap);
        if (StringUtils.isBlank(json)) {
            json = JSON.toJSONString(e);
        }
        if (StringUtils.isNotBlank(response = HttpUtil.sendPostDataByJson(url, json, Consts.UTF_8.toString()))) {
            liveCommonResponse = JSON.parseObject(response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(liveCommonResponse.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    protected <T, E extends LiveCommonRequest> T baseUploadFile(String url, E e, Map<String, File> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseUploadFile(url, e, fileMap).parseData(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse baseUploadFile(String url, E e, Map<String, File> fileMap) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        Map<String, String> paramMap = this.commonRequestLogic(e);
        String response = HttpUtil.sendUploadFile(url, paramMap, fileMap, Consts.UTF_8.toString());
        if (StringUtils.isNotBlank(response)) {
            liveCommonResponse = JSON.parseObject(response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(liveCommonResponse.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return liveCommonResponse;
    }

    protected <T, E extends LiveCommonRequest> T baseUploadFileList(String url, E e, Map<String, List<File>> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseUploadFileList(url, e, fileMap).parseData(tClass);
    }

    protected <T, E extends LiveCommonRequest> List<T> baseUploadFileListReturnArray(String url, E e, Map<String, List<File>> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseUploadFileList(url, e, fileMap).parseArray(tClass);
    }

    private <E extends LiveCommonRequest> LiveCommonResponse baseUploadFileList(String url, E e, Map<String, List<File>> fileMap) throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse = null;
        Map<String, String> paramMap = this.commonRequestLogic(e);
        String response = HttpUtil.sendUploadFileList(url, paramMap, fileMap, Consts.UTF_8.toString());
        if (StringUtils.isNotBlank(response)) {
            liveCommonResponse = JSON.parseObject(response, LiveCommonResponse.class);
            if (liveCommonResponse.getCode() != 200) {
                String message = ERROR_PREFIX1 + e.getRequestId() + ERROR_INFO + liveCommonResponse.getMessage();
                PloyvSdkException exception = new PloyvSdkException(liveCommonResponse.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(LiveConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return liveCommonResponse;
    }
}

