/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.channel.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAdvertListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAdvertListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAuthTokenRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAuthTokenResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelBasicInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelBasicInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelCallbackSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelCallbackSettingResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelCaptureRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelDetailRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInitRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInitResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelPasswordSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelTransmitListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelTransmitListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelPPTRecordRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelTokenRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateDiskVideosStreamRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelTokenRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteDiskVideosStreamRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteSonChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveListChannelPPTRecordRequest;
import net.polyv.live.v1.entity.channel.operate.LiveListChannelPPTRecordResponse;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateChannelCallbackSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateChannelMaxViewerRequest;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateChannelStreamRequest;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateSonChannelInfoRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelOperateService;
import net.polyv.live.v1.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveChannelOperateServiceImpl
extends LiveBaseService
implements ILiveChannelOperateService {
    private static final Logger log = LoggerFactory.getLogger(LiveChannelOperateServiceImpl.class);

    @Override
    public LiveChannelResponse createChannel(LiveChannelRequest liveChannelRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = "https://api.polyv.net/live/v2/channels/";
        LiveChannelResponse liveChannelResponse = this.basePost(url, liveChannelRequest, LiveChannelResponse.class);
        return liveChannelResponse;
    }

    @Override
    public LiveChannelInitResponse createChannelInit(LiveChannelInitRequest liveChannelInitRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/basic/create";
        LiveChannelInitResponse liveChannelInitResponse = this.basePostJson(url, liveChannelInitRequest, LiveChannelInitResponse.class);
        return liveChannelInitResponse;
    }

    @Override
    public LiveCreateChannelListResponse createChannelList(LiveCreateChannelListRequest liveCreateChannelListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/basic/batch-create";
        LiveCreateChannelListResponse liveCreateChannelListResponse = this.basePostJson(url, liveCreateChannelListRequest, LiveCreateChannelListResponse.class);
        return liveCreateChannelListResponse;
    }

    @Override
    public Boolean updateChannelSetting(LiveChannelSettingRequest liveChannelSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/basic/update";
        Map<String, String> signMap = MapUtil.getSignMap(liveChannelSettingRequest);
        signMap.put("channelId", liveChannelSettingRequest.getChannelId() + "");
        String liveChannelSettingResponse = this.basePostJson(url, signMap, liveChannelSettingRequest, String.class);
        return "success".equals(liveChannelSettingResponse);
    }

    @Override
    public Boolean updateChannelDetail(LiveChannelDetailRequest liveChannelDetailRequest) throws IOException, NoSuchAlgorithmException {
        if ("channelPasswd".equals(liveChannelDetailRequest.getField())) {
            liveChannelDetailRequest.setField("password");
        }
        String url = "https://api.polyv.net/live/v3/channel/detail/update";
        String liveChannelDetailResponse = this.basePost(url, liveChannelDetailRequest, String.class);
        return "true".equals(liveChannelDetailResponse);
    }

    @Override
    public LiveListChannelPPTRecordResponse listPPTRecord(LiveListChannelPPTRecordRequest liveListChannelPPTRecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/pptRecord/list";
        return this.baseGet(url, liveListChannelPPTRecordRequest, LiveListChannelPPTRecordResponse.class);
    }

    @Override
    public Boolean updateChannelPassword(LiveChannelPasswordSettingRequest liveChannelPasswordSettingRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelPasswordSettingRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/passwdSetting", liveChannelPasswordSettingRequest.getUserId());
        String updateChannelPasswordResponse = this.basePost(url, liveChannelPasswordSettingRequest, String.class);
        return "true".equals(updateChannelPasswordResponse);
    }

    @Override
    public Boolean deleteChannel(LiveDeleteChannelRequest liveDeleteChannelRequest) throws IOException, NoSuchAlgorithmException {
        liveDeleteChannelRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/delete", liveDeleteChannelRequest.getChannelId());
        String liveDeleteChannelResponse = this.basePost(url, liveDeleteChannelRequest, String.class);
        return "true".equals(liveDeleteChannelResponse);
    }

    @Override
    public Boolean deleteChannelList(LiveDeleteChannelListRequest liveDeleteChannelListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/basic/batch-delete";
        String liveDeleteChannelListResponse = this.basePostJson(url, liveDeleteChannelListRequest, String.class);
        return "true".equals(liveDeleteChannelListResponse);
    }

    @Override
    public Boolean createChannelToken(LiveCreateChannelTokenRequest liveCreateChannelTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/set-token", liveCreateChannelTokenRequest.getChannelId());
        String liveCreateChannelTokenResponse = this.basePost(url, liveCreateChannelTokenRequest, String.class);
        String success = "success";
        return success.equals(liveCreateChannelTokenResponse);
    }

    @Override
    public LiveChannelInfoResponse getChannelInfo(LiveChannelInfoRequest liveChannelInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/get", liveChannelInfoRequest.getChannelId());
        LiveChannelInfoResponse liveChannelInfoResponse = this.baseGet(url, liveChannelInfoRequest, LiveChannelInfoResponse.class);
        return liveChannelInfoResponse;
    }

    @Override
    public LiveChannelBasicInfoResponse getChannelBasicInfo(LiveChannelBasicInfoRequest liveChannelBasicInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/basic/get";
        LiveChannelBasicInfoResponse liveChannelBasicInfoResponse = this.basePost(url, liveChannelBasicInfoRequest, LiveChannelBasicInfoResponse.class);
        return liveChannelBasicInfoResponse;
    }

    @Override
    public LiveChannelAuthTokenResponse getChannelAuthToken(LiveChannelAuthTokenRequest liveCreateChannelTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/common/get-chat-token";
        liveCreateChannelTokenRequest.setUserId(LiveGlobalConfig.getUserId());
        LiveChannelAuthTokenResponse liveChannelAuthTokenResponse = this.basePost(url, liveCreateChannelTokenRequest, LiveChannelAuthTokenResponse.class);
        return liveChannelAuthTokenResponse;
    }

    @Override
    public LiveCreateSonChannelResponse createSonChannel(LiveCreateSonChannelRequest liveCreateSonChannelRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAccount/%s/add", liveCreateSonChannelRequest.getChannelId());
        LiveCreateSonChannelResponse liveCreateSonChannelResponse = this.basePost(url, liveCreateSonChannelRequest, LiveCreateSonChannelResponse.class);
        return liveCreateSonChannelResponse;
    }

    @Override
    public Boolean updateSonChannelInfo(LiveUpdateSonChannelInfoRequest liveUpdateSonChannelInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAccount/%s/update", liveUpdateSonChannelInfoRequest.getChannelId());
        String updateSonChannelInfoResponse = this.basePost(url, liveUpdateSonChannelInfoRequest, String.class);
        return "success".equals(updateSonChannelInfoResponse);
    }

    @Override
    public Boolean createSonChannelToken(LiveCreateSonChannelTokenRequest liveCreateSonChannelTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channels/%s/set-account-token", liveCreateSonChannelTokenRequest.getAccount());
        String liveCreateSonChannelTokenResponse = this.basePost(url, liveCreateSonChannelTokenRequest, String.class);
        return "success".equals(liveCreateSonChannelTokenResponse);
    }

    @Override
    public LiveSonChannelInfoResponse getSonChannelInfo(LiveSonChannelInfoRequest liveSonChannelInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAccount/%s/account", liveSonChannelInfoRequest.getChannelId());
        LiveSonChannelInfoResponse liveSonChannelInfoResponse = this.baseGet(url, liveSonChannelInfoRequest, LiveSonChannelInfoResponse.class);
        return liveSonChannelInfoResponse;
    }

    @Override
    public LiveSonChannelInfoListResponse getSonChannelInfoList(LiveSonChannelInfoListRequest liveSonChannelInfoListRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAccount/%s/accounts", liveSonChannelInfoListRequest.getChannelId());
        LiveSonChannelInfoResponse[] liveSonChannelInfoResponses = this.baseGet(url, liveSonChannelInfoListRequest, LiveSonChannelInfoResponse[].class);
        if (liveSonChannelInfoResponses == null) {
            liveSonChannelInfoResponses = new LiveSonChannelInfoResponse[]{};
        }
        LiveSonChannelInfoListResponse liveSonChannelInfoListResponse = new LiveSonChannelInfoListResponse();
        liveSonChannelInfoListResponse.setSonChannelInfos(Arrays.asList(liveSonChannelInfoResponses));
        return liveSonChannelInfoListResponse;
    }

    @Override
    public Boolean deleteSonChannel(LiveDeleteSonChannelRequest liveDeleteSonChannelRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelAccount/%s/delete", liveDeleteSonChannelRequest.getChannelId());
        String liveDeleteSonChannelResponse = this.basePost(url, liveDeleteSonChannelRequest, String.class);
        return "true".equals(liveDeleteSonChannelResponse);
    }

    @Override
    public Boolean createChannelPPTRecordTask(LiveCreateChannelPPTRecordRequest liveCreateChannelPPTRecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/pptRecord/addRecordTask";
        String liveCreateChannelPPTRecordResponse = this.basePost(url, liveCreateChannelPPTRecordRequest, String.class);
        return "success".equals(liveCreateChannelPPTRecordResponse);
    }

    @Override
    public LiveChannelCallbackSettingResponse getChannelCallbackSetting(LiveChannelCallbackSettingRequest liveChannelCallbackSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/callback/get-setting";
        return this.baseGet(url, liveChannelCallbackSettingRequest, LiveChannelCallbackSettingResponse.class);
    }

    @Override
    public Boolean updateChannelCallbackSetting(LiveUpdateChannelCallbackSettingRequest liveUpdateChannelCallbackSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/callback/update-setting";
        String liveUpdateChannelCallbackSettingResponse = this.basePost(url, liveUpdateChannelCallbackSettingRequest, String.class);
        return "success".equals(liveUpdateChannelCallbackSettingResponse);
    }

    @Override
    public LiveCreateSonChannelListResponse createSonChannelList(LiveCreateSonChannelListRequest liveCreateSonChannelListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/account/batch-create";
        Map<String, String> map = MapUtil.getSignMap(liveCreateSonChannelListRequest);
        map.put("channelId", liveCreateSonChannelListRequest.getChannelId());
        List<LiveCreateSonChannelListResponse.SonChannelInfo> sonChannelInfos = this.basePostJsonReturnArray(url, map, liveCreateSonChannelListRequest, JSON.toJSONString(liveCreateSonChannelListRequest.getSonChannels()), LiveCreateSonChannelListResponse.SonChannelInfo.class);
        LiveCreateSonChannelListResponse liveCreateSonChannelListResponse = new LiveCreateSonChannelListResponse();
        liveCreateSonChannelListResponse.setSonChannelInfos(sonChannelInfos);
        return liveCreateSonChannelListResponse;
    }

    @Override
    public LiveChannelTransmitListResponse getChannelTransmitList(LiveChannelTransmitListRequest liveChannelTransmitListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/transmit/get-associations";
        List<LiveChannelTransmitListResponse.ChannelTransmit> channelTransmits = this.baseGetReturnArray(url, liveChannelTransmitListRequest, LiveChannelTransmitListResponse.ChannelTransmit.class);
        LiveChannelTransmitListResponse liveChannelTransmitListResponse = new LiveChannelTransmitListResponse();
        liveChannelTransmitListResponse.setChannelTransmits(channelTransmits);
        return liveChannelTransmitListResponse;
    }

    @Override
    public Boolean updateChannelMaxViewer(LiveUpdateChannelMaxViewerRequest liveUpdateChannelMaxViewerRequest) throws IOException, NoSuchAlgorithmException {
        liveUpdateChannelMaxViewerRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/channelRestrict/%s/set-max-viewer", liveUpdateChannelMaxViewerRequest.getChannelId());
        String liveUpdateChannelMaxViewerResponse = this.basePost(url, liveUpdateChannelMaxViewerRequest, String.class);
        return "success".equals(liveUpdateChannelMaxViewerResponse);
    }

    @Override
    public LiveChannelAdvertListResponse getChannelAdvertList(LiveChannelAdvertListRequest liveChannelAdvertListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/advert/list";
        List<LiveChannelAdvertListResponse.ChannelAdvert> channelAdverts = this.baseGetReturnArray(url, liveChannelAdvertListRequest, LiveChannelAdvertListResponse.ChannelAdvert.class);
        LiveChannelAdvertListResponse liveChannelAdvertListResponse = new LiveChannelAdvertListResponse();
        liveChannelAdvertListResponse.setChannelAdverts(channelAdverts);
        return liveChannelAdvertListResponse;
    }

    @Override
    public String getChannelCapture(LiveChannelCaptureRequest liveChannelCaptureRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("https://api.polyv.net/live/v2/stream/%s/capture", liveChannelCaptureRequest.getChannelId());
        return this.basePost(url, liveChannelCaptureRequest, String.class);
    }

    @Override
    public Boolean updateChannelStream(LiveUpdateChannelStreamRequest liveUpdateChannelStreamRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/stream/update";
        String liveUpdateChannelStreamResponse = this.basePost(url, liveUpdateChannelStreamRequest, String.class);
        return "success".equals(liveUpdateChannelStreamResponse);
    }

    @Override
    public Boolean createDiskVideosStream(LiveCreateDiskVideosStreamRequest liveCreateDiskVideosStreamRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/stream/add-disk-videos";
        String liveCreateDiskVideosStreamResponse = this.basePost(url, liveCreateDiskVideosStreamRequest, String.class);
        return "success".equals(liveCreateDiskVideosStreamResponse);
    }

    @Override
    public Boolean deleteDiskVideosStream(LiveDeleteDiskVideosStreamRequest liveDeleteDiskVideosStreamRequest) throws IOException, NoSuchAlgorithmException {
        String url = "https://api.polyv.net/live/v3/channel/stream/delete-disk-videos";
        String liveDeleteDiskVideosStreamResponse = this.basePost(url, liveDeleteDiskVideosStreamRequest, String.class);
        return "success".equals(liveDeleteDiskVideosStreamResponse);
    }
}

