/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.validator.handle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import net.polyv.common.v1.validator.constraints.Length;
import net.polyv.common.v1.validator.handle.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthValidator
extends Validator {
    private static final Logger log = LoggerFactory.getLogger(LengthValidator.class);

    public LengthValidator() {
        this.currentClass = Length.class;
    }

    @Override
    protected String dealValidate(Annotation annotation, Field field, Object data, Class<?> ... groups) {
        if (data == null) {
            return null;
        }
        Length cast = (Length)Length.class.cast(annotation);
        if (this.showMsg(groups, cast.groups())) {
            if (data instanceof CharSequence) {
                int length = ((CharSequence)data).length();
                return this.isValid(cast.min(), cast.max(), length) ? null : cast.message();
            }
            if (data instanceof List) {
                int length = ((List)data).size();
                return this.isValid(cast.min(), cast.max(), length) ? null : cast.message();
            }
            if (data.getClass().isArray()) {
                int length = ((Object[])data).length;
                return this.isValid(cast.min(), cast.max(), length) ? null : cast.message();
            }
            throw new RuntimeException(field.getName() + " Length validation exception");
        }
        return null;
    }

    private boolean isValid(long min, long max, long length) {
        return length >= min && length <= max;
    }
}

