package net.polyv.group.v1.service.user.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.group.v1.constant.GroupURL;
import net.polyv.group.v1.entity.user.GroupCreateUserRequest;
import net.polyv.group.v1.entity.user.GroupCreateUserResponse;
import net.polyv.group.v1.entity.user.GroupListPackageRequest;
import net.polyv.group.v1.entity.user.GroupListPackageResponse;
import net.polyv.group.v1.entity.user.GroupUpdatePackageRequest;
import net.polyv.group.v1.service.GroupBaseService;
import net.polyv.group.v1.service.user.IUserService;

/**
 * 集团子账号业务层实现类
 * @author: liyongxuan
 */
public class UserServiceImpl extends GroupBaseService implements IUserService {
    
    /**
     * 查询分账号列表及剩余资源
     * API地址：https://help.polyv.net/#/live/api/v4/group/user/package_list
     * @param groupListPackageRequest 查询分账号列表及剩余资源请求实体
     * @return 查询分账号列表及剩余资源响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public GroupListPackageResponse listPackage(GroupListPackageRequest groupListPackageRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = GroupURL.GROUP_LIST_PACKAGE_URL;
        return this.getReturnOne(url, groupListPackageRequest, GroupListPackageResponse.class);
    }
    
    /**
     * 创建集团分帐号
     * API地址：https://help.polyv.net/#/live/api/v4/group/user/create
     * @param groupCreateUserRequest 创建集团分帐号请求实体
     * @return 创建集团分帐号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public GroupCreateUserResponse create(GroupCreateUserRequest groupCreateUserRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = GroupURL.GROUP_CREATE_URL;
        return this.postJsonBodyReturnOne(url, groupCreateUserRequest, GroupCreateUserResponse.class);
    }
    
    /**
     * 分配分帐号资源
     * API地址：https://help.polyv.net/#/live/api/v4/group/user/package_update
     * @param groupUpdatePackageRequest 分配分帐号资源请求实体
     * @return 分配分帐号资源响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updatePackage(GroupUpdatePackageRequest groupUpdatePackageRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = GroupURL.GROUP_UPDATE_PACKAGE_URL;
        this.postJsonBodyReturnOne(url, groupUpdatePackageRequest, Boolean.class);
        return Boolean.TRUE;
    }
}
