package net.polyv.group.v1.service.user;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.group.v1.entity.user.GroupCreateUserRequest;
import net.polyv.group.v1.entity.user.GroupCreateUserResponse;
import net.polyv.group.v1.entity.user.GroupListPackageRequest;
import net.polyv.group.v1.entity.user.GroupListPackageResponse;
import net.polyv.group.v1.entity.user.GroupUpdatePackageRequest;

/**
 * 集团分账号
 * @author: liyongxuan
 */
public interface IUserService {
    
    /**
     * 查询分账号列表及剩余资源
     * API地址：https://help.polyv.net/#/live/api/v4/group/user/package_list
     * @param groupListPackageRequest 查询分账号列表及剩余资源请求实体
     * @return 查询分账号列表及剩余资源响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    GroupListPackageResponse listPackage(GroupListPackageRequest groupListPackageRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 创建集团分帐号
     * API地址：https://help.polyv.net/#/live/api/v4/group/user/create
     * @param groupCreateUserRequest 创建集团分帐号请求实体
     * @return 创建集团分帐号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    GroupCreateUserResponse create(GroupCreateUserRequest groupCreateUserRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 分配分帐号资源
     * API地址：https://help.polyv.net/#/live/api/v4/group/user/package_update
     * @param groupUpdatePackageRequest 分配分帐号资源请求实体
     * @return 分配分帐号资源响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updatePackage(GroupUpdatePackageRequest groupUpdatePackageRequest)
            throws IOException, NoSuchAlgorithmException;
}
