package net.polyv.group.v1.entity.user;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.group.v1.entity.GroupPageCommonResponse;

/**
 * 查询分账号列表及剩余资源响应实体
 * @author liyongxuan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询分账号列表及剩余资源响应实体")
public class GroupListPackageResponse extends GroupPageCommonResponse {
    
    /**
     * 账单列表
     */
    @ApiModelProperty(name = "data", value = "账单列表", required = false)
    private List<Package> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("当前页内容")
    public static class Package {
        /**
         * 用户ID
         */
        @ApiModelProperty(name = "userId", value = "用户ID", required = false)
        private String userId;
        
        /**
         * 分帐号应用ID
         */
        @ApiModelProperty(name = "appId", value = "分帐号应用ID", required = false)
        private String appId;
        
        /**
         * 分帐号应用secret
         */
        @ApiModelProperty(name = "appSecret", value = "分帐号应用secret", required = false)
        private String appSecret;
        
        /**
         * 分帐号邮箱
         */
        @ApiModelProperty(name = "email", value = "分帐号邮箱", required = false)
        private String email;
        
        /**
         * 剩余金额
         */
        @ApiModelProperty(name = "balance", value = "剩余金额", required = false)
        private String balance;
        
        /**
         * 手机号码
         */
        @ApiModelProperty(name = "phone", value = "手机号码", required = false)
        private String phone;
        
        /**
         * 备注
         */
        @ApiModelProperty(name = "memo", value = "备注", required = false)
        private String memo;
        
        /**
         * 联系人
         */
        @ApiModelProperty(name = "contacts", value = "联系人", required = false)
        private String contacts;
        
        /**
         * 云直播计费类型 minutes：分钟数 parallelConcurrent：并行并发 totalConcurrent：累计并发
         */
        @ApiModelProperty(name = "chargeType", value = "云直播计费类型 minutes：分钟数 parallelConcurrent：并行并发 " +
                "totalConcurrent：累计并发", required = false)
        private String chargeType;
        
        /**
         * 云直播剩余资源，并发
         */
        @ApiModelProperty(name = "remainConcurrent", value = "云直播剩余资源，并发", required = false)
        private Long remainConcurrent;
        
        /**
         * 云直播剩余资源，可用直播分钟数
         */
        @ApiModelProperty(name = "remainMinutes", value = "云直播剩余资源，可用直播分钟数", required = false)
        private Long remainMinutes;
        
        /**
         * 云点播剩余资源，流量(G)
         */
        @ApiModelProperty(name = "remainFlow", value = "云点播剩余资源，流量(G)", required = false)
        private Float remainFlow;
        
        /**
         * 云点播剩余资源，空间(G)
         */
        @ApiModelProperty(name = "remainSpace", value = "云点播剩余资源，空间(G)", required = false)
        private Float remainSpace;
        
        /**
         * 到期时间类型 group：跟随主账号 custom：自定义
         */
        @ApiModelProperty(name = "expireType", value = "到期时间类型 group：跟随主账号 custom：自定义", required = false)
        private String expireType;
        
        /**
         * 账号到期时间，十三位时间戳
         */
        @ApiModelProperty(name = "expireDate", value = "账号到期时间，十三位时间戳", required = false)
        private Long expireDate;
        
        /**
         * 状态 normal：正常使用 expired：已过期 frozen：已冻结
         */
        @ApiModelProperty(name = "status", value = "状态 normal：正常使用 expired：已过期 frozen：已冻结", required = false)
        private String status;
        
        /**
         * 可用连麦分钟数
         */
        @ApiModelProperty(name = "linkMicMinutes", value = "可用连麦分钟数", required = false)
        private Integer linkMicMinutes;
        
        /**
         * 可用云导播台分钟数
         */
        @ApiModelProperty(name = "guideMinutes", value = "可用云导播台分钟数", required = false)
        private Integer guideMinutes;
        
        /**
         * 可创建频道数
         */
        @ApiModelProperty(name = "maxChannels", value = "可创建频道数", required = false)
        private Integer maxChannels;
        
        /**
         * 连麦人数
         */
        @ApiModelProperty(name = "linkMicLimit", value = "连麦人数", required = false)
        private Integer linkMicLimit;
        
        /**
         * 点播secretkey
         */
        @ApiModelProperty(name = "vodSecretKey", value = "点播secretkey", required = false)
        private String vodSecretKey;
        
        /**
         * 点播备用secretkey
         */
        @ApiModelProperty(name = "vodBakSecretKey", value = "点播备用secretkey", required = false)
        private String vodBakSecretKey;
        
        /**
         * 点播writetoken
         */
        @ApiModelProperty(name = "writeToken", value = "点播writetoken", required = false)
        private String writeToken;
        
        /**
         * 点播readtoken
         */
        @ApiModelProperty(name = "readToken", value = "点播readtoken", required = false)
        private String readToken;
    }
    
}