package net.polyv.group.v1.entity.user;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.group.v1.entity.GroupCommonRequest;

/**
 * 创建集团分帐号请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建集团分帐号请求实体")
public class GroupCreateUserRequest extends GroupCommonRequest {
    /**
     * 邮箱
     */
    @ApiModelProperty(name = "email", value = "邮箱", required = true)
    @NotNull(message = "属性email不能为空")
    private String email;
    
    /**
     * 密码，需要同时包含数字、英文，长度8~32位
     */
    @ApiModelProperty(name = "password", value = "密码，需要同时包含数字、英文，长度8~32位", required = true)
    @NotNull(message = "属性password不能为空")
    private String password;
    
    /**
     * 联系人
     */
    @ApiModelProperty(name = "contacts", value = "联系人", required = true)
    @NotNull(message = "属性contacts不能为空")
    private String contacts;
    
    /**
     * 手机号码，手机号不能绑定超过3个邮箱
     */
    @ApiModelProperty(name = "phone", value = "手机号码，手机号不能绑定超过3个邮箱", required = true)
    @NotNull(message = "属性phone不能为空")
    private String phone;
    
    /**
     * 最多可创建频道数量
     */
    @ApiModelProperty(name = "maxChannels", value = "最多可创建频道数量", required = true)
    @NotNull(message = "属性maxChannels不能为空")
    private Integer maxChannels;
    
    /**
     * 分钟数，主账号为分钟数计费，该用量值必填
     */
    @ApiModelProperty(name = "minutes", value = "分钟数，主账号为分钟数计费，该用量值必填", required = false)
    private Integer minutes;
    
    /**
     * 并发数，主账号为并发计费，该用量值必填
     */
    @ApiModelProperty(name = "concurrent", value = "并发数，主账号为并发计费，该用量值必填", required = false)
    private Integer concurrent;
    
    /**
     * 金额，不能小于0
     */
    @ApiModelProperty(name = "balance", value = "金额，不能小于0", required = false)
    private Float balance;
    
    /**
     * 备注，50字符长度
     */
    @ApiModelProperty(name = "memo", value = "备注，50字符长度", required = false)
    private String memo;
    
    /**
     * 到期时间类型 group：跟随主账号 custom：自定义
     */
    @ApiModelProperty(name = "expireType", value = "到期时间类型 group：跟随主账号 custom：自定义", required = false)
    private String expireType;
    
    /**
     * 账号过期时间，格式yyyy-MM-dd，如20220428
     */
    @ApiModelProperty(name = "expireDate", value = "账号过期时间，yyyy-MM-dd，如2022-04-28", required = false)
    @JSONField(format = "yyyyMMdd")
    private Date expireDate;
    
    /**
     * 点播流量，单位G，默认分配100G
     */
    @ApiModelProperty(name = "remainFlow", value = "点播流量，单位G，默认分配100G", required = false)
    private Integer remainFlow;
    
    /**
     * 点播空间，单位G，默认分配100G
     */
    @ApiModelProperty(name = "remainSpace", value = "点播空间，单位G，默认分配100G", required = false)
    private Integer remainSpace;
    
}