package net.polyv.group.v1.entity.account;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.group.v1.entity.GroupCommonRequest;

/**
 * 查询主账号账单统计请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询主账号账单统计请求实体")
public class GroupListBillingRequest extends GroupCommonRequest {
    /**
     * 账期，格式yyyyMM，比如202205，时间需要在202204以后
     */
    @ApiModelProperty(name = "billingDate", value = "账期，格式yyyyMM，比如202205，时间需要在202204以后", required = true)
    @NotNull(message = "属性billingDate不能为空")
    @JSONField(format = "yyyyMM")
    private Date billingDate;
    
    /**
     * 每页数据大小，默认10，最大值1000
     */
    @ApiModelProperty(name = "pageSize", value = "每页数据大小，默认10，最大值1000", required = false)
    private Integer pageSize;
    
    /**
     * 当前的页数，默认1
     */
    @ApiModelProperty(name = "pageNumber", value = "当前的页数，默认1", required = false)
    private Integer pageNumber;
    
}