package net.polyv.group.v1.service.account.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.group.v1.constant.GroupURL;
import net.polyv.group.v1.entity.account.GroupListBillingRequest;
import net.polyv.group.v1.entity.account.GroupListBillingResponse;
import net.polyv.group.v1.service.GroupBaseService;
import net.polyv.group.v1.service.account.IGroupService;

/**
 * 集团账号信息
 * @author: liyongxuan
 */
public class GroupServiceImpl extends GroupBaseService implements IGroupService {
    
    /**
     * 查询主账号账单统计
     * API地址：https://help.polyv.net/#/live/api/v4/group/account/billing_list
     * @param groupListBillingRequest 查询主账号账单统计请求实体
     * @return 查询主账号账单统计响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public GroupListBillingResponse listBilling(GroupListBillingRequest groupListBillingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = GroupURL.GROUP_LIST_BILLING_URL;
        return this.getReturnOne(url, groupListBillingRequest, GroupListBillingResponse.class);
    }
    
}
