package net.polyv.group.v1.entity.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.group.v1.entity.GroupCommonRequest;

/**
 * 分配分帐号资源请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("分配分帐号资源请求实体")
public class GroupUpdatePackageRequest extends GroupCommonRequest {
    /**
     * 分帐号邮箱
     */
    @ApiModelProperty(name = "email", value = "分帐号邮箱", required = true)
    @NotNull(message = "属性email不能为空")
    private String email;
    
    /**
     * 金额，不能小于0
     */
    @ApiModelProperty(name = "balance", value = "金额，不能小于0", required = false)
    private Float balance;
    
    /**
     * 并发数
     */
    @ApiModelProperty(name = "concurrent", value = "并发数", required = false)
    private Integer concurrent;
    
    /**
     * 可用分钟数（分）
     */
    @ApiModelProperty(name = "minutes", value = "可用分钟数（分）", required = false)
    private Integer minutes;
    
    /**
     * 点播流量，单位G
     */
    @ApiModelProperty(name = "remainFlow", value = "点播流量，单位G", required = false)
    private Integer remainFlow;
    
    /**
     * 点播空间，单位G
     */
    @ApiModelProperty(name = "remainSpace", value = "点播空间，单位G", required = false)
    private Integer remainSpace;
    
    /**
     * 连麦人数限制，最多16人
     */
    @ApiModelProperty(name = "linkMicLimit", value = "连麦人数限制，最多16人", required = false)
    private Integer linkMicLimit;
    
    /**
     * 连麦分钟数
     */
    @ApiModelProperty(name = "linkMicMinutes", value = "连麦分钟数", required = false)
    private Integer linkMicMinutes;
    
    /**
     * 云导播台分钟数
     */
    @ApiModelProperty(name = "guideMinutes", value = "云导播台分钟数", required = false)
    private Integer guideMinutes;
    
    /**
     * 可创建频道数
     */
    @ApiModelProperty(name = "maxChannels", value = "可创建频道数", required = false)
    private Integer maxChannels;
    
}