package net.polyv.group.v1.entity.account;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import net.polyv.group.v1.entity.GroupPageCommonResponse;

/**
 * 查询主账号账单统计响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询主账号账单统计响应实体")
public class GroupListBillingResponse extends GroupPageCommonResponse {
    
    /**
     * 当前页内容
     */
    @ApiModelProperty(name = "contents", value = "账单信息列表", required = false)
    private List<BillingInfo> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("账单信息")
    public static class BillingInfo {
        /**
         * 集团主帐号ID
         */
        @ApiModelProperty(name = "unionId", value = "集团主帐号ID", required = false)
        private String unionId;
        
        /**
         * 账期
         */
        @ApiModelProperty(name = "accountPeriod", value = "账期", required = false)
        private String accountPeriod;
        
        /**
         * 产品 云直播/云点播
         */
        @ApiModelProperty(name = "production", value = "产品 云直播/云点播", required = false)
        private String production;
        
        /**
         * 用量类型 云直播：观看分钟数/连麦分钟数/无延迟分钟数/导播时长 云点播：视频播放/存储空间
         */
        @ApiModelProperty(name = "category", value = "用量类型 云直播：观看分钟数/连麦分钟数/无延迟分钟数/导播时长 云点播：视频播放/存储空间", required = false)
        private String category;
        
        /**
         * 用量
         */
        @ApiModelProperty(name = "itemConsumed", value = "用量", required = false)
        private Float itemConsumed;
        
        /**
         * 用量单位
         */
        @ApiModelProperty(name = "itemConsumedUnit", value = "用量单位", required = false)
        private String itemConsumedUnit;
        
        /**
         * 结算日期，天，格式为yyyy-MM-dd
         */
        @ApiModelProperty(name = "statAt", value = "结算日期，天，格式为yyyy-MM-dd", required = false)
        @JSONField(format = "yyyy-MM-dd")
        private Date statAt;
        
        /**
         * 交易类型 1：用量结算 2：金额结算 3：补扣调账 4：退费调账
         */
        @ApiModelProperty(name = "tradeType", value = "交易类型 1：用量结算 2：金额结算 3：补扣调账 4：退费调账", required = false)
        private Integer tradeType;
    }
    
}