package net.polyv.group.v1.config;

import net.polyv.common.v1.base.HttpClientUtil;

/**
 * 集团账号全局配置类
 * @author: sadboy
 **/
public class GroupGlobalConfig {
    private GroupGlobalConfig() {
    }
    
    private static String APP_ID = "";
    private static String APP_SECRET = "";
    public static final String SDK_NAME = "JAVA_GROUP_SDK";
    
    public static String getAppId() {
        return APP_ID;
    }
    
    public static String getAppSecret() {
        return APP_SECRET;
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param appSecret appSecret
     */
    public static void init(String appId, String appSecret) {
        GroupGlobalConfig.APP_ID = appId;
        GroupGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.init();
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param appSecret appSecret
     * @param timeOut timeOut
     * @param maxClientNum maxClientNum
     */
    public static void init(String appId, String appSecret, Integer timeOut, Integer maxClientNum) {
        GroupGlobalConfig.APP_ID = appId;
        GroupGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.setTimeOut(timeOut);
        HttpClientUtil.setMaxClientNum(maxClientNum);
        HttpClientUtil.init();
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param appSecret appSecret
     * @param hostName 代理地址
     * @param port 代理端口
     * @param scheme 协议，默认为http
     */
    public static void init(String appId, String appSecret, String hostName, int port, String scheme) {
        GroupGlobalConfig.APP_ID = appId;
        GroupGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.init(hostName, port, scheme);
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param appSecret appSecret
     * @param timeOut 超时时间
     * @param maxClientNum 链接池最大并发连接数
     * @param hostName 代理地址
     * @param port 代理端口
     * @param scheme 协议，默认为http
     */
    public static void init(String appId, String appSecret, Integer timeOut, Integer maxClientNum,
            String hostName, int port, String scheme) {
        GroupGlobalConfig.APP_ID = appId;
        GroupGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.setTimeOut(timeOut);
        HttpClientUtil.setMaxClientNum(maxClientNum);
        HttpClientUtil.init(hostName, port, scheme);
    }
    
}
