package net.polyv.group.v1.config;

import lombok.extern.slf4j.Slf4j;
import net.polyv.common.v1.entity.AccountInfo;
import net.polyv.common.v1.util.FileUtil;

/**
 * @author: sadboy
 **/
@Slf4j
public class InitConfig {
    
    private InitConfig() {
    }
    
    /**
     * 初始化配置
     * @param appId appId
     * @param appSecret appSecret
     */
    public static void initPolyvGroup(String appId, String appSecret) {
        GroupGlobalConfig.init(appId, appSecret);
        log.debug("--初始化完成--");
    }
    
    
    /**
     * 初始化配置
     * 从文件读取JSON初始化配置，JSON格式如下：liveConfig:直播配置，vodConfig：点播配置
     * {"liveConfig":{"appId":"xxx","userId":"xxx","appSecret":"xxx"},"vodConfig":{"userId":"xxx","writeToken":"xxxxxxe","readToken":"xxxxxx","secretKey":"xxxx"},"groupConfig":{"appId":"xxxxxx","appSecret":"xxxx"}}
     * @param path 配置文件路径
     */
    public static void initPolyvGroupByFile(String path) {
        AccountInfo accountInfo = FileUtil.readConfigFromFile(path);
        String appId = accountInfo.getGroupConfig().getAppId();
        String appSecret = accountInfo.getGroupConfig().getAppSecret();
        InitConfig.initPolyvGroup(appId, appSecret);
    }
    
}
