/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.polyv.live.bean.client.HttpDeleteWithBody;
import net.polyv.live.bean.client.RequestHost;
import net.polyv.live.enumeration.ProxyType;
import net.polyv.live.util.MapUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientUtil {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String HTTPS_SCHEME = "https";
    private RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(15000).setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();
    private static HttpClientUtil instance = null;
    private RequestHost requestHost = null;
    private String defaultProxyHost = null;

    private HttpClientUtil() {
    }

    public static HttpClientUtil getInstance() {
        if (null == instance) {
            instance = new HttpClientUtil();
        }
        HttpClientUtil.instance.requestHost = null;
        HttpClientUtil.instance.defaultProxyHost = null;
        return instance;
    }

    public static HttpClientUtil getInstance(RequestHost requestHost, String proxyHost) {
        if (null == instance) {
            instance = new HttpClientUtil();
        }
        HttpClientUtil.instance.requestHost = requestHost;
        HttpClientUtil.instance.defaultProxyHost = proxyHost;
        return instance;
    }

    public String sendHttpPost(String httpUrl) {
        HttpPost httpPost = new HttpPost(httpUrl);
        return this.sendHttpRequest(httpPost);
    }

    public String sendHttpPost(String httpUrl, String params) {
        HttpPost httpPost = new HttpPost(httpUrl);
        try {
            StringEntity stringEntity = new StringEntity(params, CHARSET_UTF8);
            stringEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity(stringEntity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return this.sendHttpRequest(httpPost);
    }

    public String sendHttpPostWithHeader(String httpUrl, String params, Header[] headers) {
        HttpPost httpPost = new HttpPost(httpUrl);
        try {
            httpPost.setHeaders(headers);
            StringEntity stringEntity = new StringEntity(params, CHARSET_UTF8);
            stringEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity(stringEntity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return this.sendHttpRequest(httpPost);
    }

    public String sendHttpPost(String httpUrl, Map<String, String> maps) {
        HttpPost httpPost = new HttpPost(httpUrl);
        if (null != maps && !maps.isEmpty()) {
            httpPost.setEntity(this.getNameValuePair(maps));
        }
        return this.sendHttpRequest(httpPost);
    }

    public String sendHttpPost(String httpUrl, Map<String, String> maps, List<File> fileLists) {
        HttpPost httpPost = new HttpPost(httpUrl);
        MultipartEntityBuilder meBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            meBuilder.addPart(entry.getKey(), new StringBody(entry.getValue(), ContentType.TEXT_PLAIN));
        }
        for (File file : fileLists) {
            FileBody fileBody = new FileBody(file);
            meBuilder.addPart("files", fileBody);
        }
        HttpEntity reqEntity = meBuilder.build();
        httpPost.setEntity(reqEntity);
        return this.sendHttpRequest(httpPost);
    }

    public String sendHttpPost(String httpUrl, Map<String, String> maps, String body) {
        String paramStr = MapUtil.mapJoinNotEncode(maps);
        if (StringUtils.isNotBlank(paramStr)) {
            paramStr = '?' + paramStr;
        }
        String urlStr = httpUrl + paramStr;
        HttpPost httpPost = new HttpPost(urlStr);
        try {
            StringEntity entity = new StringEntity(body, CHARSET_UTF8);
            httpPost.setEntity(entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return this.sendHttpRequest(httpPost);
    }

    public String sendHttpGet(String httpUrl) {
        HttpGet httpGet = new HttpGet(httpUrl);
        return this.sendHttpRequest(httpGet);
    }

    public String sendHttpDelete(String httpUrl, Map<String, String> maps) {
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(httpUrl);
        if (null != maps && !maps.isEmpty()) {
            httpDelete.setEntity(this.getNameValuePair(maps));
        }
        return this.sendHttpRequest(httpDelete);
    }

    private UrlEncodedFormEntity getNameValuePair(Map<String, String> maps) {
        try {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                nameValuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            return new UrlEncodedFormEntity(nameValuePairs, CHARSET_UTF8);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public String sentHttpPut(String httpUrl, Map<String, String> maps) {
        HttpPut httpPut = new HttpPut(httpUrl);
        httpPut.setHeader("Content-type", "application/json");
        if (maps != null && maps.size() > 0) {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                httpPut.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.sendHttpRequest(httpPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendHttpRequest(HttpRequestBase httpRequest) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        if (null != this.requestHost) {
            boolean status = this.setProxyToRequest(httpRequest);
            if (!status) {
                return null;
            }
        } else {
            httpRequest.setConfig(this.requestConfig);
        }
        try {
            httpClient = HttpClients.createDefault();
            response = httpClient.execute(httpRequest);
            LOG.info("Http\u8bf7\u6c42\u72b6\u6001\u7801\uff1a{}", (Object)response.getStatusLine().getStatusCode());
            String status = EntityUtils.toString(response.getEntity(), CHARSET_UTF8);
            return status;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private boolean setProxyToRequest(HttpRequestBase httpRequest) {
        if (ProxyType.FORWARD.getValue().equals(this.requestHost.getProxyType())) {
            RequestConfig customRequestConfig = this.getCustomRequestConfig(this.requestHost);
            if (null == customRequestConfig) {
                return false;
            }
            httpRequest.setConfig(customRequestConfig);
        } else {
            String host;
            String string = host = StringUtils.isBlank(this.requestHost.getIp()) ? this.requestHost.getHost() : this.requestHost.getIp();
            if (0 != this.requestHost.getPort()) {
                host = host + ":" + this.requestHost.getPort();
            }
            String url = httpRequest.getURI().toString();
            url = url.replace(this.defaultProxyHost, host);
            url = this.replaceScheme(url);
            try {
                httpRequest.setURI(new URI(url));
            }
            catch (URISyntaxException e) {
                LOG.error("\u751f\u6210\u4ee3\u7406url\u51fa\u9519\u4e86\uff0ccause={}", e);
                return false;
            }
            this.setHostHeader(httpRequest);
            httpRequest.setConfig(this.requestConfig);
        }
        return true;
    }

    private void setHostHeader(HttpRequestBase httpRequest) {
        boolean isHttps = StringUtils.isNotBlank(this.requestHost.getScheme()) && HTTPS_SCHEME.equals(this.requestHost.getScheme());
        int port = this.requestHost.getPort();
        if (StringUtils.isNotBlank(this.requestHost.getHost())) {
            if (0 != port && 443 != port && isHttps) {
                httpRequest.setHeader("Host", this.requestHost.getHost());
            } else if (0 != port && 80 != port && !isHttps) {
                httpRequest.setHeader("Host", this.requestHost.getHost() + ":" + port);
            } else {
                httpRequest.setHeader("Host", this.requestHost.getHost());
            }
        } else {
            httpRequest.setHeader("Host", this.defaultProxyHost);
        }
    }

    private String replaceScheme(String url) {
        boolean isHttps = url.startsWith(HTTPS_SCHEME);
        if (isHttps) {
            if (StringUtils.isBlank(this.requestHost.getScheme()) || !HTTPS_SCHEME.equals(this.requestHost.getScheme())) {
                url = url.replace(HTTPS_SCHEME, "http");
            }
        } else if (StringUtils.isNotBlank(this.requestHost.getScheme()) && HTTPS_SCHEME.equals(this.requestHost.getScheme())) {
            url = url.replace("http", HTTPS_SCHEME);
        }
        return url;
    }

    private RequestConfig getCustomRequestConfig(RequestHost proxy) {
        String scheme = "http";
        if (StringUtils.isNotBlank(proxy.getScheme()) && HTTPS_SCHEME.equals(proxy.getScheme())) {
            scheme = proxy.getScheme();
        }
        HttpHost host = new HttpHost(proxy.getHost(), proxy.getPort(), scheme);
        return RequestConfig.custom().setProxy(host).setSocketTimeout(15000).setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();
    }
}

