/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service;

import java.util.Map;
import net.polyv.live.bean.client.RequestHost;
import net.polyv.live.bean.client.WrappedResponse;
import net.polyv.live.bean.client.WrappedResponseV1;
import net.polyv.live.bean.request.PLBaseBody;
import net.polyv.live.bean.result.PLBaseResult;
import net.polyv.live.bean.result.PLCommonResult;
import net.polyv.live.bean.result.channel.PLChannelCommonResult;
import net.polyv.live.constant.PolyvLiveConstants;
import net.polyv.live.enumeration.ProxyType;
import net.polyv.live.util.HttpClientUtil;
import net.polyv.live.util.JsonUtil;
import net.polyv.live.util.MapUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PLAbstractService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String GET_METHOD = "GET";
    protected static final String POST_METHOD = "POST";
    protected static final String DELETE_METHOD = "DELETE";
    protected static final String PUT_METHOD = "PUT";
    protected static final String CONTENTS_TAG = "contents";
    private RequestHost proxy = null;

    protected WrappedResponse request(String url, Map<String, String> params, String method) {
        return this.request(url, params, method, null);
    }

    protected <T extends PLBaseBody> WrappedResponse request(String url, Map<String, String> params, String method, T t) {
        String body = null == t ? null : t.toJson();
        WrappedResponse response = this.requestBase(url, params, method, WrappedResponse.class, body);
        if (null == response) {
            response = new WrappedResponse(400, "error", "Bad Request", null);
        }
        return response;
    }

    protected WrappedResponseV1 requestV1(String url, Map<String, String> params, String method) {
        WrappedResponseV1 response = this.requestBase(url, params, method, WrappedResponseV1.class, null);
        if (null == response) {
            response = new WrappedResponseV1(String.valueOf(400), "failure", "Bad Request", null);
        }
        return response;
    }

    private <T> T requestBase(String url, Map<String, String> params, String method, Class<T> clazz, String body) {
        String content;
        HttpClientUtil client = this.initHttpClient();
        if (StringUtils.isNotBlank(body) && POST_METHOD.equals(method)) {
            content = client.sendHttpPost(url, params, body);
        } else if (POST_METHOD.equals(method)) {
            content = client.sendHttpPost(url, params);
        } else if (DELETE_METHOD.equals(method)) {
            content = client.sendHttpDelete(url, params);
        } else if (PUT_METHOD.equals(method)) {
            content = client.sentHttpPut(url, params);
        } else {
            String paramStr = MapUtil.mapJoinNotEncode(params);
            if (StringUtils.isNotBlank(paramStr)) {
                paramStr = '?' + paramStr;
            }
            content = client.sendHttpGet(url + paramStr);
        }
        T t = null;
        if (StringUtils.isNotBlank(content)) {
            try {
                t = JsonUtil.parseObject(content, clazz);
            }
            catch (Exception e) {
                this.logger.error("response json cast to object occur an error\uff0ccontent = {}", (Object)content);
            }
        }
        return t;
    }

    protected HttpClientUtil initHttpClient() {
        if (null != this.proxy) {
            return HttpClientUtil.getInstance(this.proxy, "api.polyv.net");
        }
        return HttpClientUtil.getInstance();
    }

    protected <T extends PLBaseResult> T getResult(WrappedResponse response, T result) {
        result.setCode(response.getCode());
        result.setMessage(response.getMessage());
        result.setStatus(response.getStatus());
        return result;
    }

    protected <T extends PLBaseResult> T getResult(WrappedResponseV1 response, T result) {
        if (response.isRequestOk()) {
            result.setCode(200);
        } else {
            result.setCode(400);
        }
        result.setMessage(response.getMsg());
        result.setStatus(response.getStatus());
        return result;
    }

    @Deprecated
    protected PLChannelCommonResult getPLChannelCommonResult(String url, String urlParam, Map<String, String> params, String method) {
        if (StringUtils.isNotBlank(urlParam)) {
            url = PolyvLiveConstants.getRealUrl(url, urlParam);
        }
        WrappedResponse response = this.request(url, params, method);
        PLChannelCommonResult result = new PLChannelCommonResult();
        if (response.isRequestOk()) {
            result.setData(response.getData());
        }
        return this.getResult(response, result);
    }

    @Deprecated
    protected PLChannelCommonResult getPLChannelCommonResultV1(String url, String urlParam, Map<String, String> params, String method) {
        if (StringUtils.isNotBlank(urlParam)) {
            url = PolyvLiveConstants.getRealUrl(url, urlParam);
        }
        WrappedResponseV1 response = this.requestV1(url, params, method);
        PLChannelCommonResult result = new PLChannelCommonResult();
        if (response.isRequestOk()) {
            result.setData(response.getResult());
        }
        return this.getResult(response, result);
    }

    protected PLCommonResult getPLCommonResult(String url, String urlParam, Map<String, String> params, String method) {
        return this.getPLCommonResult(url, urlParam, params, method, null);
    }

    protected <T extends PLBaseBody> PLCommonResult getPLCommonResult(String url, String urlParam, Map<String, String> params, String method, T t) {
        if (StringUtils.isNotBlank(urlParam)) {
            url = PolyvLiveConstants.getRealUrl(url, urlParam);
        }
        WrappedResponse response = this.request(url, params, method, t);
        PLCommonResult result = new PLCommonResult();
        if (response.isRequestOk()) {
            result.setData(response.getData());
        }
        return this.getResult(response, result);
    }

    protected PLCommonResult getPLCommonResultV1(String url, String urlParam, Map<String, String> params, String method) {
        if (StringUtils.isNotBlank(urlParam)) {
            url = PolyvLiveConstants.getRealUrl(url, urlParam);
        }
        WrappedResponseV1 response = this.requestV1(url, params, method);
        PLCommonResult result = new PLCommonResult();
        if (response.isRequestOk()) {
            result.setData(response.getResult());
        }
        return this.getResult(response, result);
    }

    public void initForwardProxy(String host, int port, String scheme) {
        this.proxy = new RequestHost(host, port, scheme, ProxyType.FORWARD.getValue());
    }

    public void initReverseProxy(String host, int port, String ipAddress, String scheme) {
        this.proxy = new RequestHost(host, port, ipAddress, scheme, ProxyType.REVERSE.getValue());
    }

    public void initReverseProxy(String host, int port, String scheme) {
        this.proxy = new RequestHost(host, port, scheme, ProxyType.REVERSE.getValue());
    }

    public void destroyProxy() {
        this.proxy = null;
    }
}

