/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import net.polyv.live.bean.client.WrappedResponse;
import net.polyv.live.bean.client.WrappedResponseV1;
import net.polyv.live.bean.request.channel.PLChannelCreateRequest;
import net.polyv.live.bean.request.channel.PLChannelDailySummaryRequest;
import net.polyv.live.bean.request.channel.PLChannelDeleteRequest;
import net.polyv.live.bean.request.channel.PLChannelGetRequest;
import net.polyv.live.bean.request.channel.PLChannelLikesGetRequest;
import net.polyv.live.bean.request.channel.PLChannelLikesUpdateRequest;
import net.polyv.live.bean.request.channel.PLChannelManagementListRequest;
import net.polyv.live.bean.request.channel.PLChannelMaxViewerSetRequest;
import net.polyv.live.bean.request.channel.PLChannelNameSetRequest;
import net.polyv.live.bean.request.channel.PLChannelPasswordSetRequest;
import net.polyv.live.bean.request.channel.PLChannelPlaybackDeleteRequest;
import net.polyv.live.bean.request.channel.PLChannelPlaybackListGetRequest;
import net.polyv.live.bean.request.channel.PLChannelPlaybackSetDefaultRequest;
import net.polyv.live.bean.request.channel.PLChannelPlaybackSetRequest;
import net.polyv.live.bean.request.channel.PLChannelPublisherSetRequest;
import net.polyv.live.bean.request.channel.PLChannelRecordFileConvertRequest;
import net.polyv.live.bean.request.channel.PLChannelRecordFileMergeRequest;
import net.polyv.live.bean.request.channel.PLChannelRecordFilesGetRequest;
import net.polyv.live.bean.request.channel.PLChannelSummaryListGetRequest;
import net.polyv.live.bean.request.channel.PLChannelViewLogsGetRequest;
import net.polyv.live.bean.request.channel.PLChannelViewersGetRequest;
import net.polyv.live.bean.result.channel.ChannelDailySummary;
import net.polyv.live.bean.result.channel.ChannelLikes;
import net.polyv.live.bean.result.channel.ChannelSummary;
import net.polyv.live.bean.result.channel.ChannelViewLog;
import net.polyv.live.bean.result.channel.ChannelViewer;
import net.polyv.live.bean.result.channel.PLChannelCommonResult;
import net.polyv.live.bean.result.channel.PLChannelCreateResult;
import net.polyv.live.bean.result.channel.PLChannelDailySummaryResult;
import net.polyv.live.bean.result.channel.PLChannelGetResult;
import net.polyv.live.bean.result.channel.PLChannelLikesGetResult;
import net.polyv.live.bean.result.channel.PLChannelManagementListResult;
import net.polyv.live.bean.result.channel.PLChannelPlaybackListGetResult;
import net.polyv.live.bean.result.channel.PLChannelRecordFilesGetResult;
import net.polyv.live.bean.result.channel.PLChannelSummaryListGetResult;
import net.polyv.live.bean.result.channel.PLChannelViewLogsGetResult;
import net.polyv.live.bean.result.channel.PLChannelViewersGetResult;
import net.polyv.live.bean.result.channel.Playback;
import net.polyv.live.bean.result.channel.RecordFile;
import net.polyv.live.bean.result.channel.SimpleChannel;
import net.polyv.live.constant.PolyvLiveConstants;
import net.polyv.live.service.PLAbstractService;
import net.polyv.live.service.PLChannelService;

public class PLChannelServiceImpl
extends PLAbstractService
implements PLChannelService {
    @Override
    public PLChannelCreateResult createChannel(PLChannelCreateRequest plChannelCreateRequest) {
        WrappedResponse response = this.request("https://api.polyv.net/live/v2/channels/", plChannelCreateRequest.getParams(), "POST");
        PLChannelCreateResult result = new PLChannelCreateResult();
        if (response.isRequestOk()) {
            result = (PLChannelCreateResult)JSONArray.toJavaObject((JSON)((JSONObject)response.getData()), PLChannelCreateResult.class);
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelCommonResult setChannelMaxViewer(int channelId, PLChannelMaxViewerSetRequest plChannelMaxViewerSetRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channelRestrict/%s/set-max-viewer", String.valueOf(channelId), plChannelMaxViewerSetRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult setChannelName(int channelId, PLChannelNameSetRequest plChannelNameSetRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channels/%s/update", String.valueOf(channelId), plChannelNameSetRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult setChannelPublisher(String userId, PLChannelPublisherSetRequest plChannelPublisherSetRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channelSetting/%s/setPublisher", userId, plChannelPublisherSetRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult deleteChannel(int channelId, PLChannelDeleteRequest plChannelDeleteRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channels/%s/delete", String.valueOf(channelId), plChannelDeleteRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult setChannelPassword(String userId, PLChannelPasswordSetRequest plChannelPasswordSetRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channels/%s/passwdSetting", userId, plChannelPasswordSetRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult setChannelPlayback(String userId, PLChannelPlaybackSetRequest plChannelPlaybackSetRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channelSetting/%s/setPlayBackEnabled", userId, plChannelPlaybackSetRequest.getParams(), "POST");
    }

    @Override
    public PLChannelSummaryListGetResult getChannelSummaryList(String userId, PLChannelSummaryListGetRequest plChannelSummaryListGetRequest) {
        String url = PolyvLiveConstants.getRealUrl("https://api.polyv.net/live/v2/statistics/%s/channel_summary", userId);
        WrappedResponse response = this.request(url, plChannelSummaryListGetRequest.getParams(), "GET");
        PLChannelSummaryListGetResult result = new PLChannelSummaryListGetResult();
        if (response.isRequestOk()) {
            String json = JSON.toJSONString((Object)response.getData());
            result.setChannelSummarys(JSONObject.parseArray((String)json, ChannelSummary.class));
        }
        return this.getResult(response, result);
    }

    @Override
    public String getChannelLiveStatus(String stream) {
        return this.initHttpClient().sendHttpGet("http://api.polyv.net/live_status/query?stream=" + stream);
    }

    @Override
    public PLChannelViewersGetResult getChannelViewers(PLChannelViewersGetRequest plChannelViewersGetRequest) {
        WrappedResponse response = this.request("https://api.polyv.net/live/v2/statistics/get-realtime-viewers", plChannelViewersGetRequest.getParams(), "GET");
        PLChannelViewersGetResult result = new PLChannelViewersGetResult();
        if (response.isRequestOk()) {
            String json = JSON.toJSONString((Object)response.getData());
            result.setChannelViewers(JSONObject.parseArray((String)json, ChannelViewer.class));
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelViewLogsGetResult getChannelViewLogs(int channelId, PLChannelViewLogsGetRequest plChannelViewLogsGetRequest) {
        String url = PolyvLiveConstants.getRealUrl("https://api.polyv.net/live/v2/statistics/%s/viewlog", String.valueOf(channelId));
        WrappedResponse response = this.request(url, plChannelViewLogsGetRequest.getParams(), "GET");
        PLChannelViewLogsGetResult result = new PLChannelViewLogsGetResult();
        if (response.isRequestOk()) {
            JSONObject jsonObject = (JSONObject)response.getData();
            result = (PLChannelViewLogsGetResult)JSONArray.toJavaObject((JSON)jsonObject, PLChannelViewLogsGetResult.class);
            if (null != jsonObject) {
                String json = JSON.toJSONString((Object)jsonObject.get((Object)"contents"));
                result.setChannelViewLogs(JSONObject.parseArray((String)json, ChannelViewLog.class));
            }
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelGetResult getChannel(int channelId, PLChannelGetRequest plChannelGetRequest) {
        String url = PolyvLiveConstants.getRealUrl("https://api.polyv.net/live/v2/channels/%s/get", String.valueOf(channelId));
        WrappedResponse response = this.request(url, plChannelGetRequest.getParams(), "GET");
        PLChannelGetResult result = new PLChannelGetResult();
        if (response.isRequestOk()) {
            result = (PLChannelGetResult)JSONArray.toJavaObject((JSON)((JSONObject)response.getData()), PLChannelGetResult.class);
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelRecordFilesGetResult getChannelRecordFiles(int channelId, PLChannelRecordFilesGetRequest plChannelRecordFilesGetRequest) {
        String url = PolyvLiveConstants.getRealUrl("https://api.polyv.net/live/v2/channels/%s/recordFiles", String.valueOf(channelId));
        WrappedResponse response = this.request(url, plChannelRecordFilesGetRequest.getParams(), "GET");
        PLChannelRecordFilesGetResult result = new PLChannelRecordFilesGetResult();
        if (response.isRequestOk()) {
            String json = JSON.toJSONString((Object)response.getData());
            result.setRecordFiles(JSONObject.parseArray((String)json, RecordFile.class));
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelCommonResult convertChannelRecords(int channelId, PLChannelRecordFileConvertRequest plChannelRecordFileConvertRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channel/recordFile/%s/convert", String.valueOf(channelId), plChannelRecordFileConvertRequest.getParams(), "POST");
    }

    @Override
    public PLChannelPlaybackListGetResult getChannelPlaybacks(int channelId, PLChannelPlaybackListGetRequest plChannelPlaybackListGetRequest) {
        String url = PolyvLiveConstants.getRealUrl("https://api.polyv.net/live/v2/channel/recordFile/%s/playback/list", String.valueOf(channelId));
        WrappedResponse response = this.request(url, plChannelPlaybackListGetRequest.getParams(), "GET");
        PLChannelPlaybackListGetResult result = new PLChannelPlaybackListGetResult();
        if (response.isRequestOk()) {
            JSONObject jsonObject = (JSONObject)response.getData();
            result = (PLChannelPlaybackListGetResult)JSONArray.toJavaObject((JSON)jsonObject, PLChannelPlaybackListGetResult.class);
            if (null != jsonObject) {
                String json = JSON.toJSONString((Object)jsonObject.get((Object)"contents"));
                result.setPlaybacks(JSONObject.parseArray((String)json, Playback.class));
            }
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelCommonResult setPlaybackListDefault(int channelId, PLChannelPlaybackSetDefaultRequest plChannelPlaybackSetDefaultRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channel/recordFile/%s/playback/set-Default", String.valueOf(channelId), plChannelPlaybackSetDefaultRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult deletePlaybackVideo(int channelId, PLChannelPlaybackDeleteRequest plChannelPlaybackDeleteRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channel/recordFile/%s/playback/delete", String.valueOf(channelId), plChannelPlaybackDeleteRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult mergeChannelRecords(int channelId, PLChannelRecordFileMergeRequest plChannelRecordFileMergeRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channel/recordFile/%s/merge", String.valueOf(channelId), plChannelRecordFileMergeRequest.getParams(), "POST");
    }

    @Override
    public PLChannelCommonResult updateLikes(int channelId, PLChannelLikesUpdateRequest plChannelLikesUpdateRequest) {
        return this.getPLChannelCommonResult("https://api.polyv.net/live/v2/channels/%s/update-likes", String.valueOf(channelId), plChannelLikesUpdateRequest.getParams(), "POST");
    }

    @Override
    public PLChannelLikesGetResult getLikes(PLChannelLikesGetRequest plChannelLikesGetRequest) {
        WrappedResponse response = this.request("https://api.polyv.net/live/v2/channels/live-likes", plChannelLikesGetRequest.getParams(), "GET");
        PLChannelLikesGetResult result = new PLChannelLikesGetResult();
        if (response.isRequestOk()) {
            String json = JSON.toJSONString((Object)response.getData());
            result.setChannelLikes(JSONObject.parseArray((String)json, ChannelLikes.class));
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelDailySummaryResult getChannelDailySummary(int channelId, PLChannelDailySummaryRequest plChannelDailySummaryRequest) {
        String url = PolyvLiveConstants.getRealUrl("https://api.polyv.net/live/v2/statistics/%s/summary", String.valueOf(channelId));
        WrappedResponseV1 response = this.requestV1(url, plChannelDailySummaryRequest.getParams(), "GET");
        PLChannelDailySummaryResult result = new PLChannelDailySummaryResult();
        if (response.isRequestOk()) {
            String json = JSON.toJSONString((Object)response.getResult());
            result.setChannelDailySummary(JSONObject.parseArray((String)json, ChannelDailySummary.class));
        }
        return this.getResult(response, result);
    }

    @Override
    public PLChannelManagementListResult getSimpleChannelList(PLChannelManagementListRequest plChannelManagementListRequest) {
        WrappedResponse response = this.request("https://api.polyv.net/live/v3/channel/management/list", plChannelManagementListRequest.getParams(), "GET");
        PLChannelManagementListResult result = new PLChannelManagementListResult();
        if (response.isRequestOk()) {
            JSONObject jsonObject = (JSONObject)response.getData();
            result = (PLChannelManagementListResult)JSONArray.toJavaObject((JSON)jsonObject, PLChannelManagementListResult.class);
            if (null != jsonObject) {
                String json = JSON.toJSONString((Object)jsonObject.get((Object)"contents"));
                result.setSimpleChannels(JSONObject.parseArray((String)json, SimpleChannel.class));
            }
        }
        return this.getResult(response, result);
    }
}

