/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Set;
import net.plsar.model.NetworkRequest;
import net.plsar.model.NetworkResponse;
import net.plsar.model.SecurityAttribute;
import net.plsar.security.SecurityAccess;
import net.plsar.security.SecurityAttributes;

public class SecurityManager {
    SecurityAccess securityAccess;
    SecurityAttributes securityAttributes;

    public SecurityManager(SecurityAccess securityAccess) {
        this.securityAccess = securityAccess;
    }

    public SecurityManager(SecurityAccess securityAccess, SecurityAttributes securityAttributes) {
        this.securityAccess = securityAccess;
        this.securityAttributes = securityAttributes;
    }

    public SecurityAttributes getSecurityAttributes() {
        return this.securityAttributes;
    }

    public void setSecurityAttributes(SecurityAttributes securityAttributes) {
        this.securityAttributes = securityAttributes;
    }

    public SecurityAccess getSecurityAccess() {
        return this.securityAccess;
    }

    public void setSecurityAccess(SecurityAccess securityAccess) {
        this.securityAccess = securityAccess;
    }

    public boolean hasRole(String role, NetworkRequest networkRequest) {
        Set<String> roles;
        String user = this.getUser(networkRequest);
        return user != null && (roles = this.securityAccess.getRoles(user)).contains(role);
    }

    public boolean hasPermission(String permission, NetworkRequest networkRequest) {
        Set<String> permissions;
        String user = networkRequest.getUserCredential();
        return user != null && (permissions = this.securityAccess.getPermissions(user)).contains(permission);
    }

    public String getUser(NetworkRequest networkRequest) {
        return networkRequest.getUserCredential();
    }

    public Boolean signin(String username, String passwordUntouched, NetworkRequest networkRequest, NetworkResponse networkResponse) {
        String hashed = this.hash(passwordUntouched);
        String password = this.securityAccess.getPassword(username);
        try {
            if (!this.isAuthenticated(networkRequest) && password.equals(hashed)) {
                String securityAttributePrincipal = Base64.getEncoder().encodeToString(username.getBytes());
                networkRequest.setSecurityAttributeInfo(this.securityAttributes.getSecuredAttribute());
                String securityAttributeValue = this.securityAttributes.getSecuredAttribute() + "." + securityAttributePrincipal + "; path=/;";
                SecurityAttribute securityAttribute = new SecurityAttribute(this.securityAttributes.getSecurityElement(), securityAttributeValue);
                networkResponse.getSecurityAttributes().put("plsar.security", securityAttribute);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean signout(NetworkRequest networkRequest, NetworkResponse networkResponse) {
        networkRequest.setSecurityAttributeInfo("");
        String securityAttributeValue = ";Expires/MaxAge=-1;Expires=-1;MaxAge=-1;";
        SecurityAttribute securityAttribute = new SecurityAttribute(this.securityAttributes.getSecurityElement(), securityAttributeValue);
        networkResponse.getSecurityAttributes().remove("plsar.security");
        networkResponse.getSecurityAttributes().put("plsar.security", securityAttribute);
        return true;
    }

    public boolean isAuthenticated(NetworkRequest networkRequest) {
        return !networkRequest.getUserCredential().equals("");
    }

    public String hash(String password) {
        StringBuffer passwordHashed = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            for (int i = 0; i < byteData.length; ++i) {
                passwordHashed.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return passwordHashed.toString();
    }

    public static String dirty(String password) {
        StringBuffer passwordHashed = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            for (int i = 0; i < byteData.length; ++i) {
                passwordHashed.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return passwordHashed.toString();
    }
}

