/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.resources;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import net.plsar.annotations.ServerStartup;
import net.plsar.resources.AnnotationComponent;
import net.plsar.resources.ComponentsHolder;

public class StartupAnnotationInspector {
    Logger Log = Logger.getLogger(StartupAnnotationInspector.class.getName());
    ClassLoader klassLoader = Thread.currentThread().getContextClassLoader();
    ComponentsHolder componentsHolder;

    public StartupAnnotationInspector(ComponentsHolder componentsHolder) {
        this.componentsHolder = componentsHolder;
    }

    public void inspect() {
        Path filePath = Paths.get("build", new String[0]);
        String completeFilePath = filePath.toAbsolutePath().toString();
        this.inspectFilePath(completeFilePath);
    }

    public void inspectFilePath(String filePath) {
        File[] files;
        File pathFile = new File(filePath);
        for (File file : files = pathFile.listFiles()) {
            if (file.isDirectory()) {
                this.inspectFilePath(file.getPath());
                continue;
            }
            try {
                if (!file.getPath().endsWith(".class")) continue;
                String separator = System.getProperty("file.separator");
                String regex = "classes\\" + separator;
                String[] klassPathParts = file.getPath().split(regex);
                String klassPathSlashesRemoved = klassPathParts[1].replace("\\", ".");
                String klassPathPeriod = klassPathSlashesRemoved.replace("/", ".");
                String klassPathBefore = klassPathPeriod.replace(".class", "");
                String klassPath = klassPathBefore.replaceFirst("java.", "").replaceFirst("main.", "");
                Class<?> klass = this.klassLoader.loadClass(klassPath);
                if (klass.isAnnotation() || klass.isInterface() || !klass.isAnnotationPresent(ServerStartup.class)) continue;
                AnnotationComponent annotationComponent = new AnnotationComponent();
                annotationComponent.setKlass(klass);
                this.componentsHolder.setServerStartup(annotationComponent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ComponentsHolder getComponentsHolder() {
        return this.componentsHolder;
    }
}

