/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.model;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.plsar.RouteAttributes;
import net.plsar.model.RequestComponent;
import net.plsar.security.SecurityAttributes;

public class NetworkRequest {
    boolean redirect;
    String redirectLocation;
    String requestPath;
    String requestAction;
    String requestBody;
    Map<String, String> headers = new HashMap<String, String>();
    Map<String, RequestComponent> requestComponents = new HashMap<String, RequestComponent>();
    RouteAttributes routeAttributes;
    String securityAttributeInfo;
    SecurityAttributes securityAttributes;
    String userCredential;

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRequestAction() {
        return this.requestAction;
    }

    public void setRequestAction(String requestAction) {
        this.requestAction = requestAction;
    }

    public void addHeader(String fieldKey, String headerValue) {
        this.headers.put(fieldKey, headerValue);
    }

    public void removeHeader(String fieldKey) {
        this.headers.remove(fieldKey);
    }

    public String getHeader(String fieldKey) {
        if (this.headers.containsKey(fieldKey)) {
            return this.headers.get(fieldKey);
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void put(String elementName, RequestComponent requestComponent) {
        this.requestComponents.put(elementName, requestComponent);
    }

    public String getSecurityAttributeInfo() {
        if (this.securityAttributeInfo == null) {
            return "";
        }
        return this.securityAttributeInfo;
    }

    public void setSecurityAttributeInfo(String securityAttributeInfo) {
        this.securityAttributeInfo = securityAttributeInfo;
    }

    public void setRequestComponents(Map<String, RequestComponent> requestComponents) {
        this.requestComponents = requestComponents;
    }

    public void setRequestComponent(String key, RequestComponent requestComponent) {
        this.requestComponents.put(key, requestComponent);
    }

    public String getValue(String key) {
        if (this.requestComponents.containsKey(key)) {
            return this.requestComponents.get(key).getValue();
        }
        return null;
    }

    public RequestComponent getRequestComponent(String key) {
        if (this.requestComponents.containsKey(key)) {
            return this.requestComponents.get(key);
        }
        return null;
    }

    public List<RequestComponent> getRequestComponents() {
        ArrayList<RequestComponent> components = new ArrayList<RequestComponent>();
        for (Map.Entry<String, RequestComponent> requestComponentEntry : this.requestComponents.entrySet()) {
            components.add(requestComponentEntry.getValue());
        }
        return components;
    }

    public RouteAttributes getRouteAttributes() {
        return this.routeAttributes;
    }

    public void setRouteAttributes(RouteAttributes routeAttributes) {
        this.routeAttributes = routeAttributes;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public SecurityAttributes getSecurityAttributes() {
        return this.securityAttributes;
    }

    public void setSecurityAttributes(SecurityAttributes securityAttributes) {
        this.securityAttributes = securityAttributes;
    }

    public String getUserCredential() {
        if (this.userCredential == null) {
            return "";
        }
        return this.userCredential;
    }

    public void setUserCredential(String userCredential) {
        this.userCredential = userCredential;
    }

    public void removeRedirect() {
        this.redirect = false;
        this.redirectLocation = null;
    }

    public void setValues(String parameters) {
        String[] keyValues;
        for (String keyValue : keyValues = parameters.split("&")) {
            String[] parts = keyValue.split("=");
            if (parts.length <= 1) continue;
            String key = parts[0];
            String value = parts[1];
            RequestComponent requestComponent = new RequestComponent();
            requestComponent.setName(key);
            requestComponent.setValue(value);
            this.requestComponents.put(key, requestComponent);
        }
    }

    public <T> T get(Class<?> klass) {
        Object classInstance = null;
        try {
            Field[] classInstanceFields;
            classInstance = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field classInstanceField : classInstanceFields = klass.getDeclaredFields()) {
                String fieldName = classInstanceField.getName();
                String fieldValue = this.getValue(fieldName);
                if (fieldValue == null || fieldValue.equals("")) continue;
                classInstanceField.setAccessible(true);
                Class<?> fieldType = classInstanceField.getType();
                if (fieldType.getTypeName().equals("int") || fieldType.getTypeName().equals("java.lang.Integer")) {
                    classInstanceField.set(classInstance, Integer.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("double") || fieldType.getTypeName().equals("java.lang.Double")) {
                    classInstanceField.set(classInstance, Double.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("float") || fieldType.getTypeName().equals("java.lang.Float")) {
                    classInstanceField.set(classInstance, Float.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("long") || fieldType.getTypeName().equals("java.lang.Long")) {
                    classInstanceField.set(classInstance, Long.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("boolean") || fieldType.getTypeName().equals("java.lang.Boolean")) {
                    classInstanceField.set(classInstance, Boolean.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("java.math.BigDecimal")) {
                    classInstanceField.set(classInstance, new BigDecimal(fieldValue));
                }
                if (!fieldType.getTypeName().equals("java.lang.String")) continue;
                classInstanceField.set(classInstance, fieldValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (T)klass.cast(classInstance);
    }
}

