/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.plsar.Dao;
import net.plsar.ExperienceManager;
import net.plsar.MethodAttribute;
import net.plsar.PersistenceConfig;
import net.plsar.PlsarException;
import net.plsar.RouteAttributes;
import net.plsar.RouteEndpoint;
import net.plsar.RouteEndpointHolder;
import net.plsar.RouteResult;
import net.plsar.annotations.Before;
import net.plsar.annotations.Bind;
import net.plsar.annotations.Design;
import net.plsar.annotations.JsonOutput;
import net.plsar.annotations.Meta;
import net.plsar.annotations.Text;
import net.plsar.implement.RouteEndpointBefore;
import net.plsar.model.FlashMessage;
import net.plsar.model.MethodComponents;
import net.plsar.model.NetworkRequest;
import net.plsar.model.NetworkResponse;
import net.plsar.model.PrincipalAttributes;
import net.plsar.model.PrincipalResult;
import net.plsar.model.RedirectInfo;
import net.plsar.model.RouteAttribute;
import net.plsar.model.ViewCache;
import net.plsar.resources.ComponentsHolder;
import net.plsar.resources.MimeResolver;
import net.plsar.resources.ServerResources;
import net.plsar.security.SecurityAttributes;
import net.plsar.security.SecurityManager;

public class RouteEndpointNegotiator {
    RouteAttributes routeAttributes;
    ComponentsHolder componentsHolder;
    SecurityAttributes securityAttributes;

    public RouteResult performNetworkRequest(String RENDERER, String resourcesDirectory, ViewCache viewCache, FlashMessage flashMessage, NetworkRequest networkRequest, NetworkResponse networkResponse, SecurityAttributes securityAttributes, SecurityManager securityManager, List<Class<?>> viewRenderers, ConcurrentMap<String, byte[]> viewBytesMap) {
        Object completePageRendered = "";
        Object errorMessage = "";
        try {
            Object routeResponseObject;
            String methodResponse;
            viewCache.set("message", flashMessage.getMessage());
            ServerResources serverResources = new ServerResources();
            ExperienceManager experienceManager = new ExperienceManager();
            RouteAttributes routeAttributes = networkRequest.getRouteAttributes();
            RouteEndpointHolder routeEndpointHolder = routeAttributes.getRouteEndpointHolder();
            String routeEndpointPath = networkRequest.getRequestPath();
            String routeEndpointAction = networkRequest.getRequestAction().toLowerCase();
            if (routeEndpointPath.startsWith("/" + resourcesDirectory + "/")) {
                MimeResolver mimeGetter = new MimeResolver(routeEndpointPath);
                if (RENDERER.equals("cache")) {
                    ByteArrayOutputStream outputStream = serverResources.getViewFileCopy(routeEndpointPath, viewBytesMap);
                    if (outputStream == null) {
                        return new RouteResult("404".getBytes(), "404", "text/html");
                    }
                    return new RouteResult(outputStream.toByteArray(), "200 OK", mimeGetter.resolve());
                }
                String assetsPath = Paths.get("src", "main", "webapp").toString();
                String filePath = assetsPath.concat(routeEndpointPath);
                File staticResourcefile = new File(filePath);
                FileInputStream fileInputStream = new FileInputStream(staticResourcefile);
                if (fileInputStream != null && routeEndpointAction.equals("get")) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[(int)staticResourcefile.length()];
                    try {
                        int bytesRead;
                        while ((bytesRead = ((InputStream)fileInputStream).read(bytes, 0, bytes.length)) != -1) {
                            outputStream.write(bytes, 0, bytesRead);
                        }
                        ((InputStream)fileInputStream).close();
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    return new RouteResult(outputStream.toByteArray(), "200 OK", mimeGetter.resolve());
                }
            }
            RouteEndpoint routeEndpoint = null;
            if ((routeEndpointPath = routeEndpointPath.toLowerCase().trim()).equals("")) {
                routeEndpointPath = "/";
                String routeKey = routeEndpointAction.toLowerCase() + routeEndpointPath.toLowerCase();
                routeEndpoint = routeEndpointHolder.getRouteEndpoints().get(routeKey);
            }
            if (routeEndpoint == null) {
                if (routeEndpointPath.length() > 1 && routeEndpointPath.endsWith("/")) {
                    int endIndex = routeEndpointPath.indexOf("/", routeEndpointPath.length() - 1);
                    routeEndpointPath = routeEndpointPath.substring(0, endIndex);
                }
                if (routeEndpointHolder.getRouteEndpoints().containsKey(routeEndpointAction + ":" + routeEndpointPath)) {
                    routeEndpoint = routeEndpointHolder.getRouteEndpoints().get(routeEndpointAction + ":" + routeEndpointPath);
                }
            }
            if (routeEndpoint == null) {
                for (Map.Entry<String, RouteEndpoint> routeEndpointEntry : routeEndpointHolder.getRouteEndpoints().entrySet()) {
                    RouteEndpoint activeRouteEndpoint = routeEndpointEntry.getValue();
                    Matcher routeEndpointMatcher = Pattern.compile(activeRouteEndpoint.getRegexRoutePath()).matcher(routeEndpointPath);
                    if (!routeEndpointMatcher.matches() || !this.getRouteVariablesMatch(routeEndpointPath, activeRouteEndpoint) || !activeRouteEndpoint.isRegex().booleanValue()) continue;
                    routeEndpoint = activeRouteEndpoint;
                }
            }
            if (routeEndpoint == null) {
                return new RouteResult("404".getBytes(), "404", "text/html");
            }
            MethodComponents methodComponents = this.getMethodAttributesComponents(routeEndpointPath, viewCache, flashMessage, networkRequest, networkResponse, securityManager, routeEndpoint);
            Method routeEndpointInstanceMethod = routeEndpoint.getRouteMethod();
            String title = null;
            String keywords = null;
            String description = null;
            if (routeEndpointInstanceMethod.isAnnotationPresent(Meta.class)) {
                Meta metaAnnotation = routeEndpointInstanceMethod.getAnnotation(Meta.class);
                title = metaAnnotation.title();
                keywords = metaAnnotation.keywords();
                description = metaAnnotation.description();
            }
            routeEndpointInstanceMethod.setAccessible(true);
            Object routeInstance = routeEndpoint.getKlass().getConstructor(new Class[0]).newInstance(new Object[0]);
            HashMap routeEndpointInstances = new HashMap();
            PersistenceConfig persistenceConfig = routeAttributes.getPersistenceConfig();
            if (persistenceConfig != null) {
                Field[] routeFields;
                Dao routeDao = new Dao(persistenceConfig);
                for (Field routeField : routeFields = routeInstance.getClass().getDeclaredFields()) {
                    if (!routeField.isAnnotationPresent(Bind.class)) continue;
                    String fieldKey = routeField.getName().toLowerCase();
                    if (this.componentsHolder.getServices().containsKey(fieldKey)) {
                        Field[] repoFields;
                        Class clazz = (Class)this.componentsHolder.getServices().get(fieldKey);
                        Constructor serviceKlassConstructor = clazz.getConstructor(new Class[0]);
                        Object serviceInstance = serviceKlassConstructor.newInstance(new Object[0]);
                        for (Field repoField : repoFields = serviceInstance.getClass().getDeclaredFields()) {
                            if (!repoField.isAnnotationPresent(Bind.class)) continue;
                            String repoFieldKey = repoField.getName().toLowerCase();
                            if (!this.componentsHolder.getRepositories().containsKey(repoFieldKey)) continue;
                            Class repositoryKlass = (Class)this.componentsHolder.getRepositories().get(repoFieldKey);
                            Constructor repositoryKlassConstructor = repositoryKlass.getConstructor(Dao.class);
                            Object repositoryInstance = repositoryKlassConstructor.newInstance(routeDao);
                            repoField.setAccessible(true);
                            repoField.set(serviceInstance, repositoryInstance);
                            routeEndpointInstances.put(repoFieldKey, repositoryInstance);
                        }
                        routeField.setAccessible(true);
                        routeField.set(routeInstance, serviceInstance);
                    }
                    if (!this.componentsHolder.getRepositories().containsKey(fieldKey)) continue;
                    Class clazz = (Class)this.componentsHolder.getRepositories().get(fieldKey);
                    Constructor componentKlassConstructor = clazz.getConstructor(Dao.class);
                    Object componentInstance = componentKlassConstructor.newInstance(routeDao);
                    routeField.setAccessible(true);
                    routeField.set(routeInstance, componentInstance);
                    routeEndpointInstances.put(fieldKey, componentInstance);
                }
                try {
                    Method setPersistenceMethod = routeInstance.getClass().getMethod("setDao", Dao.class);
                    setPersistenceMethod.invoke(routeInstance, new Dao(persistenceConfig));
                }
                catch (NoSuchMethodException setPersistenceMethod) {
                    // empty catch block
                }
            }
            if (routeEndpointInstanceMethod.isAnnotationPresent(Before.class)) {
                Class<?>[] classArray;
                Before beforeAnnotation = routeEndpointInstanceMethod.getAnnotation(Before.class);
                String routePrincipalVariablesElement = beforeAnnotation.variables();
                PrincipalAttributes principalAttributes = new PrincipalAttributes();
                String[] routePrincipalVariables = routePrincipalVariablesElement.split(",");
                Integer routeVariableIndex = 0;
                List<Object> routeAttributesVariableList = methodComponents.getRouteMethodAttributeVariablesList();
                for (String routePrincipalVariableElement : routePrincipalVariables) {
                    Object routePrincipalVariableValue = routeAttributesVariableList.get(routeVariableIndex);
                    String routePrincipalVariable = routePrincipalVariableElement.replace("{", "").replace("}", "").trim();
                    principalAttributes.set(routePrincipalVariable, routePrincipalVariableValue);
                }
                for (Map.Entry entry : routeEndpointInstances.entrySet()) {
                    String routePrincipalInstanceKey = ((String)entry.getKey()).toLowerCase();
                    principalAttributes.set(routePrincipalInstanceKey, entry.getValue());
                }
                PrincipalResult principalResult = null;
                for (Class<?> routePrincipalKlass : classArray = beforeAnnotation.value()) {
                    RouteEndpointBefore routePrincipal = (RouteEndpointBefore)routePrincipalKlass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    principalResult = routePrincipal.before(flashMessage, viewCache, networkRequest, networkResponse, securityManager, principalAttributes);
                    if (principalResult.getRedirectUri().equals("")) continue;
                    RedirectInfo redirectInfo = new RedirectInfo();
                    redirectInfo.setMethodName(routeEndpointInstanceMethod.getName());
                    redirectInfo.setKlassName(routeInstance.getClass().getName());
                    if (principalResult.getRedirectUri() == null || principalResult.getRedirectUri().equals("")) {
                        throw new PlsarException("redirect uri is empty on " + routePrincipalKlass.getName());
                    }
                    String redirectRouteUri = serverResources.getRedirect(principalResult.getRedirectUri());
                    if (!principalResult.getMessage().equals("")) {
                        viewCache.set("message", principalResult.getMessage());
                    }
                    networkRequest.setRedirect(true);
                    networkRequest.setRedirectLocation(redirectRouteUri);
                    break;
                }
                if (!principalResult.getRedirectUri().equals("")) {
                    return new RouteResult("303".getBytes(), "303", "text/html");
                }
            }
            if ((methodResponse = String.valueOf(routeResponseObject = routeEndpointInstanceMethod.invoke(routeInstance, methodComponents.getRouteMethodAttributesList().toArray()))) == null) {
                return new RouteResult("404".getBytes(), "404", "text/html");
            }
            if (methodResponse.startsWith("redirect:")) {
                RedirectInfo redirectInfo = new RedirectInfo();
                redirectInfo.setMethodName(routeEndpointInstanceMethod.getName());
                redirectInfo.setKlassName(routeInstance.getClass().getName());
                String redirectRouteUri = serverResources.getRedirect(methodResponse);
                networkRequest.setRedirect(true);
                networkRequest.setRedirectLocation(redirectRouteUri);
                return new RouteResult("303".getBytes(), "303", "text/html");
            }
            if (routeEndpointInstanceMethod.isAnnotationPresent(JsonOutput.class)) {
                return new RouteResult(methodResponse.getBytes(), "200 OK", "application/json");
            }
            if (routeEndpointInstanceMethod.isAnnotationPresent(Text.class)) {
                return new RouteResult(methodResponse.getBytes(), "200 OK", "text/html");
            }
            if (RENDERER.equals("cache")) {
                ByteArrayOutputStream unebaos = serverResources.getViewFileCopy(methodResponse, viewBytesMap);
                if (unebaos == null) {
                    return new RouteResult("404".getBytes(), "404", "text/html");
                }
                completePageRendered = unebaos.toString(StandardCharsets.UTF_8.name());
            } else {
                int pageBytesLength;
                Path webPath = Paths.get("src", "main", "webapp");
                if (methodResponse.startsWith("/")) {
                    methodResponse = methodResponse.replaceFirst("/", "");
                }
                String htmlPath = webPath.toFile().getAbsolutePath().concat(File.separator + methodResponse);
                File viewFile = new File(htmlPath);
                ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                FileInputStream pageInput = new FileInputStream(viewFile);
                byte[] byArray = new byte[(int)viewFile.length()];
                while ((pageBytesLength = ((InputStream)pageInput).read(byArray)) != -1) {
                    unebaos.write(byArray, 0, pageBytesLength);
                }
                completePageRendered = unebaos.toString(StandardCharsets.UTF_8.name());
            }
            String designUri = null;
            if (routeEndpointInstanceMethod.isAnnotationPresent(Design.class)) {
                Design annotation = routeEndpointInstanceMethod.getAnnotation(Design.class);
                designUri = annotation.value();
            }
            if (designUri != null) {
                String designContent;
                if (RENDERER.equals("cache")) {
                    ByteArrayOutputStream baos = serverResources.getViewFileCopy(designUri, viewBytesMap);
                    designContent = baos.toString(StandardCharsets.UTF_8.name());
                } else {
                    int length;
                    Path designPath = Paths.get("src", "main", "webapp", designUri);
                    File designFile = new File(designPath.toString());
                    FileInputStream designInput = new FileInputStream(designFile);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[(int)designFile.length()];
                    while ((length = ((InputStream)designInput).read(bytes)) != -1) {
                        byteArrayOutputStream.write(bytes, 0, length);
                    }
                    designContent = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
                }
                if (designContent == null) {
                    return new RouteResult("design not found.".getBytes(), "200 OK", "text/html");
                }
                if (!designContent.contains("<plsar:content/>")) {
                    return new RouteResult("Your html template file is missing <plsar:content/>".getBytes(), "200 OK", "text/html");
                }
                String[] bits = designContent.split("<plsar:content/>");
                Object header = bits[0];
                String bottom = "";
                if (bits.length > 1) {
                    bottom = bits[1];
                }
                header = (String)header + (String)completePageRendered;
                completePageRendered = (String)header + bottom;
                if (title != null) {
                    completePageRendered = ((String)completePageRendered).replace("${title}", title);
                }
                if (keywords != null) {
                    completePageRendered = ((String)completePageRendered).replace("${keywords}", keywords);
                }
                if (description != null) {
                    completePageRendered = ((String)completePageRendered).replace("${description}", description);
                }
                completePageRendered = experienceManager.execute((String)completePageRendered, viewCache, networkRequest, securityAttributes, viewRenderers);
                return new RouteResult(((String)completePageRendered).getBytes(), "200 OK", "text/html");
            }
            completePageRendered = experienceManager.execute((String)completePageRendered, viewCache, networkRequest, securityAttributes, viewRenderers);
            return new RouteResult(((String)completePageRendered).getBytes(), "200 OK", "text/html");
        }
        catch (IllegalAccessException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (UnsupportedEncodingException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (IOException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (PlsarException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        String erroredPageRendered = (String)errorMessage + (String)completePageRendered;
        return new RouteResult(erroredPageRendered.getBytes(), "404", "text/html");
    }

    MethodComponents getMethodAttributesComponents(String routeEndpointPath, ViewCache viewCache, FlashMessage flashMessage, NetworkRequest networkRequest, NetworkResponse networkResponse, SecurityManager securityManager, RouteEndpoint routeEndpoint) {
        MethodComponents methodComponents = new MethodComponents();
        Parameter[] endpointMethodAttributes = routeEndpoint.getRouteMethod().getParameters();
        Integer index = 0;
        Integer pathVariableIndex = 0;
        String routeEndpointPathClean = routeEndpointPath.replaceFirst("/", "");
        String[] routePathUriAttributes = routeEndpointPathClean.split("/");
        for (Parameter endpointMethodAttribute : endpointMethodAttributes) {
            Object attributeValue;
            String methodAttributeKey = endpointMethodAttribute.getName().toLowerCase();
            String description = endpointMethodAttribute.getDeclaringExecutable().getName().toLowerCase();
            RouteAttribute routeAttribute = routeEndpoint.getRouteAttributes().get(methodAttributeKey);
            MethodAttribute methodAttribute = new MethodAttribute();
            methodAttribute.setDescription(description);
            pathVariableIndex = routeAttribute.getRoutePosition() != null ? routeAttribute.getRoutePosition() : 0;
            if (endpointMethodAttribute.getType().getTypeName().equals("net.plsar.security.SecurityManager")) {
                methodAttribute.setDescription("securitymanager");
                methodAttribute.setAttribute(securityManager);
                methodComponents.getRouteMethodAttributes().put("securitymanager", methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(securityManager);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("net.plsar.model.NetworkRequest")) {
                methodAttribute.setDescription("networkrequest");
                methodAttribute.setAttribute(networkRequest);
                methodComponents.getRouteMethodAttributes().put("networkrequest", methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(networkRequest);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("net.plsar.model.NetworkResponse")) {
                methodAttribute.setDescription("networkresponse");
                methodAttribute.setAttribute(networkResponse);
                methodComponents.getRouteMethodAttributes().put("networkresponse", methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(networkResponse);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("net.plsar.model.FlashMessage")) {
                methodAttribute.setDescription("flashmessage");
                methodAttribute.setAttribute(flashMessage);
                methodComponents.getRouteMethodAttributes().put("flashmessage", methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(flashMessage);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("net.plsar.model.ViewCache")) {
                methodAttribute.setDescription("viewcache");
                methodAttribute.setAttribute(viewCache);
                methodComponents.getRouteMethodAttributes().put("viewcache", methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(viewCache);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("java.lang.Integer")) {
                attributeValue = Integer.valueOf(routePathUriAttributes[pathVariableIndex]);
                methodAttribute.setAttribute(attributeValue);
                methodComponents.getRouteMethodAttributes().put(methodAttribute.getDescription().toLowerCase(), methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(attributeValue);
                methodComponents.getRouteMethodAttributeVariablesList().add(attributeValue);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("java.lang.Long")) {
                attributeValue = Long.valueOf(routePathUriAttributes[pathVariableIndex]);
                methodAttribute.setAttribute(attributeValue);
                methodComponents.getRouteMethodAttributes().put(methodAttribute.getDescription().toLowerCase(), methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(attributeValue);
                methodComponents.getRouteMethodAttributeVariablesList().add(attributeValue);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("java.math.BigDecimal")) {
                attributeValue = new BigDecimal(routePathUriAttributes[pathVariableIndex]);
                methodAttribute.setAttribute(attributeValue);
                methodComponents.getRouteMethodAttributes().put(methodAttribute.getDescription().toLowerCase(), methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(attributeValue);
                methodComponents.getRouteMethodAttributeVariablesList().add(attributeValue);
            }
            if (endpointMethodAttribute.getType().getTypeName().equals("java.lang.Boolean")) {
                attributeValue = Boolean.valueOf(routePathUriAttributes[pathVariableIndex]);
                methodAttribute.setAttribute(attributeValue);
                methodComponents.getRouteMethodAttributes().put(methodAttribute.getDescription().toLowerCase(), methodAttribute);
                methodComponents.getRouteMethodAttributesList().add(attributeValue);
                methodComponents.getRouteMethodAttributeVariablesList().add(attributeValue);
            }
            if (!endpointMethodAttribute.getType().getTypeName().equals("java.lang.String")) continue;
            attributeValue = String.valueOf(routePathUriAttributes[pathVariableIndex]);
            methodAttribute.setAttribute(attributeValue);
            methodComponents.getRouteMethodAttributes().put(methodAttribute.getDescription().toLowerCase(), methodAttribute);
            methodComponents.getRouteMethodAttributesList().add(attributeValue);
            methodComponents.getRouteMethodAttributeVariablesList().add(attributeValue);
        }
        return methodComponents;
    }

    boolean getRouteVariablesMatch(String routeEndpointPath, RouteEndpoint routeEndpoint) {
        String[] routeEndpointParts;
        String[] routeUriParts = routeEndpointPath.split("/");
        return routeUriParts.length == (routeEndpointParts = routeEndpoint.getRoutePath().split("/")).length;
    }

    public SecurityAttributes getSecurityAttributes() {
        return this.securityAttributes;
    }

    public void setSecurityAttributes(SecurityAttributes securityAttributes) {
        this.securityAttributes = securityAttributes;
    }

    public RouteAttributes getRouteAttributes() {
        return this.routeAttributes;
    }

    public void setRouteAttributes(RouteAttributes routeAttributes) {
        this.routeAttributes = routeAttributes;
    }

    public ComponentsHolder getComponentsHolder() {
        return this.componentsHolder;
    }

    public void setComponentsHolder(ComponentsHolder componentsHolder) {
        this.componentsHolder = componentsHolder;
    }
}

