/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.plsar.model.Component;
import net.plsar.model.FileComponent;
import net.plsar.model.NetworkRequest;
import net.plsar.model.RequestComponent;

public class RequestComponentResolver {
    byte[] requestBytes;
    NetworkRequest networkRequest;

    public void resolve() {
        String[] boundaryParts;
        Map<String, String> headers = this.networkRequest.getHeaders();
        String contentType = headers.get("content-type");
        String[] stringArray = boundaryParts = contentType != null ? contentType.split("boundary=") : new String[]{};
        if (boundaryParts.length > 1) {
            String formDelimiter = boundaryParts[1];
            String requestPayload = this.getRequestContent(this.requestBytes);
            List<RequestComponent> requestComponents = this.getRequestComponents(formDelimiter, requestPayload);
            requestComponents.forEach(requestComponent -> {
                String requestComponentKey = requestComponent.getName();
                this.networkRequest.setRequestComponent(requestComponentKey, (RequestComponent)requestComponent);
            });
        } else if (this.requestBytes.length > 0) {
            try {
                String queryBytes = new String(this.requestBytes, "utf-8");
                String requestQueryComplete = URLDecoder.decode(queryBytes, StandardCharsets.UTF_8.name());
                String[] requestQueryParts = requestQueryComplete.split("\r\n\r\n", 2);
                if (requestQueryParts.length == 2 && !requestQueryParts[1].equals("")) {
                    String requestQuery = requestQueryParts[1];
                    for (String entry : requestQuery.split("&")) {
                        RequestComponent requestComponent2 = new RequestComponent();
                        String[] keyValue = entry.split("=", 2);
                        String key = keyValue[0];
                        if (keyValue.length > 1) {
                            String value = keyValue[1];
                            requestComponent2.setName(key);
                            requestComponent2.setValue(value);
                        } else {
                            requestComponent2.setName(key);
                            requestComponent2.setValue("");
                        }
                        this.networkRequest.put(key, requestComponent2);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    List<RequestComponent> getRequestComponents(String delimeter, String requestPayload) {
        String elementRegex = "(Content-Disposition: form-data; name=\"[a-zA-Z\\-\\._\\d]+\"\\s)|(Content-Disposition: form-data; name=\"[a-zA-Z\\-\\.\\d]+\"; filename=\"[a-zA-Z\\.\\-_\\s\\d\\']+\")";
        ArrayList<Object> components = new ArrayList<Object>();
        Pattern elementPattern = Pattern.compile(elementRegex);
        Matcher elementMatcher = elementPattern.matcher(requestPayload);
        Integer lastIndex = 0;
        while (elementMatcher.find()) {
            String fileGroup = elementMatcher.group();
            Integer beginIndex = requestPayload.indexOf(fileGroup, (int)lastIndex);
            Integer delimiterIndex = requestPayload.indexOf(delimeter, beginIndex + 1);
            String componentContent = requestPayload.substring(beginIndex, delimiterIndex);
            Component component = new Component(componentContent);
            component.setActiveBeginIndex(beginIndex);
            component.setActiveCloseIndex(delimiterIndex + delimeter.length());
            components.add(component);
            lastIndex = delimiterIndex;
        }
        String NAME = "name=\"";
        String FILE = "filename=\"";
        String NEWLINE = "\r\n";
        HashMap<String, RequestComponent> requestComponentMap = new HashMap<String, RequestComponent>();
        for (Component component : components) {
            FileComponent fileComponent;
            RequestComponent requestComponent;
            String componentContent = component.getComponent();
            Integer beginNameIdx = componentContent.indexOf("name=\"");
            Integer endNameIdx = componentContent.indexOf("\"", beginNameIdx + "name=\"".length());
            String nameElement = componentContent.substring(beginNameIdx + "name=\"".length(), endNameIdx);
            Integer beginFilenameIdx = componentContent.indexOf("filename=\"");
            if (beginFilenameIdx.compareTo(-1) == 0) {
                Integer beginValueIdx = componentContent.indexOf("\r\n\r\n", (int)endNameIdx);
                Integer endValueIdx = componentContent.indexOf("--", beginValueIdx + "\r\n".length());
                String valueDirty = componentContent.substring(beginValueIdx + "\r\n".length(), endValueIdx);
                String value = valueDirty.replace("\r\n", "");
                if (requestComponentMap.containsKey(nameElement)) {
                    RequestComponent requestComponent2 = (RequestComponent)requestComponentMap.get(nameElement);
                    requestComponent2.setName(nameElement);
                    requestComponent2.setValue(value);
                    requestComponent2.getValues().add(value);
                    requestComponentMap.replace(nameElement, requestComponent2);
                    continue;
                }
                RequestComponent requestComponent2 = new RequestComponent();
                requestComponent2.setName(nameElement);
                requestComponent2.setValue(value);
                requestComponent2.getValues().add(value);
                requestComponentMap.put(nameElement, requestComponent2);
                continue;
            }
            if (requestComponentMap.containsKey(nameElement)) {
                requestComponent = (RequestComponent)requestComponentMap.get(nameElement);
                requestComponent.setName(nameElement);
                fileComponent = this.getFileComponent(component, componentContent);
                if (fileComponent == null) continue;
                requestComponent.getFileComponents().add(fileComponent);
                requestComponentMap.put(nameElement, requestComponent);
                continue;
            }
            requestComponent = new RequestComponent();
            requestComponent.setName(nameElement);
            fileComponent = this.getFileComponent(component, componentContent);
            if (fileComponent == null) continue;
            requestComponent.getFileComponents().add(fileComponent);
            requestComponentMap.put(nameElement, requestComponent);
        }
        ArrayList<RequestComponent> requestComponents = new ArrayList<RequestComponent>();
        for (Map.Entry requestComponentEntry : requestComponentMap.entrySet()) {
            requestComponents.add((RequestComponent)requestComponentEntry.getValue());
        }
        return requestComponents;
    }

    protected FileComponent getFileComponent(Component component, String componentContent) {
        FileComponent fileComponent = new FileComponent();
        Integer fileIdx = componentContent.indexOf("filename=");
        Integer startFile = componentContent.indexOf("\"", fileIdx + 1);
        Integer endFile = componentContent.indexOf("\"", startFile + 1);
        String fileName = componentContent.substring(startFile + 1, endFile);
        fileComponent.setFileName(fileName);
        Integer startContent = componentContent.indexOf("Content-Type", endFile + 1);
        Integer startType = componentContent.indexOf(":", startContent + 1);
        Integer endType = componentContent.indexOf("\r\n", startType + 1);
        String type = componentContent.substring(startType + 1, endType).trim();
        fileComponent.setContentType(type);
        Integer activeBeginIndex = component.getActiveBeginIndex() + componentContent.indexOf("\r\n", (int)endType) + "\r\n\r\n".length();
        Integer activeCloseIndex = component.getActiveCloseIndex() + componentContent.indexOf("--", (int)activeBeginIndex);
        if (activeCloseIndex >= this.requestBytes.length) {
            activeCloseIndex = this.requestBytes.length;
        }
        if (activeCloseIndex - activeBeginIndex > "\r\n\r\n".length()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int activeIndex = activeBeginIndex.intValue(); activeIndex < activeCloseIndex; ++activeIndex) {
                byte activeByte = this.requestBytes[activeIndex];
                byteArrayOutputStream.write(activeByte);
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            fileComponent.setFileBytes(bytes);
            fileComponent.setActiveIndex(activeCloseIndex);
            return fileComponent;
        }
        return null;
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }

    public void setRequestBytes(byte[] requestBytes) {
        this.requestBytes = requestBytes;
    }

    public NetworkRequest getNetworkRequest() {
        return this.networkRequest;
    }

    public void setNetworkRequest(NetworkRequest networkRequest) {
        this.networkRequest = networkRequest;
    }

    String getRequestContent(byte[] requestBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : requestBytes) {
            sb.append((char)b);
        }
        return sb.toString();
    }
}

