/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.net.ServerSocket;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.plsar.NetworkRequestRunnable;
import net.plsar.PersistenceConfig;
import net.plsar.RouteAttributes;
import net.plsar.RouteEndpointNegotiator;
import net.plsar.model.RedirectInfo;
import net.plsar.resources.ServerResources;
import net.plsar.security.SecurityAttributes;

public class PartitionedRunnable
implements Runnable {
    String PARTITION_GUID;
    String RENDERER;
    String resourcesDirectory;
    Integer numberOfExecutors;
    ServerSocket serverSocket;
    Queue<RouteEndpointNegotiator> routeNegotiators;
    List<Class<?>> viewRenderers;
    ConcurrentMap<String, String> sessionRouteRegistry;
    ConcurrentMap<String, byte[]> viewBytesMap;
    ConcurrentMap<String, RedirectInfo> initialsRegistry;
    RouteAttributes routeAttributes;
    SecurityAttributes securityAttributes;
    PersistenceConfig persistenceConfig;
    Class<?> securityAccessKlass;

    public PartitionedRunnable(String RENDERER, Integer numberOfExecutors, String resourcesDirectory, SecurityAttributes securityAttributes, RouteAttributes routeAttributes, ConcurrentMap<String, byte[]> viewBytesMap, ServerSocket serverSocket, PersistenceConfig persistenceConfig, List<Class<?>> viewRenderers, Class<?> securityAccessKlass) {
        String partitionGuid;
        ServerResources serverResources = new ServerResources();
        this.PARTITION_GUID = partitionGuid = serverResources.getGuid(48);
        this.RENDERER = RENDERER;
        this.securityAccessKlass = securityAccessKlass;
        this.securityAttributes = securityAttributes;
        this.viewBytesMap = viewBytesMap;
        this.numberOfExecutors = numberOfExecutors;
        this.serverSocket = serverSocket;
        this.viewRenderers = viewRenderers;
        this.resourcesDirectory = resourcesDirectory;
        this.routeAttributes = routeAttributes;
        this.persistenceConfig = persistenceConfig;
        this.sessionRouteRegistry = new ConcurrentHashMap<String, String>();
        this.initialsRegistry = new ConcurrentHashMap<String, RedirectInfo>();
    }

    @Override
    public void run() {
        try {
            ExecutorService executors = Executors.newFixedThreadPool(this.numberOfExecutors);
            executors.execute(new NetworkRequestRunnable(this.RENDERER, this.resourcesDirectory, this.routeAttributes, this.securityAttributes, this.viewBytesMap, executors, this.serverSocket, this.viewRenderers, this.persistenceConfig, this.securityAccessKlass, null, null));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

