/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.plsar.DatabaseEnvironmentManager;
import net.plsar.PartitionedRunnable;
import net.plsar.PersistenceConfig;
import net.plsar.PlsarException;
import net.plsar.PropertiesConfig;
import net.plsar.RouteAttributes;
import net.plsar.RouteAttributesResolver;
import net.plsar.SchemaConfig;
import net.plsar.ViewConfig;
import net.plsar.environments.Environments;
import net.plsar.resources.AnnotationComponent;
import net.plsar.resources.ComponentsHolder;
import net.plsar.resources.ServerResources;
import net.plsar.resources.StartupAnnotationInspector;
import net.plsar.security.SecurityAttributes;

public class PLSAR {
    static Logger Log = Logger.getLogger(PLSAR.class.getName());
    Integer port;
    String PROPERTIES;
    String RENDERING_SCHEME;
    Integer STARTUP_EXECUTORS;
    ViewConfig viewConfig;
    SchemaConfig schemaConfig;
    PropertiesConfig propertiesConfig;
    Integer numberOfPartitions = 3;
    Integer numberOfRequestExecutors = 7;
    PersistenceConfig persistenceConfig;
    Class<?> securityAccessKlass;
    List<Class<?>> viewRenderers;
    SecurityAttributes securityAttributes;

    public PLSAR(int port) {
        this.port = port;
        this.STARTUP_EXECUTORS = 19;
        this.PROPERTIES = "system.properties";
        this.RENDERING_SCHEME = "cache";
        this.viewConfig = new ViewConfig();
        this.viewRenderers = new ArrayList();
    }

    public void start() {
        try {
            ServerResources serverResources = new ServerResources();
            if (this.schemaConfig != null && this.schemaConfig.getEnvironment().equals(Environments.DEVELOPMENT)) {
                DatabaseEnvironmentManager databaseEnvironmentManager = new DatabaseEnvironmentManager();
                databaseEnvironmentManager.configure(this.schemaConfig, this.persistenceConfig);
            }
            StartupAnnotationInspector startupAnnotationInspector = new StartupAnnotationInspector(new ComponentsHolder());
            startupAnnotationInspector.inspect();
            ComponentsHolder componentsHolder = startupAnnotationInspector.getComponentsHolder();
            if (this.propertiesConfig == null) {
                this.propertiesConfig = new PropertiesConfig();
                this.propertiesConfig.setPropertiesFile(this.PROPERTIES);
            }
            String propertiesFile = this.propertiesConfig.getPropertiesFile();
            RouteAttributesResolver routeAttributesResolver = new RouteAttributesResolver(propertiesFile);
            RouteAttributes routeAttributes = routeAttributesResolver.resolve();
            AnnotationComponent serverStartup = componentsHolder.getServerStartup();
            String resourcesDirectory = this.viewConfig.getResourcesPath();
            ConcurrentMap<String, byte[]> viewBytesMap = serverResources.getViewBytesMap(this.viewConfig);
            Log.info("Running startup routine, please wait...");
            if (serverStartup != null) {
                Method startupMethod = serverStartup.getKlass().getMethod("startup", new Class[0]);
                startupMethod.invoke(serverResources.getInstance(serverStartup.getKlass()), new Object[0]);
            }
            Log.info("Registering network request negotiators, please wait...\n");
            ServerSocket serverSocket = new ServerSocket(this.port);
            serverSocket.setPerformancePreferences(0, 1, 2);
            ExecutorService executors = Executors.newFixedThreadPool(this.numberOfPartitions);
            executors.execute(new PartitionedRunnable(this.RENDERING_SCHEME, this.numberOfRequestExecutors, resourcesDirectory, this.securityAttributes, routeAttributes, viewBytesMap, serverSocket, this.persistenceConfig, this.viewRenderers, this.securityAccessKlass));
            Log.info("Ready!");
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PlsarException ex) {
            ex.printStackTrace();
        }
    }

    public void setPropertiesConfig(PropertiesConfig propertiesConfig) {
        this.propertiesConfig = propertiesConfig;
    }

    public void setPageRenderingScheme(String RENDERING_SCHEME) {
        this.RENDERING_SCHEME = RENDERING_SCHEME;
    }

    public void setViewConfig(ViewConfig viewConfig) {
        this.viewConfig = viewConfig;
    }

    public void setSecurityAccess(Class<?> securityAccessKlass) {
        this.securityAccessKlass = securityAccessKlass;
    }

    public void setSchemaConfig(SchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    public void setNumberOfRequestExecutors(int numberOfRequestExecutors) {
        this.numberOfRequestExecutors = numberOfRequestExecutors;
    }

    public PLSAR setStartupExecutors(Integer STARTUP_EXECUTORS) {
        this.STARTUP_EXECUTORS = STARTUP_EXECUTORS;
        return this;
    }

    public PLSAR addViewRenderer(Class<?> viewRenderer) {
        this.viewRenderers.add(viewRenderer);
        return this;
    }

    public PLSAR setPersistenceConfig(PersistenceConfig persistenceConfig) {
        this.persistenceConfig = persistenceConfig;
        return this;
    }
}

