/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import net.plsar.NegotiatorRegistryFactory;
import net.plsar.NetworkRequestFactory;
import net.plsar.NetworkRequestHeaderResolver;
import net.plsar.PersistenceConfig;
import net.plsar.RequestComponentResolver;
import net.plsar.RequestInputStreamReader;
import net.plsar.RouteAttributes;
import net.plsar.RouteEndpointNegotiator;
import net.plsar.RouteResult;
import net.plsar.SecurityAttributeResolver;
import net.plsar.model.FlashMessage;
import net.plsar.model.NetworkRequest;
import net.plsar.model.NetworkResponse;
import net.plsar.model.SecurityAttribute;
import net.plsar.model.ViewCache;
import net.plsar.resources.ServerResources;
import net.plsar.security.SecurityAttributes;
import net.plsar.security.SecurityManager;

public class NetworkRequestRunnable
implements Runnable {
    String requestGuid;
    final String FAVICON = "/favicon.ico";
    final String BREAK = "\r\n";
    final String SPACE = " ";
    final String DOUBLEBREAK = "\r\n\r\n";
    final Integer REQUEST_METHOD = 0;
    final Integer REQUEST_PATH = 1;
    final Integer REQUEST_VERSION = 2;
    String RENDERER;
    FlashMessage flashMessage;
    ViewCache viewCache;
    ViewCache storedViewCache;
    FlashMessage storedFlashMessage;
    ServerResources serverResources = new ServerResources();
    String resourcesDirectory;
    Socket socketClient;
    ExecutorService executorService;
    ServerSocket serverSocket;
    List<Class<?>> viewRenderers;
    ConcurrentMap<String, byte[]> viewBytesMap;
    PersistenceConfig persistenceConfig;
    RouteAttributes routeAttributes;
    SecurityAttributes securityAttributes;
    Class<?> securityAccessKlass;

    public NetworkRequestRunnable(String RENDERER, String resourcesDirectory, RouteAttributes routeAttributes, SecurityAttributes securityAttributes, ConcurrentMap<String, byte[]> viewBytesMap, ExecutorService executorService, ServerSocket serverSocket, List<Class<?>> viewRenderers, PersistenceConfig persistenceConfig, Class<?> securityAccessKlass, FlashMessage storedFlashMessage, ViewCache storedViewCache) throws InterruptedException {
        this.requestGuid = this.serverResources.getGuid(32);
        this.RENDERER = RENDERER;
        this.securityAccessKlass = securityAccessKlass;
        this.routeAttributes = routeAttributes;
        this.securityAttributes = securityAttributes;
        this.resourcesDirectory = resourcesDirectory;
        this.viewBytesMap = viewBytesMap;
        this.executorService = executorService;
        this.serverSocket = serverSocket;
        this.viewRenderers = viewRenderers;
        this.storedViewCache = storedViewCache;
        this.storedFlashMessage = storedFlashMessage;
        this.persistenceConfig = persistenceConfig;
    }

    @Override
    public void run() {
        NetworkRequestFactory networkRequestFactory = new NetworkRequestFactory();
        try {
            String[] requestHeaderElements;
            this.initializeScopes();
            this.socketClient = this.serverSocket.accept();
            Thread.sleep(19L);
            InputStream requestInputStream = this.socketClient.getInputStream();
            OutputStream requestOutputStream = this.socketClient.getOutputStream();
            NegotiatorRegistryFactory negotiatorRegistryFactory = new NegotiatorRegistryFactory();
            negotiatorRegistryFactory.setPersistenceConfig(this.persistenceConfig);
            negotiatorRegistryFactory.setSecurityAccessKlass(this.securityAccessKlass);
            negotiatorRegistryFactory.setRouteAttributes(this.routeAttributes);
            negotiatorRegistryFactory.setServerResources(this.serverResources);
            RouteEndpointNegotiator routeEndpointNegotiator = negotiatorRegistryFactory.create();
            networkRequestFactory.setRenderer(this.RENDERER);
            networkRequestFactory.setServerSocket(this.serverSocket);
            networkRequestFactory.setViewRenderers(this.viewRenderers);
            networkRequestFactory.setViewBytesMap(this.viewBytesMap);
            networkRequestFactory.setResourcesDirectory(this.resourcesDirectory);
            networkRequestFactory.setRequestOutputStream(requestOutputStream);
            networkRequestFactory.setRequestInputStream(requestInputStream);
            networkRequestFactory.setExecutorService(this.executorService);
            networkRequestFactory.setSecurityAttributes(this.securityAttributes);
            networkRequestFactory.setViewCache(this.viewCache);
            networkRequestFactory.setFlashMessage(this.flashMessage);
            networkRequestFactory.setPersistenceConfig(this.persistenceConfig);
            networkRequestFactory.setRouteAttributes(this.routeAttributes);
            if (requestInputStream.available() == 0) {
                networkRequestFactory.execute();
                return;
            }
            RequestInputStreamReader requestInputStreamReader = new RequestInputStreamReader();
            requestInputStreamReader.setRequestInputStream(requestInputStream);
            requestInputStreamReader.read();
            ByteArrayOutputStream byteArrayOutputStream = requestInputStreamReader.getByteArrayOutputStream();
            String completeRequestContent = byteArrayOutputStream.toString();
            String[] requestBlocks = completeRequestContent.split("\r\n\r\n", 2);
            String requestHeaderElement = requestBlocks[0];
            String[] methodPathComponentsLookup = requestHeaderElement.split("\r\n");
            String methodPathComponent = methodPathComponentsLookup[0];
            String[] methodPathVersionComponents = methodPathComponent.split("\\s");
            String requestAction = methodPathVersionComponents[this.REQUEST_METHOD];
            String requestPath = methodPathVersionComponents[this.REQUEST_PATH];
            String requestVersion = methodPathVersionComponents[this.REQUEST_VERSION];
            if (requestPath.equals("/favicon.ico")) {
                networkRequestFactory.execute();
                return;
            }
            NetworkRequest networkRequest = new NetworkRequest();
            networkRequest.setRequestAction(requestAction);
            networkRequest.setRequestPath(requestPath);
            NetworkResponse networkResponse = new NetworkResponse();
            for (String headerLineElement : requestHeaderElements = requestHeaderElement.split("\r\n")) {
                String[] headerLineComponents = headerLineElement.split(":", 2);
                if (headerLineComponents.length != 2) continue;
                String fieldKey = headerLineComponents[0].trim();
                String content = headerLineComponents[1].trim();
                networkRequest.getHeaders().put(fieldKey.toLowerCase(), content);
            }
            Integer attributesIdx = requestPath.indexOf("?");
            if (attributesIdx != -1) {
                String attributesElement = requestPath.substring(attributesIdx + 1);
                requestPath = requestPath.substring(0, attributesIdx);
                networkRequest.setValues(attributesElement);
                networkRequest.setRequestPath(requestPath);
            }
            SecurityAttributeResolver securityAttributeResolver = new SecurityAttributeResolver();
            securityAttributeResolver.setSecurityAttributes(routeEndpointNegotiator.getSecurityAttributes());
            securityAttributeResolver.resolve(networkRequest, networkResponse);
            networkResponse.setResponseStream(requestOutputStream);
            networkRequest.setSecurityAttributes(this.securityAttributes);
            byte[] requestByteArray = byteArrayOutputStream.toByteArray();
            RequestComponentResolver requestComponentResolver = new RequestComponentResolver();
            requestComponentResolver.setRequestBytes(requestByteArray);
            requestComponentResolver.setNetworkRequest(networkRequest);
            requestComponentResolver.resolve();
            RouteAttributes routeAttributes = routeEndpointNegotiator.getRouteAttributes();
            networkRequest.setRouteAttributes(routeAttributes);
            SecurityManager securityManager = routeAttributes.getSecurityManager();
            securityManager.setSecurityAttributes(routeEndpointNegotiator.getSecurityAttributes());
            RouteResult routeResult = routeEndpointNegotiator.performNetworkRequest(this.RENDERER, this.resourcesDirectory, this.viewCache, this.flashMessage, networkRequest, networkResponse, this.securityAttributes, securityManager, this.viewRenderers, this.viewBytesMap);
            if (routeResult.getCompleteRequest() != null && routeResult.getCompleteRequest().booleanValue()) {
                networkRequestFactory.execute();
                return;
            }
            StringBuilder sessionValues = new StringBuilder();
            NetworkRequestHeaderResolver networkRequestHeaderResolver = new NetworkRequestHeaderResolver();
            networkRequestHeaderResolver.setRequestHeaderElement(requestHeaderElement);
            networkRequestHeaderResolver.setNetworkRequest(networkRequest);
            networkRequestHeaderResolver.resolve();
            for (Map.Entry<String, SecurityAttribute> securityAttributeEntry : networkResponse.getSecurityAttributes().entrySet()) {
                SecurityAttribute securityAttribute = securityAttributeEntry.getValue();
                sessionValues.append(securityAttribute.getName()).append("=").append(securityAttribute.getValue());
            }
            requestOutputStream.write((requestVersion + " ").getBytes());
            requestOutputStream.write(routeResult.getResponseCode().getBytes());
            requestOutputStream.write("\r\n".getBytes());
            if (networkRequest.isRedirect()) {
                requestOutputStream.write("Content-Type:text/html".getBytes());
                requestOutputStream.write("\r\n".getBytes());
                requestOutputStream.write("Set-Cookie:".getBytes());
                requestOutputStream.write(sessionValues.toString().getBytes());
                requestOutputStream.write("\r\n".getBytes());
                requestOutputStream.write(("Location: " + networkRequest.getRedirectLocation() + " ").getBytes());
                requestOutputStream.write("\r\n".getBytes());
                requestOutputStream.write("Content-Length: -1".getBytes());
                requestOutputStream.write("\r\n\r\n".getBytes());
                requestOutputStream.close();
                this.socketClient.close();
                networkRequestFactory.execute();
                return;
            }
            requestOutputStream.write("Content-Type:".getBytes());
            requestOutputStream.write(routeResult.getContentType().getBytes());
            requestOutputStream.write("\r\n".getBytes());
            requestOutputStream.write("Set-Cookie:".getBytes());
            requestOutputStream.write(sessionValues.toString().getBytes());
            requestOutputStream.write("\r\n\r\n".getBytes());
            requestOutputStream.write(routeResult.getResponseBytes());
            requestOutputStream.close();
            this.socketClient.close();
            networkRequestFactory.execute();
        }
        catch (IOException | InterruptedException ex) {
            try {
                networkRequestFactory.execute();
                return;
            }
            catch (IOException | InterruptedException iox) {
                try {
                    networkRequestFactory.execute();
                    return;
                }
                catch (IOException | InterruptedException ioException) {
                    ioException.printStackTrace();
                    iox.printStackTrace();
                    ex.printStackTrace();
                }
            }
        }
    }

    void initializeScopes() {
        this.flashMessage = this.storedFlashMessage != null ? this.storedFlashMessage : new FlashMessage();
        this.viewCache = this.storedViewCache != null ? this.storedViewCache : new ViewCache();
    }
}

