/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.plsar.Dao;
import net.plsar.PersistenceConfig;
import net.plsar.RouteAttributes;
import net.plsar.RouteEndpointHolder;
import net.plsar.RouteEndpointNegotiator;
import net.plsar.RouteEndpointsResolver;
import net.plsar.resources.ComponentAnnotationInspector;
import net.plsar.resources.ComponentsHolder;
import net.plsar.resources.ServerResources;
import net.plsar.security.SecurityAccess;
import net.plsar.security.SecurityAttributes;
import net.plsar.security.SecurityManager;

public class NegotiatorRegistryFactory {
    Class<?> securityAccessKlass;
    PersistenceConfig persistenceConfig;
    ServerResources serverResources;
    RouteAttributes routeAttributes;

    public RouteEndpointNegotiator create() {
        RouteEndpointNegotiator routeEndpointNegotiator = new RouteEndpointNegotiator();
        try {
            String securedAttribute = "attribute";
            String securityElement = "r.13";
            SecurityAttributes securityAttributes = new SecurityAttributes(securityElement, securedAttribute);
            RouteEndpointsResolver routeEndpointsResolver = new RouteEndpointsResolver(this.serverResources);
            RouteEndpointHolder routeEndpointHolder = routeEndpointsResolver.resolve();
            this.routeAttributes.setRouteEndpointHolder(routeEndpointHolder);
            if (this.persistenceConfig != null) {
                PersistenceConfig persistenceConfig = new PersistenceConfig();
                persistenceConfig.setDriver(this.persistenceConfig.getDriver());
                persistenceConfig.setUrl(this.persistenceConfig.getUrl());
                persistenceConfig.setUser(this.persistenceConfig.getUser());
                persistenceConfig.setConnections(this.persistenceConfig.getConnections());
                persistenceConfig.setPassword(this.persistenceConfig.getPassword());
                this.routeAttributes.setPersistenceConfig(this.persistenceConfig);
            }
            if (this.securityAccessKlass != null) {
                Dao dao = new Dao(this.persistenceConfig);
                SecurityAccess securityAccessInstance = (SecurityAccess)this.securityAccessKlass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method setPersistence = securityAccessInstance.getClass().getMethod("setDao", Dao.class);
                setPersistence.invoke((Object)securityAccessInstance, dao);
                SecurityManager securityManager = new SecurityManager(securityAccessInstance);
                this.routeAttributes.setSecurityManager(securityManager);
                this.routeAttributes.setSecurityAccess(this.securityAccessKlass);
            }
            ComponentAnnotationInspector componentAnnotationInspector = new ComponentAnnotationInspector(new ComponentsHolder());
            componentAnnotationInspector.inspect();
            ComponentsHolder componentsHolder = componentAnnotationInspector.getComponentsHolder();
            routeEndpointNegotiator.setSecurityAttributes(securityAttributes);
            routeEndpointNegotiator.setRouteAttributes(this.routeAttributes);
            routeEndpointNegotiator.setComponentsHolder(componentsHolder);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return routeEndpointNegotiator;
    }

    public Class<?> getSecurityAccessKlass() {
        return this.securityAccessKlass;
    }

    public void setSecurityAccessKlass(Class<?> securityAccessKlass) {
        this.securityAccessKlass = securityAccessKlass;
    }

    public PersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    public void setPersistenceConfig(PersistenceConfig persistenceConfig) {
        this.persistenceConfig = persistenceConfig;
    }

    public ServerResources getServerResources() {
        return this.serverResources;
    }

    public void setServerResources(ServerResources serverResources) {
        this.serverResources = serverResources;
    }

    public RouteAttributes getRouteAttributes() {
        return this.routeAttributes;
    }

    public void setRouteAttributes(RouteAttributes routeAttributes) {
        this.routeAttributes = routeAttributes;
    }
}

