/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.plsar.ExecutableDatasource;
import net.plsar.PersistenceConfig;

public class Dao {
    Logger Log = Logger.getLogger("Dao");
    DataSource datasource;
    PersistenceConfig config;

    public Dao(PersistenceConfig config) {
        this.config = config;
        this.datasource = new ExecutableDatasource.Builder().driver(config.getDriver()).url(config.getUrl()).user(config.getUser()).password(config.getPassword()).connections(130).create();
    }

    public <T> T get(String preSql, Object[] sqlparams, Class<?> klass) {
        Object result = null;
        String sql = "";
        try {
            sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                result = this.getResult(resultSet, klass);
            }
            if (result == null) {
                throw new Exception(klass + " not found using '" + sql + "'");
            }
            connection.commit();
            connection.close();
        }
        catch (SQLException ex) {
            if (this.config.isDebug()) {
                this.Log.info("bad sql:" + sql);
            }
        }
        catch (Exception ex) {
            this.Log.info(ex.getMessage());
        }
        return (T)klass.cast(result);
    }

    public Integer getInt(String preSql, Object[] sqlparams) {
        Integer result = null;
        String sql = "";
        try {
            sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                result = Integer.parseInt(resultSet.getObject(1).toString());
            }
            if (result == null) {
                throw new Exception("no results using '" + sql + "'");
            }
            connection.commit();
            connection.close();
        }
        catch (SQLException ex) {
            if (this.config.isDebug()) {
                this.Log.info("bad sql:" + sql);
            }
        }
        catch (Exception ex) {
            this.Log.info(ex.getMessage());
        }
        return result;
    }

    public Long getLong(String preSql, Object[] sqlparams) {
        Long result = null;
        String sql = "";
        try {
            sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                result = Long.parseLong(resultSet.getObject(1).toString());
            }
            if (result == null) {
                throw new Exception("no results using '" + sql + "'");
            }
            connection.commit();
            connection.close();
        }
        catch (SQLException ex) {
            if (this.config.isDebug()) {
                this.Log.info("bad sql:" + sql);
            }
        }
        catch (Exception ex) {
            this.Log.info(ex.getMessage());
        }
        return result;
    }

    public boolean save(String preSql, Object[] sqlparams) {
        try {
            String sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement statement = connection.createStatement();
            statement.execute(sql);
            connection.commit();
            connection.close();
        }
        catch (Exception ex) {
            if (this.config.isDebug()) {
                this.Log.info(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    public <T> List<T> getList(String preSql, Object[] sqlparams, Class<?> klass) {
        ArrayList<T> results = new ArrayList<T>();
        try {
            String sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                T obj = this.getResult(rs, klass);
                results.add(obj);
            }
            connection.commit();
            connection.close();
        }
        catch (ClassCastException ccex) {
            if (this.config.isDebug()) {
                this.Log.info(ccex.getMessage());
            }
        }
        catch (Exception ex) {
            this.Log.info(ex.getMessage());
        }
        return results;
    }

    public boolean update(String preSql, Object[] sqlparams) {
        try {
            String sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement statement = connection.createStatement();
            statement.execute(sql);
            connection.commit();
            connection.close();
        }
        catch (Exception ex) {
            if (this.config.isDebug()) {
                this.Log.info(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    public boolean delete(String preSql, Object[] sqlparams) {
        try {
            String sql = this.getPopulatedSqlStatement(preSql, sqlparams);
            Connection connection = this.datasource.getConnection();
            Statement stmt = connection.createStatement();
            stmt.execute(sql);
            connection.commit();
            connection.close();
        }
        catch (Exception ex) {
            if (this.config.isDebug()) {
                this.Log.info(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    protected String getPopulatedSqlStatement(String sql, Object[] sqlparams) {
        for (Object object : sqlparams) {
            if (object != null) {
                String parameter = object.toString();
                if (object.getClass().getTypeName().equals("java.lang.String")) {
                    parameter = parameter.replace("'", "''").replace("$", "\\$").replace("#", "\\#").replace("@", "\\@");
                }
                sql = sql.replaceFirst("\\[\\+\\]", parameter);
                continue;
            }
            sql = sql.replaceFirst("\\[\\+\\]", "null");
        }
        return sql;
    }

    protected <T> T getResult(ResultSet resultSet, Class<?> klass) throws Exception {
        Field[] fields;
        Constructor<?>[] constructors;
        Object object = new Object();
        for (Constructor<?> constructor : constructors = klass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            object = constructor.newInstance(new Object[0]);
        }
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String originalName = field.getName();
            String regex = "([a-z])([A-Z]+)";
            String replacement = "$1_$2";
            String name = originalName.replaceAll(regex, replacement).toLowerCase();
            Class<?> type = field.getType();
            if (!Dao.hasColumn(resultSet, name)) continue;
            if (type.getTypeName().equals("int") || type.getTypeName().equals("java.lang.Integer")) {
                field.set(object, resultSet.getInt(name));
                continue;
            }
            if (type.getTypeName().equals("double") || type.getTypeName().equals("java.lang.Double")) {
                field.set(object, resultSet.getDouble(name));
                continue;
            }
            if (type.getTypeName().equals("float") || type.getTypeName().equals("java.lang.Float")) {
                field.set(object, Float.valueOf(resultSet.getFloat(name)));
                continue;
            }
            if (type.getTypeName().equals("long") || type.getTypeName().equals("java.lang.Long")) {
                field.set(object, resultSet.getLong(name));
                continue;
            }
            if (type.getTypeName().equals("boolean") || type.getTypeName().equals("java.lang.Boolean")) {
                field.set(object, resultSet.getBoolean(name));
                continue;
            }
            if (type.getTypeName().equals("java.math.BigDecimal")) {
                field.set(object, resultSet.getBigDecimal(name));
                continue;
            }
            if (!type.getTypeName().equals("java.lang.String")) continue;
            if (resultSet.getString(name) != null && !resultSet.getString(name).equals("null")) {
                field.set(object, resultSet.getString(name));
                continue;
            }
            field.set(object, "");
        }
        return (T)klass.cast(object);
    }

    public static boolean hasColumn(ResultSet resultSet, String columnName) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        for (int foo = 1; foo <= rsmd.getColumnCount(); ++foo) {
            if (!columnName.equals(rsmd.getColumnName(foo).toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

