/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.resources;

import java.util.HashMap;
import java.util.Map;

public class MimeResolver {
    String resourceUri;
    Map<String, String> MIME_MAP;

    public MimeResolver(String resourceUri) {
        this.resourceUri = resourceUri;
        this.MIME_MAP = new HashMap<String, String>();
        this.MIME_MAP.put("appcache", "text/cache-manifest");
        this.MIME_MAP.put("css", "text/css");
        this.MIME_MAP.put("gif", "image/gif");
        this.MIME_MAP.put("html", "text/html");
        this.MIME_MAP.put("js", "application/javascript");
        this.MIME_MAP.put("json", "application/json");
        this.MIME_MAP.put("jpg", "image/jpeg");
        this.MIME_MAP.put("jpeg", "image/jpeg");
        this.MIME_MAP.put("mp4", "video/mp4");
        this.MIME_MAP.put("mp3", "audio/mp3");
        this.MIME_MAP.put("pdf", "application/pdf");
        this.MIME_MAP.put("png", "image/png");
        this.MIME_MAP.put("svg", "image/svg+xml");
        this.MIME_MAP.put("xlsm", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.MIME_MAP.put("xml", "application/xml");
        this.MIME_MAP.put("zip", "application/zip");
        this.MIME_MAP.put("md", "text/plain");
        this.MIME_MAP.put("txt", "text/plain");
        this.MIME_MAP.put("php", "text/plain");
    }

    public Boolean within(String key) {
        return this.MIME_MAP.containsKey(key);
    }

    public String resolve() {
        String key = MimeResolver.getExt(this.resourceUri).toLowerCase();
        return this.MIME_MAP.containsKey(key) ? this.MIME_MAP.get(key) : "text/html";
    }

    public static String getExt(String path) {
        int slashIndex = path.lastIndexOf(47);
        String basename = slashIndex < 0 ? path : path.substring(slashIndex + 1);
        int dotIdx = basename.lastIndexOf(46);
        if (dotIdx >= 0) {
            return basename.substring(dotIdx + 1);
        }
        return "";
    }
}

