/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.plsar.Dao;
import net.plsar.ExperienceManager;
import net.plsar.PersistenceConfig;
import net.plsar.PlsarException;
import net.plsar.RouteAttributes;
import net.plsar.RouteEndpoint;
import net.plsar.RouteEndpointHolder;
import net.plsar.RouteResponse;
import net.plsar.annotations.Bind;
import net.plsar.annotations.Design;
import net.plsar.annotations.JsonOutput;
import net.plsar.annotations.Meta;
import net.plsar.annotations.Text;
import net.plsar.model.NetworkRequest;
import net.plsar.model.NetworkResponse;
import net.plsar.model.PageCache;
import net.plsar.model.RouteAttribute;
import net.plsar.resources.ComponentsHolder;
import net.plsar.resources.MimeResolver;
import net.plsar.resources.ServerResources;
import net.plsar.security.SecurityManager;

public class RouteNegotiator {
    String guid = new ServerResources().getGuid(24);
    RouteAttributes routeAttributes;
    ComponentsHolder componentsHolder;

    public RouteResponse negotiate(String RENDERER, String resourcesDirectory, PageCache pageCache, NetworkRequest networkRequest, NetworkResponse networkResponse, SecurityManager securityManager, List<Class<?>> viewRenderers, ConcurrentMap<String, byte[]> viewBytesMap) {
        Object completePageRendered = "";
        Object errorMessage = "";
        try {
            String methodResponse;
            ServerResources serverResources = new ServerResources();
            ExperienceManager experienceManager = new ExperienceManager();
            RouteAttributes routeAttributes = networkRequest.getRouteAttributes();
            RouteEndpointHolder routeEndpointHolder = routeAttributes.getRouteEndpointHolder();
            String routeUriPath = networkRequest.getUriPath();
            String routeVerb = networkRequest.getVerb();
            if (routeUriPath.startsWith("/" + resourcesDirectory + "/")) {
                MimeResolver mimeGetter = new MimeResolver(routeUriPath);
                if (RENDERER.equals("cache")) {
                    ByteArrayOutputStream outputStream = serverResources.getViewFileCopy(routeUriPath, viewBytesMap);
                    if (outputStream == null) {
                        return new RouteResponse("404".getBytes(), "404", "text/html");
                    }
                    return new RouteResponse(outputStream.toByteArray(), "200 OK", mimeGetter.resolve());
                }
                String assetsPath = Paths.get("src", "main", "webapp").toString();
                String filePath = assetsPath.concat(routeUriPath);
                File staticResourcefile = new File(filePath);
                FileInputStream fileInputStream = new FileInputStream(staticResourcefile);
                if (fileInputStream != null && routeVerb.equals("get")) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[(int)staticResourcefile.length()];
                    try {
                        int bytesRead;
                        while ((bytesRead = ((InputStream)fileInputStream).read(bytes, 0, bytes.length)) != -1) {
                            outputStream.write(bytes, 0, bytesRead);
                        }
                        ((InputStream)fileInputStream).close();
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    return new RouteResponse(outputStream.toByteArray(), "200 OK", mimeGetter.resolve());
                }
            }
            RouteEndpoint routeEndpoint = null;
            if ((routeUriPath = routeUriPath.toLowerCase().trim()).equals("")) {
                routeUriPath = "/";
                String routeKey = routeVerb.toLowerCase() + routeUriPath.toLowerCase();
                routeEndpoint = routeEndpointHolder.getRouteEndpoints().get(routeKey);
            }
            if (routeEndpoint == null) {
                if (routeUriPath.length() > 1 && routeUriPath.endsWith("/")) {
                    int endIndex = routeUriPath.indexOf("/", routeUriPath.length() - 1);
                    routeUriPath = routeUriPath.substring(0, endIndex);
                }
                if (routeEndpointHolder.getRouteEndpoints().containsKey(routeVerb + ":" + routeUriPath)) {
                    routeEndpoint = routeEndpointHolder.getRouteEndpoints().get(routeVerb + ":" + routeUriPath);
                }
            }
            if (routeEndpoint == null) {
                for (Map.Entry<String, RouteEndpoint> routeEndpointEntry : routeEndpointHolder.getRouteEndpoints().entrySet()) {
                    RouteEndpoint activeRouteEndpoint = routeEndpointEntry.getValue();
                    Matcher routeEndpointMatcher = Pattern.compile(activeRouteEndpoint.getRegexRoutePath()).matcher(routeUriPath);
                    if (!routeEndpointMatcher.matches() || !this.getRouteVariablesMatch(routeUriPath, activeRouteEndpoint) || !activeRouteEndpoint.isRegex().booleanValue()) continue;
                    routeEndpoint = activeRouteEndpoint;
                }
            }
            if (routeEndpoint == null) {
                return new RouteResponse("404".getBytes(), "404", "text/html");
            }
            List<Object> routeMethodAttributes = this.getRouteMethodAttributes(routeUriPath, pageCache, networkRequest, networkResponse, securityManager, routeEndpoint);
            Method routeMethod = routeEndpoint.getRouteMethod();
            String title = null;
            String keywords = null;
            String description = null;
            if (routeMethod.isAnnotationPresent(Meta.class)) {
                Meta metaAnnotation = routeMethod.getAnnotation(Meta.class);
                title = metaAnnotation.title();
                keywords = metaAnnotation.keywords();
                description = metaAnnotation.description();
            }
            routeMethod.setAccessible(true);
            Object routeInstance = routeEndpoint.getKlass().getConstructor(new Class[0]).newInstance(new Object[0]);
            PersistenceConfig persistenceConfig = routeAttributes.getPersistenceConfig();
            if (persistenceConfig != null) {
                Field[] routeFields;
                Dao routeDao = new Dao(persistenceConfig);
                for (Field routeField : routeFields = routeInstance.getClass().getDeclaredFields()) {
                    if (!routeField.isAnnotationPresent(Bind.class)) continue;
                    String fieldKey = routeField.getName().toLowerCase();
                    if (this.componentsHolder.getServices().containsKey(fieldKey)) {
                        Field[] repoFields;
                        Class serviceKlass = (Class)this.componentsHolder.getServices().get(fieldKey);
                        Constructor serviceKlassConstructor = serviceKlass.getConstructor(new Class[0]);
                        Object serviceInstance = serviceKlassConstructor.newInstance(new Object[0]);
                        for (Field repoField : repoFields = serviceInstance.getClass().getDeclaredFields()) {
                            if (!repoField.isAnnotationPresent(Bind.class)) continue;
                            String repoFieldKey = repoField.getName().toLowerCase();
                            if (!this.componentsHolder.getRepositories().containsKey(repoFieldKey)) continue;
                            Class repositoryKlass = (Class)this.componentsHolder.getRepositories().get(repoFieldKey);
                            Constructor repositoryKlassConstructor = repositoryKlass.getConstructor(Dao.class);
                            Object repositoryInstance = repositoryKlassConstructor.newInstance(routeDao);
                            repoField.setAccessible(true);
                            repoField.set(serviceInstance, repositoryInstance);
                        }
                        routeField.setAccessible(true);
                        routeField.set(routeInstance, serviceInstance);
                    }
                    if (!this.componentsHolder.getRepositories().containsKey(fieldKey)) continue;
                    Class componentKlass = (Class)this.componentsHolder.getRepositories().get(fieldKey);
                    Constructor componentKlassConstructor = componentKlass.getConstructor(Dao.class);
                    Object componentInstance = componentKlassConstructor.newInstance(routeDao);
                    routeField.setAccessible(true);
                    routeField.set(routeInstance, componentInstance);
                }
                try {
                    Method setPersistenceMethod = routeInstance.getClass().getMethod("setDao", Dao.class);
                    setPersistenceMethod.invoke(routeInstance, new Dao(persistenceConfig));
                }
                catch (NoSuchMethodException setPersistenceMethod) {
                    // empty catch block
                }
            }
            if ((methodResponse = String.valueOf(routeMethod.invoke(routeInstance, routeMethodAttributes.toArray()))) == null) {
                return new RouteResponse("404".getBytes(), "404", "text/html");
            }
            if (methodResponse.startsWith("redirect:")) {
                String redirectRouteUri = serverResources.getRedirect(methodResponse);
                networkResponse.setRedirectLocation(redirectRouteUri);
                return new RouteResponse("307".getBytes(), "307", "text/html");
            }
            if (routeMethod.isAnnotationPresent(JsonOutput.class)) {
                return new RouteResponse(methodResponse.getBytes(), "200 OK", "application/json");
            }
            if (routeMethod.isAnnotationPresent(Text.class)) {
                return new RouteResponse(methodResponse.getBytes(), "200 OK", "text/html");
            }
            if (RENDERER.equals("cache")) {
                ByteArrayOutputStream unebaos = serverResources.getViewFileCopy(methodResponse, viewBytesMap);
                if (unebaos == null) {
                    return new RouteResponse("404".getBytes(), "404", "text/html");
                }
                completePageRendered = unebaos.toString(StandardCharsets.UTF_8.name());
            } else {
                int pageBytesLength;
                Path webPath = Paths.get("src", "main", "webapp");
                if (methodResponse.startsWith("/")) {
                    methodResponse = methodResponse.replaceFirst("/", "");
                }
                String htmlPath = webPath.toFile().getAbsolutePath().concat(File.separator + methodResponse);
                File viewFile = new File(htmlPath);
                ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                FileInputStream pageInput = new FileInputStream(viewFile);
                byte[] bytes = new byte[(int)viewFile.length()];
                while ((pageBytesLength = ((InputStream)pageInput).read(bytes)) != -1) {
                    unebaos.write(bytes, 0, pageBytesLength);
                }
                completePageRendered = unebaos.toString(StandardCharsets.UTF_8.name());
            }
            String designUri = null;
            if (routeMethod.isAnnotationPresent(Design.class)) {
                Design annotation = routeMethod.getAnnotation(Design.class);
                designUri = annotation.value();
            }
            if (designUri != null) {
                String designContent;
                if (RENDERER.equals("cache")) {
                    ByteArrayOutputStream baos = serverResources.getViewFileCopy(designUri, viewBytesMap);
                    designContent = baos.toString(StandardCharsets.UTF_8.name());
                } else {
                    int length;
                    Path designPath = Paths.get("src", "main", "webapp", designUri);
                    File designFile = new File(designPath.toString());
                    FileInputStream designInput = new FileInputStream(designFile);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[(int)designFile.length()];
                    while ((length = ((InputStream)designInput).read(bytes)) != -1) {
                        baos.write(bytes, 0, length);
                    }
                    designContent = baos.toString(StandardCharsets.UTF_8.name());
                }
                if (designContent == null) {
                    return new RouteResponse("design not found.".getBytes(), "200 OK", "text/html");
                }
                if (!designContent.contains("<plsar:content/>")) {
                    return new RouteResponse("Your html template file is missing <plsar:content/>".getBytes(), "200 OK", "text/html");
                }
                String[] bits = designContent.split("<plsar:content/>");
                Object header = bits[0];
                String bottom = "";
                if (bits.length > 1) {
                    bottom = bits[1];
                }
                header = (String)header + (String)completePageRendered;
                completePageRendered = (String)header + bottom;
                if (title != null) {
                    completePageRendered = ((String)completePageRendered).replace("${title}", title);
                }
                if (keywords != null) {
                    completePageRendered = ((String)completePageRendered).replace("${keywords}", keywords);
                }
                if (description != null) {
                    completePageRendered = ((String)completePageRendered).replace("${description}", description);
                }
                completePageRendered = experienceManager.execute((String)completePageRendered, pageCache, networkRequest, viewRenderers);
                return new RouteResponse(((String)completePageRendered).getBytes(), "200 OK", "text/html");
            }
            completePageRendered = experienceManager.execute((String)completePageRendered, pageCache, networkRequest, viewRenderers);
            return new RouteResponse(((String)completePageRendered).getBytes(), "200 OK", "text/html");
        }
        catch (IllegalAccessException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (UnsupportedEncodingException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (IOException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        catch (PlsarException ex) {
            errorMessage = "<p style=\"border:solid 1px #ff0000; color:#ff0000;\">" + ex.getMessage() + "</p>";
            ex.printStackTrace();
        }
        String erroredPageRendered = (String)errorMessage + (String)completePageRendered;
        return new RouteResponse(erroredPageRendered.getBytes(), "404", "text/html");
    }

    List<Object> getRouteMethodAttributes(String routeUriPath, PageCache pageCache, NetworkRequest networkRequest, NetworkResponse networkResponse, SecurityManager securityManager, RouteEndpoint routeEndpoint) {
        ArrayList<Object> routeMethodAttributes = new ArrayList<Object>();
        Class<?>[] methodAttributes = routeEndpoint.getRouteMethod().getParameterTypes();
        String routeUriPathClean = routeUriPath.replaceFirst("/", "");
        String[] routePathUriAttributes = routeUriPathClean.split("/");
        Integer PATH_VARIABLE_INDEX = 0;
        for (int foo = 0; foo < methodAttributes.length; ++foo) {
            Class<?> methodAttribute = methodAttributes[foo];
            RouteAttribute routeAttribute = routeEndpoint.getRouteAttributes().get(foo);
            PATH_VARIABLE_INDEX = routeAttribute.getRoutePosition() != null ? routeAttribute.getRoutePosition() : 0;
            if (methodAttribute.getTypeName().equals("net.plsar.security.SecurityManager")) {
                routeMethodAttributes.add(securityManager);
            }
            if (methodAttribute.getTypeName().equals("net.plsar.model.NetworkRequest")) {
                routeMethodAttributes.add(networkRequest);
            }
            if (methodAttribute.getTypeName().equals("net.plsar.model.NetworkResponse")) {
                routeMethodAttributes.add(networkResponse);
            }
            if (methodAttribute.getTypeName().equals("net.plsar.model.PageCache")) {
                routeMethodAttributes.add(pageCache);
            }
            if (methodAttribute.getTypeName().equals("java.lang.Integer")) {
                routeMethodAttributes.add(Integer.valueOf(routePathUriAttributes[PATH_VARIABLE_INDEX]));
            }
            if (methodAttribute.getTypeName().equals("java.lang.Long")) {
                routeMethodAttributes.add(Long.valueOf(routePathUriAttributes[PATH_VARIABLE_INDEX]));
            }
            if (!methodAttribute.getTypeName().equals("java.lang.String")) continue;
            routeMethodAttributes.add(String.valueOf(routePathUriAttributes[PATH_VARIABLE_INDEX]));
        }
        return routeMethodAttributes;
    }

    boolean getRouteVariablesMatch(String routeUriPath, RouteEndpoint routeEndpoint) {
        String[] routeEndpointParts;
        String[] routeUriParts = routeUriPath.split("/");
        return routeUriParts.length == (routeEndpointParts = routeEndpoint.getRoutePath().split("/")).length;
    }

    public String getGuid() {
        return this.guid;
    }

    public RouteAttributes getRouteAttributes() {
        return this.routeAttributes;
    }

    public void setRouteAttributes(RouteAttributes routeAttributes) {
        this.routeAttributes = routeAttributes;
    }

    public ComponentsHolder getComponentsHolder() {
        return this.componentsHolder;
    }

    public void setComponentsHolder(ComponentsHolder componentsHolder) {
        this.componentsHolder = componentsHolder;
    }
}

