/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.plsar.Dao;
import net.plsar.DatabaseEnvironmentManager;
import net.plsar.PersistenceConfig;
import net.plsar.PlsarException;
import net.plsar.RouteAttributes;
import net.plsar.RouteEndpointHolder;
import net.plsar.RouteEndpointsResolver;
import net.plsar.RouteNegotiator;
import net.plsar.RouteResponse;
import net.plsar.SchemaConfig;
import net.plsar.ViewConfig;
import net.plsar.environments.Environments;
import net.plsar.model.NetworkRequest;
import net.plsar.model.NetworkResponse;
import net.plsar.model.NetworkSession;
import net.plsar.model.PageCache;
import net.plsar.model.RedirectRegistry;
import net.plsar.model.SecurityAttribute;
import net.plsar.resources.AnnotationComponent;
import net.plsar.resources.ComponentAnnotationInspector;
import net.plsar.resources.ComponentCompiler;
import net.plsar.resources.ComponentsHolder;
import net.plsar.resources.ServerResources;
import net.plsar.resources.StartupAnnotationInspector;
import net.plsar.security.SecurityAccess;
import net.plsar.security.SecurityManager;

public class PLSAR {
    static Logger Log = Logger.getLogger(PLSAR.class.getName());
    Integer port;
    String RENDERING_SCHEME;
    ViewConfig viewConfig;
    SchemaConfig schemaConfig;
    Integer numberOfPartitions = 3;
    Integer numberOfRequestExecutors = 7;
    PersistenceConfig persistenceConfig;
    Class<?> securityAccessClass;
    List<Class<?>> viewRenderers;
    static final String HTTPREQUEST = "http-request";
    static final String HTTPRESPONSE = "http-response";
    static final String CACHE = "cache";

    public PLSAR(int port) {
        this.port = port;
        this.viewConfig = new ViewConfig();
        this.viewRenderers = new ArrayList();
        this.RENDERING_SCHEME = CACHE;
    }

    public void start() {
        try {
            Integer TOTAL_NUMBER_EXECUTORS = this.numberOfPartitions * this.numberOfRequestExecutors;
            if (this.schemaConfig != null && this.schemaConfig.getEnvironment().equals(Environments.DEVELOPMENT)) {
                DatabaseEnvironmentManager databaseEnvironmentManager = new DatabaseEnvironmentManager();
                databaseEnvironmentManager.configure(this.schemaConfig, this.persistenceConfig);
            }
            ServerResources serverResources = new ServerResources();
            StartupAnnotationInspector startupAnnotationInspector = new StartupAnnotationInspector(new ComponentsHolder());
            startupAnnotationInspector.inspect();
            ComponentsHolder componentsHolder = startupAnnotationInspector.getComponentsHolder();
            AnnotationComponent routeRegistration = componentsHolder.getRouteRegistration();
            AnnotationComponent serverStartup = componentsHolder.getServerStartup();
            String resourcesDirectory = this.viewConfig.getResourcesPath();
            ConcurrentMap<String, byte[]> viewBytesMap = serverResources.getViewBytesMap(this.viewConfig);
            Log.info("Running startup routine, please wait...");
            if (serverStartup != null) {
                Method startupMethod = serverStartup.getKlass().getMethod("startup", new Class[0]);
                startupMethod.invoke(serverResources.getInstance(serverStartup.getKlass()), new Object[0]);
            }
            Log.info("Registering route negotiators, please wait...");
            List<RouteNegotiator> routeNegotiators = this.getRouteNegotiators(TOTAL_NUMBER_EXECUTORS, serverResources, routeRegistration);
            ConcurrentMap<String, RouteNegotiator> routeDirectorRegistry = this.registerRouteDirectors(routeNegotiators);
            RedirectRegistry redirectRegistry = new RedirectRegistry();
            ServerSocket serverSocket = new ServerSocket(this.port);
            serverSocket.setPerformancePreferences(0, 1, 2);
            ExecutorService executors = Executors.newFixedThreadPool(this.numberOfPartitions);
            executors.execute(new PartitionedExecutor(this.RENDERING_SCHEME, this.numberOfRequestExecutors, resourcesDirectory, viewBytesMap, serverSocket, redirectRegistry, routeDirectorRegistry, this.viewRenderers));
            Log.info("Ready!");
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PlsarException ex) {
            ex.printStackTrace();
        }
    }

    ConcurrentMap<String, RouteNegotiator> registerRouteDirectors(List<RouteNegotiator> routeNegotiators) {
        ConcurrentHashMap<String, RouteNegotiator> routeDirectorRegistry = new ConcurrentHashMap<String, RouteNegotiator>(0, 3.0f, 63010);
        for (RouteNegotiator routeNegotiator : routeNegotiators) {
            routeDirectorRegistry.put(routeNegotiator.getGuid(), routeNegotiator);
        }
        return routeDirectorRegistry;
    }

    List<RouteNegotiator> getRouteNegotiators(Integer TOTAL_NUMBER_EXECUTORS, ServerResources serverResources, AnnotationComponent routeRegistration) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ArrayList<RouteNegotiator> routeNegotiators = new ArrayList<RouteNegotiator>();
        Integer activeIndex = 0;
        while (activeIndex < TOTAL_NUMBER_EXECUTORS) {
            RouteAttributes routeAttributes = new RouteAttributes();
            if (routeRegistration != null) {
                Method startupMethod = routeRegistration.getKlass().getMethod("register", new Class[0]);
                routeAttributes = (RouteAttributes)startupMethod.invoke(serverResources.getInstance(routeRegistration.getKlass()), new Object[0]);
            }
            RouteEndpointsResolver routeEndpointsResolver = new RouteEndpointsResolver(serverResources);
            RouteEndpointHolder routeEndpointHolder = routeEndpointsResolver.resolve();
            routeAttributes.setRouteEndpointHolder(routeEndpointHolder);
            if (this.persistenceConfig != null) {
                PersistenceConfig persistenceConfig = new PersistenceConfig();
                persistenceConfig.setDriver(this.persistenceConfig.getDriver());
                persistenceConfig.setUrl(this.persistenceConfig.getUrl());
                persistenceConfig.setUser(this.persistenceConfig.getUser());
                persistenceConfig.setConnections(this.persistenceConfig.getConnections());
                persistenceConfig.setPassword(this.persistenceConfig.getPassword());
                routeAttributes.setPersistenceConfig(persistenceConfig);
            }
            if (this.securityAccessClass != null) {
                Dao dao = new Dao(this.persistenceConfig);
                SecurityAccess securityAccessInstance = (SecurityAccess)this.securityAccessClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method setPersistence = securityAccessInstance.getClass().getMethod("setDao", Dao.class);
                setPersistence.invoke((Object)securityAccessInstance, dao);
                SecurityManager securityManager = new SecurityManager(securityAccessInstance);
                routeAttributes.setSecurityManager(securityManager);
                routeAttributes.setSecurityAccess(this.securityAccessClass);
            }
            ComponentAnnotationInspector componentAnnotationInspector = new ComponentAnnotationInspector(new ComponentsHolder());
            componentAnnotationInspector.inspect();
            ComponentsHolder componentsHolder = componentAnnotationInspector.getComponentsHolder();
            RouteNegotiator routeNegotiator = new RouteNegotiator();
            routeNegotiator.setRouteAttributes(routeAttributes);
            routeNegotiator.setComponentsHolder(componentsHolder);
            routeNegotiators.add(routeNegotiator);
            Integer n = activeIndex;
            activeIndex = activeIndex + 1;
        }
        return routeNegotiators;
    }

    public void setPageRenderingScheme(String RENDERING_SCHEME) {
        this.RENDERING_SCHEME = RENDERING_SCHEME;
    }

    public void setViewConfig(ViewConfig viewConfig) {
        this.viewConfig = viewConfig;
    }

    public void setSecurityAccess(Class<?> securityAccess) {
        this.securityAccessClass = securityAccess;
    }

    public void setSchemaConfig(SchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    public void setNumberOfRequestExecutors(int numberOfRequestExecutors) {
        this.numberOfRequestExecutors = numberOfRequestExecutors;
    }

    public PLSAR addViewRenderer(Class<?> viewRenderer) {
        this.viewRenderers.add(viewRenderer);
        return this;
    }

    public PLSAR setPersistenceConfig(PersistenceConfig persistenceConfig) {
        this.persistenceConfig = persistenceConfig;
        return this;
    }

    public static class PartitionedExecutor
    implements Runnable {
        String guid;
        String RENDERER;
        String resourcesDirectory;
        Integer numberOfExecutors;
        ServerSocket serverSocket;
        ConcurrentMap<String, RouteNegotiator> routeDirectorRegistry;
        RedirectRegistry redirectRegistry;
        List<Class<?>> viewRenderers;
        ConcurrentMap<String, String> sessionRouteRegistry;
        ConcurrentMap<String, byte[]> viewBytesMap;

        public PartitionedExecutor(String RENDERER, Integer numberOfExecutors, String resourcesDirectory, ConcurrentMap<String, byte[]> viewBytesMap, ServerSocket serverSocket, RedirectRegistry redirectRegistry, ConcurrentMap<String, RouteNegotiator> routeDirectorRegistry, List<Class<?>> viewRenderers) {
            Random random = new Random();
            this.RENDERER = RENDERER;
            this.viewBytesMap = viewBytesMap;
            this.numberOfExecutors = numberOfExecutors;
            this.serverSocket = serverSocket;
            this.redirectRegistry = redirectRegistry;
            this.routeDirectorRegistry = routeDirectorRegistry;
            this.viewRenderers = viewRenderers;
            this.guid = String.valueOf(random.nextFloat());
            this.resourcesDirectory = resourcesDirectory;
            this.sessionRouteRegistry = new ConcurrentHashMap<String, String>();
        }

        @Override
        public void run() {
            ExecutorService executors = Executors.newFixedThreadPool(this.numberOfExecutors);
            executors.execute(new NetworkRequestExecutor(this.RENDERER, this.resourcesDirectory, this.viewBytesMap, executors, this.serverSocket, this.redirectRegistry, this.sessionRouteRegistry, this.routeDirectorRegistry, this.viewRenderers));
        }
    }

    public static class NetworkRequestExecutor
    implements Runnable {
        final String IGNORE_CHROME = "/favicon.ico";
        final String BREAK = "\r\n";
        final String SPACE = " ";
        final String DOUBLEBREAK = "\r\n\r\n";
        final Integer REQUEST_METHOD = 0;
        final Integer REQUEST_PATH = 1;
        final Integer REQUEST_VERSION = 2;
        String RENDERER;
        String resourcesDirectory;
        Socket socketClient;
        ExecutorService executors;
        ServerSocket serverSocket;
        ConcurrentMap<String, String> sessionRouteRegistry;
        ConcurrentMap<String, RouteNegotiator> routeDirectorRegistry;
        RedirectRegistry redirectRegistry;
        List<Class<?>> viewRenderers;
        ConcurrentMap<String, byte[]> viewBytesMap;

        public NetworkRequestExecutor(String RENDERER, String resourcesDirectory, ConcurrentMap<String, byte[]> viewBytesMap, ExecutorService executors, ServerSocket serverSocket, RedirectRegistry redirectRegistry, ConcurrentMap<String, String> sessionRouteRegistry, ConcurrentMap<String, RouteNegotiator> routeDirectorRegistry, List<Class<?>> viewRenderers) {
            this.RENDERER = RENDERER;
            this.resourcesDirectory = resourcesDirectory;
            this.viewBytesMap = viewBytesMap;
            this.executors = executors;
            this.serverSocket = serverSocket;
            this.redirectRegistry = redirectRegistry;
            this.sessionRouteRegistry = sessionRouteRegistry;
            this.routeDirectorRegistry = routeDirectorRegistry;
            this.viewRenderers = viewRenderers;
        }

        @Override
        public void run() {
            try {
                NetworkSession activeNetworkSession;
                String[] headerComponents;
                int bytesRead;
                ServerResources serverResources = new ServerResources();
                this.socketClient = this.serverSocket.accept();
                Thread.sleep(19L);
                InputStream requestInputStream = this.socketClient.getInputStream();
                OutputStream clientOutput = this.socketClient.getOutputStream();
                if (requestInputStream.available() == 0) {
                    requestInputStream.close();
                    clientOutput.flush();
                    clientOutput.close();
                    this.executors.execute(new NetworkRequestExecutor(this.RENDERER, this.resourcesDirectory, this.viewBytesMap, this.executors, this.serverSocket, this.redirectRegistry, this.sessionRouteRegistry, this.routeDirectorRegistry, this.viewRenderers));
                    return;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                while ((bytesRead = requestInputStream.read(byteBuffer.array())) != -1) {
                    byteArrayOutputStream.write(byteBuffer.array(), 0, bytesRead);
                    if (requestInputStream.available() != 0) continue;
                }
                String completeRequestContent = byteArrayOutputStream.toString();
                String[] requestBlocks = completeRequestContent.split("\r\n\r\n", 2);
                String headerComponent = requestBlocks[0];
                String[] methodPathComponentsLookup = headerComponent.split("\r\n");
                String methodPathComponent = methodPathComponentsLookup[0];
                String[] methodPathVersionComponents = methodPathComponent.split("\\s");
                String requestVerb = methodPathVersionComponents[this.REQUEST_METHOD];
                String requestPath = methodPathVersionComponents[this.REQUEST_PATH];
                String requestVersion = methodPathVersionComponents[this.REQUEST_VERSION];
                NetworkRequest networkRequest = new NetworkRequest(requestVerb, requestPath, serverResources);
                Integer attributesIdx = requestPath.indexOf("?");
                if (attributesIdx != -1) {
                    String attributesElement = requestPath.substring(attributesIdx + 1);
                    requestPath = requestPath.substring(0, attributesIdx);
                    networkRequest.setValues(attributesElement);
                    networkRequest.setUriPath(requestPath);
                }
                if (networkRequest.getUriPath().equals("/favicon.ico")) {
                    requestInputStream.close();
                    clientOutput.flush();
                    clientOutput.close();
                    this.executors.execute(new NetworkRequestExecutor(this.RENDERER, this.resourcesDirectory, this.viewBytesMap, this.executors, this.serverSocket, this.redirectRegistry, this.sessionRouteRegistry, this.routeDirectorRegistry, this.viewRenderers));
                    return;
                }
                NetworkResponse networkResponse = new NetworkResponse();
                networkResponse.setResponseStream(clientOutput);
                ComponentCompiler requestComponentCompiler = new ComponentCompiler(byteArrayOutputStream.toByteArray(), networkRequest);
                requestComponentCompiler.ingestRequest();
                for (String headerLine : headerComponents = headerComponent.split("\r\n")) {
                    String[] headerLineComponents = headerLine.split(":");
                    if (headerLineComponents.length != 2) continue;
                    String fieldKey = headerLineComponents[0].trim();
                    String content = headerLineComponents[1].trim();
                    networkRequest.getHeaders().put(fieldKey.toLowerCase(), content);
                }
                Long time = serverResources.getTime(0);
                String sessionGuid = serverResources.getCookie(networkRequest.getHeaders());
                if (sessionGuid == null) {
                    sessionGuid = serverResources.getGuid(24);
                }
                String routeDirectorGuid = (String)this.sessionRouteRegistry.get(sessionGuid);
                RouteNegotiator routeNegotiator = null;
                if (routeDirectorGuid != null) {
                    routeNegotiator = (RouteNegotiator)this.routeDirectorRegistry.get(routeDirectorGuid);
                }
                if (routeNegotiator == null) {
                    routeNegotiator = this.getRouteDirector(this.routeDirectorRegistry);
                }
                if ((activeNetworkSession = (NetworkSession)routeNegotiator.getRouteAttributes().getSessions().get(sessionGuid)) == null) {
                    activeNetworkSession = new NetworkSession(time, sessionGuid);
                }
                networkRequest.setSession(activeNetworkSession);
                PageCache pageCache = new PageCache();
                routeDirectorGuid = routeNegotiator.getGuid();
                if (this.redirectRegistry.getRegistry().containsKey(routeDirectorGuid) && ((Map)this.redirectRegistry.getRegistry().get(routeDirectorGuid)).containsKey(PLSAR.HTTPREQUEST)) {
                    NetworkRequest storedNetworkRequest = (NetworkRequest)((Map)this.redirectRegistry.getRegistry().get(routeDirectorGuid)).get(PLSAR.HTTPREQUEST);
                    networkResponse = (NetworkResponse)((Map)this.redirectRegistry.getRegistry().get(routeDirectorGuid)).get(PLSAR.HTTPRESPONSE);
                    pageCache = (PageCache)((Map)this.redirectRegistry.getRegistry().get(routeDirectorGuid)).get(PLSAR.CACHE);
                    activeNetworkSession = storedNetworkRequest.getSession(true);
                    networkRequest.setSession(activeNetworkSession);
                    networkRequest.setVerb("get");
                }
                this.setSessionAttributesCache(pageCache, activeNetworkSession);
                RouteAttributes routeAttributes = routeNegotiator.getRouteAttributes();
                networkRequest.setRouteAttributes(routeAttributes);
                SecurityManager securityManager = routeAttributes.getSecurityManager();
                RouteResponse routeResponse = routeNegotiator.negotiate(this.RENDERER, this.resourcesDirectory, pageCache, networkRequest, networkResponse, securityManager, this.viewRenderers, this.viewBytesMap);
                sessionGuid = networkRequest.getSession(true).getGuid();
                if (!routeNegotiator.getRouteAttributes().getSessions().containsKey(sessionGuid)) {
                    routeNegotiator.getRouteAttributes().getSessions().put(sessionGuid, activeNetworkSession);
                } else {
                    routeNegotiator.getRouteAttributes().getSessions().replace(sessionGuid, activeNetworkSession);
                }
                this.sessionRouteRegistry.put(sessionGuid, routeNegotiator.getGuid());
                this.routeDirectorRegistry.replace(routeNegotiator.getGuid(), routeNegotiator);
                StringBuilder sessionValues = new StringBuilder();
                sessionValues.append(serverResources.getSessionId()).append("=").append(networkRequest.getSession(true).getGuid() + "; path=/;");
                for (SecurityAttribute securityAttribute : networkResponse.getSecurityAttributes()) {
                    sessionValues.append(securityAttribute.getName()).append("=").append(securityAttribute.getValue());
                }
                String redirectLocation = networkResponse.getRedirectLocation();
                if (redirectLocation == null || redirectLocation.equals("")) {
                    this.redirectRegistry.getRegistry().remove(routeDirectorGuid);
                    clientOutput.write("HTTP/1.1 ".getBytes());
                    clientOutput.write(routeResponse.getResponseCode().getBytes());
                    clientOutput.write("\r\n".getBytes());
                    Integer bytesLength = routeResponse.getResponseBytes().length;
                    byte[] contentLengthBytes = ("Content-Length:" + bytesLength + "\r\n").getBytes();
                    clientOutput.write(contentLengthBytes);
                    clientOutput.write("Content-Type:".getBytes());
                    clientOutput.write(routeResponse.getContentType().getBytes());
                    clientOutput.write("\r\n".getBytes());
                    clientOutput.write("Set-Cookie:".getBytes());
                    clientOutput.write(sessionValues.toString().getBytes());
                    clientOutput.write("\r\n\r\n".getBytes());
                    clientOutput.write(routeResponse.getResponseBytes());
                } else {
                    HashMap<String, Object> redirectAttributes = new HashMap<String, Object>();
                    redirectAttributes.put(PLSAR.HTTPREQUEST, networkRequest);
                    redirectAttributes.put(PLSAR.HTTPRESPONSE, networkResponse);
                    redirectAttributes.put(PLSAR.CACHE, pageCache);
                    this.redirectRegistry.getRegistry().put(routeDirectorGuid, redirectAttributes);
                    StringBuilder response = new StringBuilder();
                    response.append("HTTP/1.1 307\r\n");
                    response.append("Content-Type:text/html\r\n");
                    response.append("Location:" + redirectLocation + " \r\n");
                    response.append("Content-Length: -1\r\n");
                    networkResponse.removeRedirectLocation();
                    clientOutput.write(response.toString().getBytes());
                }
                clientOutput.close();
                this.socketClient.close();
                this.executors.execute(new NetworkRequestExecutor(this.RENDERER, this.resourcesDirectory, this.viewBytesMap, this.executors, this.serverSocket, this.redirectRegistry, this.sessionRouteRegistry, this.routeDirectorRegistry, this.viewRenderers));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ioException) {
                ioException.printStackTrace();
            }
        }

        void setSessionAttributesCache(PageCache pageCache, NetworkSession networkSession) {
            for (Map.Entry<String, Object> sessionEntry : networkSession.getAttributes().entrySet()) {
                pageCache.set(sessionEntry.getKey(), sessionEntry.getValue());
            }
        }

        void clearRedirectRegistry(String routeDirectorGuid) {
            ArrayList<String> redirectKeys = new ArrayList<String>();
            if (this.redirectRegistry.getRegistry().containsKey(routeDirectorGuid)) {
                for (Map.Entry redirectEntry : ((Map)this.redirectRegistry.getRegistry().get(routeDirectorGuid)).entrySet()) {
                    redirectKeys.add((String)redirectEntry.getKey());
                }
                for (String redirectKey : redirectKeys) {
                    ((Map)this.redirectRegistry.getRegistry().get(routeDirectorGuid)).remove(redirectKey);
                }
            }
        }

        RouteNegotiator getRouteDirector(ConcurrentMap<String, RouteNegotiator> routeDirectorRegistry) {
            Iterator iterator = routeDirectorRegistry.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry routeDirectorEntry = iterator.next();
                return (RouteNegotiator)routeDirectorEntry.getValue();
            }
            return null;
        }
    }
}

