/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.plsar.PlsarException;
import net.plsar.model.DataPartial;
import net.plsar.model.IterableResult;
import net.plsar.model.LineComponent;
import net.plsar.model.NetworkRequest;
import net.plsar.model.ObjectComponent;
import net.plsar.model.PageCache;

public class ExperienceManager {
    final Integer ZERO = 0;
    final Integer ONE = 1;
    final String DOT = "\\.";
    final String NEWLINE = "\n";
    final String LOCATOR = "\\$\\{[a-zA-Z+\\.+\\(\\a-zA-Z+)]*\\}";
    final String FOREACH = "<plsar:foreach";
    final String ENDEACH = "</plsar:foreach>";
    final String IFSPEC = "<plsar:if";
    final String ENDIF = "</plsar:if>";
    final String SETVAR = "<plsar:set";
    final String OPENSPEC = "<plsar:if spec=\"${";
    final String ENDSPEC = "}";
    final String COMMENT = "<%--";
    final String HTML_COMMENT = "<!--";

    public String execute(String pageElement, PageCache pageCache, NetworkRequest req, List<Class<?>> viewRenderers) throws PlsarException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        List<String> elementEntries = Arrays.asList(pageElement.split("\n"));
        List<String> viewRendererElementEntries = this.getInterpretedRenderers(req, elementEntries, viewRenderers);
        List<DataPartial> dataPartials = this.getConvertedDataPartials(viewRendererElementEntries);
        List<DataPartial> dataPartialsInflated = this.getInflatedPartials(dataPartials, pageCache);
        List<DataPartial> dataPartialsComplete = this.getCompletedPartials(dataPartialsInflated, pageCache);
        List<DataPartial> dataPartialsCompleteReady = this.getNilElementEntryPartials(dataPartialsComplete);
        StringBuilder pageElementsComplete = this.getElementsCompleted(dataPartialsCompleteReady);
        return pageElementsComplete.toString();
    }

    List<DataPartial> getNilElementEntryPartials(List<DataPartial> dataPartialsComplete) {
        ArrayList<DataPartial> dataPartialsCompleteReady = new ArrayList<DataPartial>();
        for (DataPartial dataPartial : dataPartialsComplete) {
            String elementEntry = dataPartial.getEntry();
            Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z+\\.+\\(\\a-zA-Z+)]*\\}");
            Matcher matcher = pattern.matcher(elementEntry);
            while (matcher.find()) {
                String element = matcher.group();
                String regexElement = element.replace("${", "\\$\\{").replace("}", "\\}").replace(".", "\\.");
                String elementEntryComplete = elementEntry.replaceAll(regexElement, "");
                dataPartial.setEntry(elementEntryComplete);
            }
            dataPartialsCompleteReady.add(dataPartial);
        }
        return dataPartialsCompleteReady;
    }

    StringBuilder getElementsCompleted(List<DataPartial> dataPartialsComplete) {
        StringBuilder builder = new StringBuilder();
        for (DataPartial dataPartial : dataPartialsComplete) {
            if (dataPartial.getEntry().equals("") || dataPartial.getEntry().contains("<plsar:set")) continue;
            builder.append(dataPartial.getEntry() + "\n");
        }
        return builder;
    }

    void setResponseVariable(String baseEntry, PageCache resp) {
        int startVariableIdx = baseEntry.indexOf("var=");
        int endVariableIdx = baseEntry.indexOf("\"", startVariableIdx + 5);
        String variableEntry = baseEntry.substring(startVariableIdx + 5, endVariableIdx);
        int startValueIdx = baseEntry.indexOf("val=");
        int endValueIdx = baseEntry.indexOf("\"", startValueIdx + 5);
        String valueEntry = baseEntry.substring(startValueIdx + 5, endValueIdx);
        resp.set(variableEntry, valueEntry);
    }

    List<DataPartial> getConvertedDataPartials(List<String> elementEntries) {
        ArrayList<DataPartial> dataPartials = new ArrayList<DataPartial>();
        for (String elementEntry : elementEntries) {
            if (elementEntry.contains("<%--") || elementEntry.contains("<!--")) continue;
            DataPartial dataPartial = new DataPartial();
            dataPartial.setEntry(elementEntry);
            if (elementEntry.contains(this.FOREACH)) {
                dataPartial.setIterable(true);
            } else if (elementEntry.contains(this.IFSPEC)) {
                dataPartial.setSpec(true);
            } else if (elementEntry.contains(this.ENDEACH)) {
                dataPartial.setEndIterable(true);
            } else if (elementEntry.contains(this.ENDIF)) {
                dataPartial.setEndSpec(true);
            } else if (elementEntry.contains("<plsar:set")) {
                dataPartial.setSetVar(true);
            }
            dataPartials.add(dataPartial);
        }
        return dataPartials;
    }

    List<String> getInterpretedRenderers(NetworkRequest req, List<String> elementEntries, List<Class<?>> viewRenderers) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        for (Class<?> viewRendererKlass : viewRenderers) {
            Object viewRendererInstance = viewRendererKlass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method getKey = viewRendererInstance.getClass().getDeclaredMethod("getKey", new Class[0]);
            String rendererKey = (String)getKey.invoke(viewRendererInstance, new Object[0]);
            String openRendererKey = "<" + rendererKey + ">";
            String completeRendererKey = "<" + rendererKey + "/>";
            String endRendererKey = "</" + rendererKey + ">";
            for (int tao = 0; tao < elementEntries.size(); ++tao) {
                String elementEntryDeux;
                int moa;
                String elementEntry = elementEntries.get(tao);
                Method isEval = viewRendererInstance.getClass().getDeclaredMethod("isEval", new Class[0]);
                Method truthy = viewRendererInstance.getClass().getDeclaredMethod("truthy", NetworkRequest.class);
                if (((Boolean)isEval.invoke(viewRendererInstance, new Object[0])).booleanValue() && elementEntry.contains(openRendererKey) && ((Boolean)truthy.invoke(viewRendererInstance, req)).booleanValue()) {
                    for (moa = tao; moa < elementEntries.size(); ++moa) {
                        elementEntryDeux = elementEntries.get(moa);
                        elementEntries.set(moa, elementEntryDeux);
                        if (elementEntryDeux.contains(endRendererKey)) break;
                    }
                }
                if (((Boolean)isEval.invoke(viewRendererInstance, new Object[0])).booleanValue() && elementEntry.contains(openRendererKey) && !((Boolean)truthy.invoke(viewRendererInstance, req)).booleanValue()) {
                    for (moa = tao; moa < elementEntries.size(); ++moa) {
                        elementEntryDeux = elementEntries.get(moa);
                        elementEntries.set(moa, "");
                        if (elementEntryDeux.contains(endRendererKey)) break;
                    }
                }
                if (((Boolean)isEval.invoke(viewRendererInstance, new Object[0])).booleanValue() || !elementEntry.contains(completeRendererKey)) continue;
                Method render = viewRendererInstance.getClass().getDeclaredMethod("render", NetworkRequest.class);
                String rendered = (String)render.invoke(viewRendererInstance, req);
                elementEntries.set(tao, rendered);
            }
        }
        return elementEntries;
    }

    List<DataPartial> getCompletedPartials(List<DataPartial> dataPartialsPre, PageCache resp) throws InvocationTargetException, NoSuchMethodException, PlsarException, NoSuchFieldException, IllegalAccessException {
        ArrayList<DataPartial> dataPartials = new ArrayList<DataPartial>();
        for (DataPartial dataPartial : dataPartialsPre) {
            DataPartial completePartial;
            if (!dataPartial.getSpecPartials().isEmpty()) {
                String entryBase;
                boolean passesRespSpecsIterations = true;
                boolean passesObjectSpecsIterations = true;
                block1: for (DataPartial specPartial : dataPartial.getSpecPartials()) {
                    if (!dataPartial.getComponents().isEmpty()) {
                        for (ObjectComponent objectComponent : dataPartial.getComponents()) {
                            Object object = objectComponent.getObject();
                            if (this.passesSpec(object, specPartial, dataPartial, resp)) continue;
                            passesObjectSpecsIterations = false;
                            break block1;
                        }
                        continue;
                    }
                    if (this.passesSpec(specPartial, resp)) continue;
                    passesRespSpecsIterations = false;
                }
                if (dataPartial.getComponents().isEmpty()) {
                    if (!passesRespSpecsIterations) continue;
                    entryBase = dataPartial.getEntry();
                    if (!dataPartial.isSetVar()) {
                        List<LineComponent> lineComponents = this.getPageLineComponents(entryBase);
                        String entryBaseComplete = this.getCompleteLineElementResponse(entryBase, lineComponents, resp);
                        DataPartial completePartial2 = new DataPartial(entryBaseComplete);
                        dataPartials.add(completePartial2);
                        continue;
                    }
                    this.setResponseVariable(entryBase, resp);
                    continue;
                }
                if (!passesObjectSpecsIterations || dataPartial.getComponents().isEmpty()) continue;
                entryBase = dataPartial.getEntry();
                for (ObjectComponent objectComponent : dataPartial.getComponents()) {
                    Object object = objectComponent.getObject();
                    String activeField = objectComponent.getActiveField();
                    if (!dataPartial.isSetVar()) {
                        entryBase = this.getCompleteLineElementObject(activeField, object, entryBase, resp);
                        continue;
                    }
                    this.setResponseVariable(entryBase, resp);
                }
                completePartial = new DataPartial(entryBase);
                dataPartials.add(completePartial);
                continue;
            }
            if (dataPartial.isWithinIterable()) {
                String entryBase = dataPartial.getEntry();
                if (!dataPartial.isSetVar()) {
                    String entryBaseComplete = this.getCompleteInflatedDataPartial(dataPartial, resp);
                    DataPartial completePartial3 = new DataPartial(entryBaseComplete);
                    dataPartials.add(completePartial3);
                    continue;
                }
                this.setResponseVariable(entryBase, resp);
                continue;
            }
            String entryBase = dataPartial.getEntry();
            if (!dataPartial.isSetVar()) {
                List<LineComponent> lineComponents = this.getPageLineComponents(entryBase);
                String entryBaseComplete = this.getCompleteLineElementResponse(entryBase, lineComponents, resp);
                completePartial = new DataPartial(entryBaseComplete);
                dataPartials.add(completePartial);
                continue;
            }
            this.setResponseVariable(entryBase, resp);
        }
        return dataPartials;
    }

    String getCompleteLineElementObject(String activeField, Object object, String entryBase, PageCache resp) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List<LineComponent> lineComponents = this.getPageLineComponents(entryBase);
        ArrayList<LineComponent> iteratedLineComponents = new ArrayList<LineComponent>();
        for (LineComponent lineComponent : lineComponents) {
            if (activeField.equals(lineComponent.getActiveField())) {
                String objectField = lineComponent.getObjectField();
                String objectValue = this.getObjectValueForLineComponent(objectField, object);
                if (objectValue != null) {
                    String lineElement = lineComponent.getCompleteLineElement();
                    entryBase = entryBase.replaceAll(lineElement, objectValue);
                    lineComponent.setIterated(true);
                } else {
                    lineComponent.setIterated(false);
                }
            }
            iteratedLineComponents.add(lineComponent);
        }
        String entryBaseComplete = this.getCompleteLineElementResponse(entryBase, iteratedLineComponents, resp);
        return entryBaseComplete;
    }

    String getCompleteInflatedDataPartial(DataPartial dataPartial, PageCache resp) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String entryBase = dataPartial.getEntry();
        List<LineComponent> lineComponents = this.getPageLineComponents(entryBase);
        ArrayList<LineComponent> iteratedLineComponents = new ArrayList<LineComponent>();
        for (ObjectComponent objectComponent : dataPartial.getComponents()) {
            Object object = objectComponent.getObject();
            String activeField = objectComponent.getActiveField();
            for (LineComponent lineComponent : lineComponents) {
                if (activeField.equals(lineComponent.getActiveField())) {
                    String objectField = lineComponent.getObjectField();
                    String objectValue = this.getObjectValueForLineComponent(objectField, object);
                    if (objectValue != null) {
                        String lineElement = lineComponent.getCompleteLineElement();
                        entryBase = entryBase.replaceAll(lineElement, objectValue);
                        lineComponent.setIterated(true);
                    } else {
                        lineComponent.setIterated(false);
                    }
                }
                iteratedLineComponents.add(lineComponent);
            }
        }
        String entryBaseComplete = this.getCompleteLineElementResponse(entryBase, iteratedLineComponents, resp);
        return entryBaseComplete;
    }

    String getCompleteLineElementResponse(String entryBase, List<LineComponent> lineComponents, PageCache resp) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (LineComponent lineComponent : lineComponents) {
            Object lineElement;
            String objectValueClean;
            String objectField;
            String activeObjectField = lineComponent.getActiveField();
            String objectValue = this.getResponseValueLineComponent(activeObjectField, objectField = lineComponent.getObjectField(), resp);
            String string = objectValueClean = objectValue != null ? objectValue.replace("${", "\\$\\{").replace("}", "\\}") : "";
            if (objectValue != null && objectField.contains("(")) {
                lineElement = "\\$\\{" + lineComponent.getLineElement().replace("(", "\\(").replace(")", "\\)") + "\\}";
                entryBase = entryBase.replaceAll((String)lineElement, objectValue);
                continue;
            }
            if (objectValue == null || objectValue.contains("(")) continue;
            lineElement = lineComponent.getCompleteLineElement();
            entryBase = entryBase.replaceAll((String)lineElement, objectValueClean);
        }
        return entryBase;
    }

    List<DataPartial> getInflatedPartials(List<DataPartial> dataPartials, PageCache resp) throws NoSuchFieldException, IllegalAccessException, PlsarException {
        ArrayList<DataPartial> dataPartialsPre = new ArrayList<DataPartial>();
        for (int tao = 0; tao < dataPartials.size(); ++tao) {
            DataPartial dataPartial = dataPartials.get(tao);
            String basicEntry = dataPartial.getEntry();
            DataPartial dataPartialSies = new DataPartial();
            dataPartialSies.setEntry(basicEntry);
            dataPartialSies.setSetVar(dataPartial.isSetVar());
            if (dataPartial.isIterable()) {
                dataPartialSies.setWithinIterable(true);
                IterableResult iterableResult = this.getIterableResult(basicEntry, resp);
                List<DataPartial> iterablePartials = this.getIterablePartials(tao + 1, dataPartials);
                List<Object> objects = iterableResult.getMojos();
                for (int foo = 0; foo < objects.size(); ++foo) {
                    Object object = objects.get(foo);
                    ObjectComponent component = new ObjectComponent();
                    component.setActiveField(iterableResult.getField());
                    component.setObject(object);
                    ArrayList<ObjectComponent> objectComponents = new ArrayList<ObjectComponent>();
                    objectComponents.add(component);
                    for (int beta = 0; beta < iterablePartials.size(); ++beta) {
                        DataPartial dataPartialDeux = iterablePartials.get(beta);
                        String basicEntryDeux = dataPartialDeux.getEntry();
                        DataPartial dataPartialCinq = new DataPartial();
                        dataPartialCinq.setEntry(basicEntryDeux);
                        dataPartialCinq.setWithinIterable(true);
                        dataPartialCinq.setComponents(objectComponents);
                        dataPartialCinq.setField(iterableResult.getField());
                        dataPartialCinq.setSetVar(dataPartialDeux.isSetVar());
                        if (dataPartialDeux.isIterable()) {
                            IterableResult iterableResultDeux = this.getIterableResultNested(basicEntryDeux, object);
                            List<DataPartial> iterablePartialsDeux = this.getIterablePartialsNested(beta + 1, iterablePartials);
                            List<Object> pojosDeux = iterableResultDeux.getMojos();
                            for (int tai = 0; tai < pojosDeux.size(); ++tai) {
                                Object objectDeux = pojosDeux.get(tai);
                                ObjectComponent componentDeux = new ObjectComponent();
                                componentDeux.setActiveField(iterableResult.getField());
                                componentDeux.setObject(object);
                                ObjectComponent componentTrois = new ObjectComponent();
                                componentTrois.setActiveField(iterableResultDeux.getField());
                                componentTrois.setObject(objectDeux);
                                ArrayList<ObjectComponent> objectComponentsDeux = new ArrayList<ObjectComponent>();
                                objectComponentsDeux.add(componentDeux);
                                objectComponentsDeux.add(componentTrois);
                                for (int chi = 0; chi < iterablePartialsDeux.size(); ++chi) {
                                    DataPartial dataPartialTrois = iterablePartialsDeux.get(chi);
                                    DataPartial dataPartialQuatre = new DataPartial();
                                    dataPartialQuatre.setEntry(dataPartialTrois.getEntry());
                                    dataPartialQuatre.setWithinIterable(true);
                                    dataPartialQuatre.setComponents(objectComponentsDeux);
                                    dataPartialQuatre.setField(iterableResultDeux.getField());
                                    dataPartialQuatre.setSetVar(dataPartialTrois.isSetVar());
                                    if (this.isPeripheralPartial(dataPartialTrois)) continue;
                                    List<DataPartial> specPartials = this.getSpecPartials(dataPartialTrois, dataPartials);
                                    dataPartialQuatre.setSpecPartials(specPartials);
                                    dataPartialsPre.add(dataPartialQuatre);
                                }
                            }
                            continue;
                        }
                        if (this.isPeripheralPartial(dataPartialDeux) || !this.isTrailingPartialNested(beta, iterablePartials) && this.withinIterable(dataPartialDeux, iterablePartials)) continue;
                        List<DataPartial> specPartials = this.getSpecPartials(dataPartialDeux, dataPartials);
                        dataPartialCinq.setSpecPartials(specPartials);
                        dataPartialsPre.add(dataPartialCinq);
                    }
                }
                continue;
            }
            if (this.isPeripheralPartial(dataPartial) || !this.isTrailingPartial(tao, dataPartials) && this.withinIterable(dataPartial, dataPartials)) continue;
            List<DataPartial> specPartials = this.getSpecPartials(dataPartial, dataPartials);
            dataPartialSies.setSpecPartials(specPartials);
            dataPartialSies.setWithinIterable(false);
            dataPartialsPre.add(dataPartialSies);
        }
        return dataPartialsPre;
    }

    boolean isTrailingPartialNested(int tao, List<DataPartial> dataPartials) {
        Integer openCount = 0;
        Integer endCount = 0;
        Integer endIdx = 0;
        for (int tai = 0; tai < dataPartials.size(); ++tai) {
            Integer n;
            DataPartial dataPartial = dataPartials.get(tai);
            if (dataPartial.isIterable()) {
                n = openCount;
                openCount = openCount + 1;
            }
            if (!dataPartial.isEndIterable()) continue;
            n = endCount;
            endCount = endCount + 1;
            endIdx = tai;
        }
        return openCount == 1 && openCount == endCount && tao > endIdx;
    }

    boolean isTrailingPartial(int chi, List<DataPartial> dataPartials) {
        Integer openCount = 0;
        Integer endIdx = 0;
        for (int tai = 0; tai < dataPartials.size(); ++tai) {
            DataPartial dataPartial = dataPartials.get(tai);
            if (dataPartial.isIterable()) {
                Integer n = openCount;
                openCount = openCount + 1;
            }
            if (!dataPartial.isEndIterable()) continue;
            endIdx = tai;
        }
        return openCount != 0 && chi > endIdx;
    }

    boolean isPeripheralPartial(DataPartial dataPartial) {
        return dataPartial.isSpec() || dataPartial.isIterable() || dataPartial.isEndSpec() || dataPartial.isEndIterable();
    }

    List<DataPartial> getSpecPartials(DataPartial dataPartialLocator, List<DataPartial> dataPartials) {
        HashSet<DataPartial> specPartials = new HashSet<DataPartial>();
        for (int tao = 0; tao < dataPartials.size(); ++tao) {
            int openCount = 0;
            int endCount = 0;
            DataPartial dataPartial = dataPartials.get(tao);
            if (dataPartial.isSpec()) {
                ++openCount;
                for (int chao = tao; chao < dataPartials.size(); ++chao) {
                    DataPartial dataPartialDeux = dataPartials.get(chao);
                    if (dataPartialDeux.getGuid().equals(dataPartial.getGuid())) continue;
                    if (dataPartialLocator.getGuid().equals(dataPartialDeux.getGuid())) break;
                    if (dataPartialDeux.isEndSpec()) {
                        ++endCount;
                    }
                    if (dataPartialDeux.isSpec()) {
                        ++openCount;
                    }
                    if (openCount == endCount) break;
                }
            }
            if (dataPartialLocator.getGuid().equals(dataPartial.getGuid())) break;
            if (openCount <= endCount) continue;
            specPartials.add(dataPartial);
        }
        ArrayList<DataPartial> specPartialsReady = new ArrayList<DataPartial>(specPartials);
        return specPartialsReady;
    }

    List<DataPartial> getIterablePartials(int openIdx, List<DataPartial> dataPartials) throws PlsarException {
        Integer openCount = 1;
        Integer endCount = 0;
        ArrayList<DataPartial> dataPartialsDeux = new ArrayList<DataPartial>();
        for (int foo = openIdx; foo < dataPartials.size(); ++foo) {
            Integer n;
            DataPartial dataPartial = dataPartials.get(foo);
            if (dataPartial.isIterable()) {
                n = openCount;
                openCount = openCount + 1;
            }
            if (dataPartial.isEndIterable()) {
                n = endCount;
                endCount = endCount + 1;
            }
            if (openCount != 0 && openCount == endCount) break;
            dataPartialsDeux.add(dataPartial);
        }
        return dataPartialsDeux;
    }

    List<DataPartial> getIterablePartialsNested(int openIdx, List<DataPartial> dataPartials) throws PlsarException {
        ArrayList<DataPartial> dataPartialsDeux = new ArrayList<DataPartial>();
        Integer endIdx = this.getEndEach(openIdx, dataPartials);
        for (int foo = openIdx; foo < endIdx; ++foo) {
            DataPartial basePartial = dataPartials.get(foo);
            dataPartialsDeux.add(basePartial);
        }
        return dataPartialsDeux;
    }

    int getEndEach(int openIdx, List<DataPartial> basePartials) throws PlsarException {
        Integer openEach = 1;
        Integer endEach = 0;
        for (int qxro = openIdx + 1; qxro < basePartials.size(); ++qxro) {
            DataPartial basePartial = basePartials.get(qxro);
            String basicEntry = basePartial.getEntry();
            if (basicEntry.contains(this.ENDEACH)) {
                Integer n = endEach;
                endEach = endEach + 1;
            }
            if (openEach > 3) {
                throw new PlsarException("too many nested <plsar:foreach>.");
            }
            if (!basicEntry.contains(this.ENDEACH) || endEach != openEach || endEach == 0) continue;
            return qxro + 1;
        }
        throw new PlsarException("missing end </plsar:foreach>");
    }

    boolean withinIterable(DataPartial dataPartial, List<DataPartial> dataPartials) {
        int openCount = 0;
        int endCount = 0;
        for (DataPartial it : dataPartials) {
            if (it.isIterable()) {
                ++openCount;
            }
            if (it.isEndIterable()) {
                ++endCount;
            }
            if (!it.getGuid().equals(dataPartial.getGuid())) continue;
            break;
        }
        if (openCount == 1 && endCount == 0) {
            return true;
        }
        if (openCount == 2 && endCount == 1) {
            return true;
        }
        return openCount == 2 && endCount == 0;
    }

    boolean passesIterableSpec(DataPartial specPartial, Object activeObject, PageCache resp) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String[] activeSubjectFieldElements;
        String specElementEntry = specPartial.getEntry();
        int startExpression = specElementEntry.indexOf("<plsar:if spec=\"${");
        int endExpression = specElementEntry.indexOf("}");
        String expressionElement = specElementEntry.substring(startExpression + "<plsar:if spec=\"${".length(), endExpression);
        String conditionalElement = this.getConditionalElement(expressionElement);
        if (conditionalElement.equals("")) {
            return false;
        }
        String[] expressionElements = expressionElement.split(conditionalElement);
        String subjectElement = expressionElements[this.ZERO].trim();
        String[] subjectFieldElements = subjectElement.split("\\.", 2);
        String activeSubjectFieldElement = subjectFieldElements[this.ZERO];
        String activeSubjectFieldsElement = subjectFieldElements[this.ONE];
        String predicateElement = expressionElements[this.ONE].trim();
        Object activeSubjectObject = activeObject;
        if (activeSubjectFieldsElement.contains("()")) {
            String activeMethodName = activeSubjectFieldsElement.replace("()", "");
            Object activeMethodObject = resp.get(activeSubjectFieldElement);
            if (activeMethodObject == null) {
                return false;
            }
            Method activeMethod = activeMethodObject.getClass().getMethod(activeMethodName, new Class[0]);
            activeMethod.setAccessible(true);
            Object activeObjectValue = activeMethod.invoke(activeMethodObject, new Object[0]);
            if (activeObjectValue == null) {
                return false;
            }
            String subjectValue = String.valueOf(activeObjectValue);
            Integer subjectNumericValue = Integer.parseInt(subjectValue);
            String string = predicateElement.replaceAll("'", "");
            Integer predicateNumericValue = Integer.parseInt(string);
            boolean passesSpecification = this.getValidation(subjectNumericValue, predicateNumericValue, conditionalElement, expressionElement);
            return passesSpecification;
        }
        for (String activeFieldElement : activeSubjectFieldElements = activeSubjectFieldsElement.split("\\.")) {
            activeSubjectObject = this.getObjectValue(activeFieldElement, activeSubjectObject);
        }
        String subjectValue = String.valueOf(activeSubjectObject);
        if (predicateElement.contains(".")) {
            String[] predicateFieldElements = predicateElement.split("\\.", 2);
            String predicateField = predicateFieldElements[this.ZERO];
            String activePredicateFields = predicateFieldElements[this.ONE];
            String[] activePredicateFieldElements = activePredicateFields.split("\\.");
            Object activePredicateObject = resp.get(predicateField);
            if (activePredicateObject != null) {
                for (String activeFieldElement : activePredicateFieldElements) {
                    activePredicateObject = this.getObjectValue(activeFieldElement, activePredicateObject);
                }
            }
            String string = String.valueOf(activePredicateObject);
            boolean passesSpecification = this.passesSpec(subjectValue, string, conditionalElement);
            return passesSpecification;
        }
        if (!predicateElement.contains("'")) {
            Object activePredicateObject = resp.get(predicateElement);
            String predicateValue = String.valueOf(activePredicateObject);
            boolean passesSpecification = this.passesSpec(subjectValue, predicateValue, conditionalElement);
            return passesSpecification;
        }
        String predicateValue = predicateElement.replaceAll("'", "");
        boolean passesSpecification = this.passesSpec(subjectValue, predicateValue, conditionalElement);
        return passesSpecification;
    }

    /*
     * WARNING - void declaration
     */
    boolean passesSpec(DataPartial specPartial, PageCache resp) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String specElementEntry = specPartial.getEntry();
        int startExpression = specElementEntry.indexOf("<plsar:if spec=\"${");
        int endExpression = specElementEntry.indexOf("}");
        int n = 0;
        String completeExpressionElement = specElementEntry.substring(startExpression + "<plsar:if spec=\"${".length(), endExpression);
        String[] allElementExpressions = completeExpressionElement.split("&&");
        String[] stringArray = allElementExpressions;
        int n2 = stringArray.length;
        if (n < n2) {
            Object activeSubjectObject;
            String subjectElementClean;
            String expressionElementClean = stringArray[n];
            String expressionElement = expressionElementClean.trim();
            String conditionalElement = this.getConditionalElement(expressionElement);
            String subjectElement = expressionElement;
            String predicateElementClean = "";
            if (!conditionalElement.equals("")) {
                String[] expressionElements = expressionElement.split(conditionalElement);
                subjectElement = expressionElements[this.ZERO].trim();
                String predicateElement = expressionElements[this.ONE];
                predicateElementClean = predicateElement.replaceAll("'", "").trim();
            }
            if (subjectElement.contains(".")) {
                void var23_37;
                Object activeMethod;
                if (predicateElementClean.equals("") && conditionalElement.equals("")) {
                    String[] activeSubjectFieldElements;
                    boolean falseActive = subjectElement.contains("!");
                    subjectElementClean = subjectElement.replace("!", "");
                    String[] subjectFieldElements = subjectElementClean.split("\\.", 2);
                    String subjectField = subjectFieldElements[this.ZERO];
                    String subjectFieldElementsRemainder = subjectFieldElements[this.ONE];
                    Object activeSubjectObject3 = resp.get(subjectField);
                    if (activeSubjectObject3 == null) {
                        return false;
                    }
                    for (String activeFieldElement : activeSubjectFieldElements = subjectFieldElementsRemainder.split("\\.")) {
                        activeSubjectObject3 = this.getObjectValue(activeFieldElement, activeSubjectObject3);
                    }
                    boolean bl = (Boolean)activeSubjectObject3;
                    if (bl && !falseActive) {
                        return true;
                    }
                    if (!bl && falseActive) {
                        return true;
                    }
                }
                if (subjectElement.contains("()")) {
                    Integer predicateNumericValue;
                    String subjectElements = subjectElement.replace("()", "");
                    String[] subjectFieldElements = subjectElements.split("\\.");
                    String subjectField = subjectFieldElements[this.ZERO];
                    String methodName = subjectFieldElements[this.ONE];
                    Object activeSubjectObject2 = resp.get(subjectField);
                    if (activeSubjectObject2 == null) {
                        return false;
                    }
                    activeMethod = activeSubjectObject2.getClass().getMethod(methodName, new Class[0]);
                    ((Method)activeMethod).setAccessible(true);
                    Object activeObjectValue = ((Method)activeMethod).invoke(activeSubjectObject2, new Object[0]);
                    if (activeObjectValue == null) {
                        return false;
                    }
                    String string = String.valueOf(activeObjectValue);
                    Integer subjectNumericValue = Integer.parseInt(string);
                    return this.getValidation(subjectNumericValue, predicateNumericValue = Integer.valueOf(Integer.parseInt(predicateElementClean)), conditionalElement, expressionElement) != false;
                }
                String[] subjectFieldElements = subjectElement.split("\\.", 2);
                String subjectField = subjectFieldElements[this.ZERO];
                String activeSubjectFields = subjectFieldElements[this.ONE];
                String[] activeSubjectFieldElements = activeSubjectFields.split("\\.");
                Object activeSubjectObject2 = resp.get(subjectField);
                if (activeSubjectObject2 == null) {
                    return false;
                }
                activeMethod = activeSubjectFieldElements;
                int activeObjectValue = ((String[])activeMethod).length;
                boolean bl = false;
                while (var23_37 < activeObjectValue) {
                    Object activeFieldElement = activeMethod[var23_37];
                    activeSubjectObject2 = this.getObjectValue((String)activeFieldElement, activeSubjectObject2);
                    ++var23_37;
                }
                String[] activePredicateFieldElements = activeSubjectFields.split("\\.");
                Object activePredicateObject = resp.get(subjectField);
                if (activePredicateObject == null) {
                    return false;
                }
                for (String activeFieldElement : activePredicateFieldElements) {
                    activePredicateObject = this.getObjectValue(activeFieldElement, activePredicateObject);
                }
                String string = String.valueOf(activeSubjectObject2);
                String predicateValue = String.valueOf(activeSubjectObject2);
                if (activeSubjectObject2 == null && !this.passesNilSpec(activeSubjectObject2, predicateValue, conditionalElement)) {
                    return false;
                }
                return this.passesSpec(string, predicateValue, conditionalElement);
            }
            if (predicateElementClean.equals("") && conditionalElement.equals("")) {
                boolean falseActive = subjectElement.contains("!");
                subjectElementClean = subjectElement.replace("!", "");
                Object activeSubjectObject4 = resp.get(subjectElementClean);
                if (activeSubjectObject4 == null) {
                    return false;
                }
                boolean activeSubjectObjectBoolean = (Boolean)activeSubjectObject4;
                if (!activeSubjectObjectBoolean && falseActive) {
                    return true;
                }
                if (activeSubjectObjectBoolean && !falseActive) {
                    return true;
                }
            }
            if (!predicateElementClean.equals("")) {
                activeSubjectObject = resp.get(subjectElement);
                if (!predicateElementClean.contains(".") && activeSubjectObject == null) {
                    return this.passesNilSpec(activeSubjectObject, predicateElementClean, conditionalElement);
                }
                String[] predicateFieldElements = predicateElementClean.split("\\.", 2);
                String predicateField = predicateFieldElements[this.ZERO];
                String predicateFieldElementsRemainder = predicateFieldElements[this.ONE];
                String[] activePredicateFieldElements = predicateFieldElementsRemainder.split("\\.");
                Object activePredicateObject = resp.get(predicateField);
                for (String activeFieldElement : activePredicateFieldElements) {
                    activePredicateObject = this.getObjectValue(activeFieldElement, activePredicateObject);
                }
                String subjectValue = String.valueOf(activeSubjectObject).trim();
                String string = String.valueOf(activePredicateObject).trim();
                if (activeSubjectObject == null) {
                    return this.passesNilSpec(activeSubjectObject, string, conditionalElement);
                }
                return this.passesSpec(subjectValue, string, conditionalElement);
            }
            activeSubjectObject = resp.get(subjectElement);
            String subjectValue = String.valueOf(activeSubjectObject).trim();
            if (activeSubjectObject == null) {
                return this.passesNilSpec(activeSubjectObject, predicateElementClean, conditionalElement);
            }
            return this.passesSpec(subjectValue, predicateElementClean, conditionalElement);
        }
        return true;
    }

    boolean passesNilSpec(Object activeSubjectObject, Object activePredicateObject, String conditionalElement) {
        if (activeSubjectObject == null && activePredicateObject.equals("null") && conditionalElement.equals("==")) {
            return true;
        }
        if (activeSubjectObject == null && activePredicateObject.equals("null") && conditionalElement.equals("!=")) {
            return false;
        }
        if (activeSubjectObject == null && activePredicateObject.equals("") && conditionalElement.equals("==")) {
            return true;
        }
        if (activeSubjectObject == null && activePredicateObject.equals("") && conditionalElement.equals("")) {
            return false;
        }
        if (activeSubjectObject == null && activePredicateObject.equals("") && conditionalElement.equals("!=")) {
            return false;
        }
        return false;
    }

    boolean passesSpec(String subjectValue, String predicateValue, String conditionalElement) {
        if (subjectValue.equals(predicateValue) && conditionalElement.equals("==")) {
            return true;
        }
        if (subjectValue.equals(predicateValue) && conditionalElement.equals("!=")) {
            return false;
        }
        if (!subjectValue.equals(predicateValue) && conditionalElement.equals("!=")) {
            return true;
        }
        if (!subjectValue.equals(predicateValue) && conditionalElement.equals("==")) {
            return false;
        }
        return false;
    }

    Boolean getValidation(Integer subjectValue, Integer predicateValue, String condition, String expressionElement) {
        if (condition.equals(">") ? subjectValue > predicateValue : condition.equals("==") && subjectValue.equals(predicateValue)) {
            return true;
        }
        return false;
    }

    String getConditionalElement(String expressionElement) {
        if (expressionElement.contains(">")) {
            return ">";
        }
        if (expressionElement.contains("<")) {
            return "<";
        }
        if (expressionElement.contains("==")) {
            return "==";
        }
        if (expressionElement.contains(">=")) {
            return ">=";
        }
        if (expressionElement.contains("<=")) {
            return "<=";
        }
        if (expressionElement.contains("!=")) {
            return "!=";
        }
        return "";
    }

    IterableResult getIterableResultNested(String entry, Object activeSubjectObject) throws NoSuchFieldException, IllegalAccessException {
        String[] activeSubjectFieldElements;
        int startEach = entry.indexOf(this.FOREACH);
        int startIterate = entry.indexOf("items=", startEach + 1);
        int endIterate = entry.indexOf("\"", startIterate + 7);
        String iterableKey = entry.substring(startIterate + 9, endIterate - 1);
        String iterablePadded = "${" + iterableKey + "}";
        int startField = iterablePadded.indexOf(".");
        int endField = iterablePadded.indexOf("}", startField);
        String activeSubjectFieldElement = iterablePadded.substring(startField + 1, endField);
        int startItem = entry.indexOf("var=", endIterate);
        int endItem = entry.indexOf("\"", startItem + 5);
        String activeField = entry.substring(startItem + 5, endItem);
        for (String activeFieldElement : activeSubjectFieldElements = activeSubjectFieldElement.split("\\.")) {
            activeSubjectObject = this.getObjectValue(activeFieldElement, activeSubjectObject);
        }
        IterableResult iterableResult = new IterableResult();
        iterableResult.setField(activeField);
        iterableResult.setMojos((List)activeSubjectObject);
        return iterableResult;
    }

    private IterableResult getIterableResult(String entry, PageCache httpResponse) throws NoSuchFieldException, IllegalAccessException {
        int startEach = entry.indexOf(this.FOREACH);
        int startIterate = entry.indexOf("items=", startEach);
        int endIterate = entry.indexOf("\"", startIterate + 7);
        String iterableKey = entry.substring(startIterate + 9, endIterate - 1);
        int startItem = entry.indexOf("var=", endIterate);
        int endItem = entry.indexOf("\"", startItem + 6);
        String activeField = entry.substring(startItem + 5, endItem);
        String expression = entry.substring(startIterate + 7, endIterate);
        ArrayList pojos = new ArrayList();
        if (iterableKey.contains(".")) {
            pojos = this.getIterableInitial(expression, httpResponse);
        } else if (httpResponse.getCache().containsKey(iterableKey)) {
            pojos = (ArrayList)httpResponse.get(iterableKey);
        }
        IterableResult iterableResult = new IterableResult();
        iterableResult.setField(activeField);
        iterableResult.setMojos(pojos);
        return iterableResult;
    }

    private List<Object> getIterableInitial(String expression, PageCache httpResponse) throws NoSuchFieldException, IllegalAccessException {
        int startField = expression.indexOf("${");
        int endField = expression.indexOf(".", startField);
        String key = expression.substring(startField + 2, endField);
        if (httpResponse.getCache().containsKey(key)) {
            Object obj = httpResponse.get(key);
            List<Object> objList = this.getIterableRecursive(expression, obj);
            return (ArrayList)objList;
        }
        return new ArrayList<Object>();
    }

    private List<Object> getIterableRecursive(String expression, Object activeSubjectObject) throws NoSuchFieldException, IllegalAccessException {
        String[] activeSubjectFieldElements;
        ArrayList<Object> objs = new ArrayList<Object>();
        int startField = expression.indexOf(".");
        int endField = expression.indexOf("}");
        String activeSubjectFielElement = expression.substring(startField + 1, endField);
        for (String activeFieldElement : activeSubjectFieldElements = activeSubjectFielElement.split("\\.")) {
            activeSubjectObject = this.getObjectValue(activeFieldElement, activeSubjectObject);
        }
        if (activeSubjectObject != null) {
            return (ArrayList)activeSubjectObject;
        }
        return objs;
    }

    private Object getIterableValueRecursive(int idx, String baseField, Object baseObj) throws NoSuchFieldException, IllegalAccessException {
        String[] fields = baseField.split("\\.");
        if (fields.length > 1) {
            ++idx;
            String key = fields[0];
            Field fieldObj = baseObj.getClass().getDeclaredField(key);
            if (fieldObj != null) {
                fieldObj.setAccessible(true);
                Object obj = fieldObj.get(baseObj);
                int start = baseField.indexOf(".");
                String fieldPre = baseField.substring(start + 1);
                if (obj != null) {
                    return this.getValueRecursive(idx, fieldPre, obj);
                }
            }
        } else {
            Field fieldObj = baseObj.getClass().getDeclaredField(baseField);
            if (fieldObj != null) {
                fieldObj.setAccessible(true);
                Object obj = fieldObj.get(baseObj);
                if (obj != null) {
                    return obj;
                }
            }
        }
        return new ArrayList();
    }

    private Object getValueRecursive(int idx, String baseField, Object baseObj) throws NoSuchFieldException, IllegalAccessException {
        String[] fields = baseField.split("\\.");
        if (fields.length > 1) {
            ++idx;
            String key = fields[0];
            Field fieldObj = baseObj.getClass().getDeclaredField(key);
            fieldObj.setAccessible(true);
            Object obj = fieldObj.get(baseObj);
            int start = baseField.indexOf(".");
            String fieldPre = baseField.substring(start + 1);
            if (obj != null) {
                return this.getValueRecursive(idx, fieldPre, obj);
            }
        } else {
            try {
                Field fieldObj = baseObj.getClass().getDeclaredField(baseField);
                fieldObj.setAccessible(true);
                Object obj = fieldObj.get(baseObj);
                if (obj != null) {
                    return obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    List<LineComponent> getPageLineComponents(String pageElementEntry) {
        ArrayList<LineComponent> lineComponents = new ArrayList<LineComponent>();
        Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z+\\.+\\(\\a-zA-Z+)]*\\}");
        Matcher matcher = pattern.matcher(pageElementEntry);
        while (matcher.find()) {
            String cleanElement;
            LineComponent lineComponent = new LineComponent();
            String lineElement = matcher.group();
            String activeField = cleanElement = lineElement.replace("${", "").replace("}", "");
            String objectField = "";
            if (cleanElement.contains(".")) {
                String[] elements = cleanElement.split("\\.", 2);
                activeField = elements[0];
                objectField = elements[1];
            }
            lineComponent.setActiveField(activeField);
            lineComponent.setObjectField(objectField);
            lineComponent.setLineElement(cleanElement);
            lineComponents.add(lineComponent);
        }
        return lineComponents;
    }

    String getResponseValueLineComponent(String activeField, String objectField, PageCache resp) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (objectField.contains(".")) {
            Object activeObject = resp.get(activeField);
            if (activeObject != null) {
                String[] activeObjectFields;
                for (String activeObjectField : activeObjectFields = objectField.split("\\.")) {
                    activeObject = this.getObjectValue(activeObjectField, activeObject);
                }
                if (activeObject == null) {
                    return null;
                }
                return String.valueOf(activeObject);
            }
        } else {
            Object respValue = resp.get(activeField);
            if (respValue != null && !objectField.equals("") && !objectField.contains(".")) {
                Object objectValue = null;
                if (objectField.contains("()")) {
                    String methodName = objectField.replace("()", "");
                    Method methodObject = respValue.getClass().getDeclaredMethod(methodName, new Class[0]);
                    methodObject.setAccessible(true);
                    if (methodObject != null) {
                        objectValue = methodObject.invoke(respValue, new Object[0]);
                    }
                } else {
                    if (this.isObjectMethod(respValue, objectField)) {
                        Object activeObject = this.getObjectMethodValue(resp, respValue, objectField);
                        if (activeObject == null) {
                            return null;
                        }
                        return String.valueOf(activeObject);
                    }
                    objectValue = this.getObjectValue(objectField, respValue);
                }
                if (objectValue == null) {
                    return null;
                }
                return String.valueOf(objectValue);
            }
            if (respValue == null) {
                return null;
            }
            return String.valueOf(respValue);
        }
        return null;
    }

    boolean passesSpec(Object object, DataPartial specPartial, DataPartial dataPartial, PageCache resp) throws NoSuchMethodException, PlsarException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        if (dataPartial.isWithinIterable() && this.passesIterableSpec(specPartial, object, resp)) {
            return true;
        }
        return !dataPartial.isWithinIterable() && this.passesSpec(specPartial, resp);
    }

    Object getObjectMethodValue(PageCache resp, Object respValue, String objectField) throws InvocationTargetException, IllegalAccessException {
        Method activeMethod = this.getObjectMethod(respValue, objectField);
        String[] parameters = this.getMethodParameters(objectField);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int foo = 0; foo < parameters.length; ++foo) {
            String parameter = parameters[foo].trim();
            Object parameterValue = resp.get(parameter);
            values.add(parameterValue);
        }
        Object activeObjectValue = activeMethod.invoke(respValue, values.toArray());
        return activeObjectValue;
    }

    String[] getMethodParameters(String objectField) {
        String[] activeMethodAttributes = objectField.split("\\(");
        String methodParameters = activeMethodAttributes[this.ONE];
        String activeMethod = methodParameters.replace("(", "").replace(")", "");
        String[] parameters = activeMethod.split(",");
        return parameters;
    }

    Method getObjectMethod(Object activeObject, String objectField) {
        String[] activeMethodAttributes = objectField.split("\\(");
        String activeMethodName = activeMethodAttributes[this.ZERO];
        Method[] activeObjectMethods = activeObject.getClass().getDeclaredMethods();
        Method activeMethod = null;
        for (Method activeObjectMethod : activeObjectMethods) {
            if (!activeObjectMethod.getName().equals(activeMethodName)) continue;
            activeMethod = activeObjectMethod;
            break;
        }
        return activeMethod;
    }

    boolean isObjectMethod(Object respValue, String objectField) {
        Method[] activeObjectMethods;
        String[] activeMethodAttributes = objectField.split("\\(");
        String activeMethodName = activeMethodAttributes[this.ZERO];
        for (Method activeMethod : activeObjectMethods = respValue.getClass().getDeclaredMethods()) {
            if (!activeMethod.getName().equals(activeMethodName)) continue;
            return true;
        }
        return false;
    }

    String getObjectValueForLineComponent(String objectField, Object object) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        if (objectField.contains(".")) {
            String[] objectFields = objectField.split("\\.");
            Object activeObject = object;
            for (String activeObjectField : objectFields) {
                activeObject = this.getObjectValue(activeObjectField, activeObject);
            }
            if (activeObject == null) {
                return "";
            }
            return String.valueOf(activeObject);
        }
        if (this.hasDeclaredField(objectField, object)) {
            Object objectValue = this.getObjectValue(objectField, object);
            if (objectValue == null) {
                return null;
            }
            return String.valueOf(objectValue);
        }
        return String.valueOf(object);
    }

    boolean hasDeclaredField(String objectField, Object object) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = object.getClass().getDeclaredFields()) {
            if (!declaredField.getName().equals(objectField)) continue;
            return true;
        }
        return false;
    }

    Object getObjectValue(String objectField, Object object) throws NoSuchFieldException, IllegalAccessException {
        Field fieldObject = object.getClass().getDeclaredField(objectField);
        fieldObject.setAccessible(true);
        Object objectValue = fieldObject.get(object);
        return objectValue;
    }
}

